/*
DialUpU - DialUp Utility
Copyright 1999, 2000 by Chuck McKinnis,  Sandia Park, NM (USA)
mckinnis@attglobal.net
*/

Trace 'N'
version = '1.34'
what_r_we = 'DialUp v'||version 'Copyright 1999, 2000 by Charles H. McKinnis'

If Load_funcs() Then
   Do
      If Setup() Then
         Do
            vlist = ''
            Do Until vlist <> 'OK'
               vlist. = ''
               d = 0
               d = d + 1; vlist.d = 'Select an option for the DialUp Utility command:'
               d = d + 1; vlist.d = '   Display all the parameters'
               vlist.vstring = vlist.d
               d = d + 1; vlist.d = '   Create a launch object'
               d = d + 1; vlist.d = '   Update an existing launch object'
               d = d + 1; vlist.d = '   Delete an existing launch object'
               d = d + 1; vlist.d = '   Backup the launch object folder'
               d = d + 1; vlist.d = '   Restore the backup of the launch object folder'
               d = d + 1; vlist.d = '   Setup all dialer parameters'
               d = d + 1; vlist.d = '   Exit the DialUp Utility'
               vlist.0 = d
               vdeep = d
               vtitle = what_r_we
               vlist = Listbox(vtitle, Min(vdeep, 10), 3)
               If vlist = 'OK' Then
                  Do
                     Parse Var vlist.vstring parms .
                     parms = Strip(parms)
                     showstatus = Abbrev(parms, 'Display')
                     create_new = Abbrev(parms, 'Create')
                     update_old = Abbrev(parms, 'Update')
                     delete_old = Abbrev(parms, 'Delete')
                     backup_current = Abbrev(parms, 'Backup')
                     restore_old = Abbrev(parms, 'Restore')
                     setup_new = Abbrev(parms, 'Set')
                     exit_dialup = Abbrev(parms, 'Exit')
                     Select
                        When showstatus Then
                           Call Showstatus
                        When create_new Then
                           Call Create_object
                        When update_old Then
                           Call Update_object
                        When delete_old Then
                           Call Delete_object
                        When backup_current Then
                           Call Backup_folder
                        When restore_old Then
                           Call Restore_folder
                        When setup_new Then
                           Do
                              Call Setup
                              Call Showstatus
                           End
                        When exit_dialup Then
                           vlist = 'CANCEL'
                        Otherwise Nop
                     End
                  End
            End
         End
      Else
         Do
            Call Cleanup
            Return 0
         End
   End
Else
   Do
      Call Cleanup
      Return 0
   End

Call Cleanup
Return 0

Setup:
obj_view = 'DEFAULT'
obj_flag = 'TRUE'
ini_error = 'ERROR:'

ini_file = cmd_dir || '\dialup.ini'
log_file = cmd_dir || '\dialup.log'
dialup_exec = Stream('dialup.cmd', 'c', 'query exists')

action = Strip(Strip(action, , '"'). ."'")

create_new = 0
update_old = 0
delete_old = 0
backup_current = 0
restore_old = 0
setup_new = 0

Parse Value(Getdialerobjectid('InJoy', 'injoy')) With ini_rc injoy_object injoy_host injoy_path injoy_exe injoy_name
If ini_rc = 0 Then
   Return ini_rc
injoy_dialer = (injoy_object <> null)

If injoy_dialer Then
   Do
      x = 0
      injoy_hosts. = ''
      injoy_hosts.0 = 0
      default_host_file = injoy_path || '\default.cfg'
      hosts_dat_file = injoy_path || '\hosts.dat'
      If Fileexists(default_host_file) Then
         Do
            x = x + 1
            injoy_hosts.x = 'default'
            injoy_hosts.0 = x
         End
      If Fileexists(hosts_dat_file) Then
         Do
            hosts_dat = ''
            Do While Chars(hosts_dat_file) > 0
               hosts_dat = hosts_dat || Charin(hosts_dat_file)
            End
            Do Until hosts_dat = ''
               Parse Var hosts_dat host_rec 1178 hosts_dat
               Parse Var host_rec . 485 host_name + 8 .
               x = x + 1
               injoy_hosts.x = Space(Translate(host_name, , '5F'x, ' '))
               injoy_hosts.0 = x
            End
         End

      injoy_host = SysIni(ini_file, 'injoy', 'hostid')
      If (injoy_host = ini_error) | (injoy_host = null) Then
         Do Until rc_file
            rc_file = 0
            injoy_host = Selecthost()
            If injoy_host <> '' Then
               Do
                  rc_file = 1
                  rc_ini = SysIni(ini_file, 'injoy', 'hostid', injoy_host)
               End
         End
      Else
         Do
            If setup_new Then
               Do
                  d = 0
                  d = d + 1; vtext.d = 'The current InJoy default host is' injoy_host
                  d = d + 1; vtext.d = 'Press "OK" to keep the current configuration file'
                  d = d + 1; vtext.d = 'Press "CANCEL" to select a new configuration file'
                  vtext.0 = d
                  vtitle = what_r_we
                  vbox = VMsgBox(vtitle, vtext, 3)
                  If vbox = 'CANCEL' Then
                     Do
                        injoy_new_host = Selecthost()
                        If (injoy_new_host <> '') & (injoy_new_host <> injoy_host) Then
                           Call SysIni ini_file, 'injoy', 'hostid', injoy_host
                     End
               End
         End
   End

Parse Value(Getdialerobjectid('AT&T', 'ibm')) With ini_rc ibm_object ibm_host ibm_path ibm_exe ibm_name
If ini_rc = 0 Then
   Return ini_rc
ibm_dialer = (ibm_object <> null)

dialup_folder = '<WP_DIALUP>'; dialup_title = 'DialUp'
dialup_launch_folder = '<WP_DIALUP_LAUNCH>'; dialup_launch_title = 'DialUp Launch Objects'
dialup_target_folder = '<WP_DIALUP_TARGETS>'; dialup_target_title = 'DialUp Target Objects'
error_text = 'Unable to locate DialUp folder'
If \Objectexists(dialup_folder) Then
   Do
      vbox = Errorbox(error_text dialup_title)
      Return 0
   End
If \Objectexists(dialup_launch_folder) Then
   Do
      vbox = Errorbox(error_text dialup_launch_title)
      Return 0
   End
If \Objectexists(dialup_target_folder) Then
   Do
      vbox = Errorbox(error_text dialup_target_title)
      Return 0
   End

Return 1

Showstatus:
vlist. = ''
d = 0
d = d + 1; vlist.d = 'DialUp Status'
If injoy_dialer Then
   Do
      d = d + 1; vlist.d = '   The object name for the InJoy dialer is -' injoy_object
      d = d + 1; vlist.d = '   The path to the InJoy dialer is -' injoy_path
      d = d + 1; vlist.d = '   The host for this InJoy session is -' injoy_host
      d = d + 1; vlist.d = '   The exe name for the InJoy session is -' injoy_exe
      If Check_dialer_task('INJOY', injoy_exe) Then
         Do
            dialer_stat = '   The InJoy dialer is active'
            If Dialupq('INJOY') Then
               dialer_stat = dialer_stat 'and connected'
            Else
               dialer_stat = dialer_stat 'but disconnected'
         End
      Else
         Do
            dialer_stat = '   The InJoy dialer is not active'
         End
      d = d + 1; vlist.d = dialer_stat
      d = d + 1; vlist.d = ' '
   End
If ibm_dialer Then
   Do
      d = d + 1; vlist.d = '   The object name for the AT&T dialer is -' ibm_object
      d = d + 1; vlist.d = '   The path to the AT&T dialer is -' ibm_path
      d = d + 1; vlist.d = '   The exe name for the AT&T session is -' ibm_exe
      If Check_dialer_task('IBM', ibm_exe) Then
         Do
            dialer_stat = '   The AT&T dialer is active'

            If Dialupq('IBM') Then
               dialer_stat = dialer_stat 'and connected'
            Else
               dialer_stat = dialer_stat 'but disconnected'
         End
      Else
         dialer_stat = '   The AT&T dialer is not active'
      d = d + 1; vlist.d = dialer_stat
   End
d = d + 1; vlist.d = ' '
d = d + 1; vlist.d = '   The current DialUp configuration file is -' ini_file
d = d + 1; vlist.d = '   The current DialUp log file is -' log_file
vlist.0 = d
vtitle = what_r_we
vlist = Listbox(vtitle, Min(d, 10), 1)
Return 0

Create_object:
save_trace = Trace('N')
target_object = Findobject('Select a target object for DialUp to launch')
Call Do_object
Trace(save_trace)
Return 0

Update_object:
save_trace = Trace('N')
target_object = Findobject('Select a target object to update', dialup_launch_folder)
Call Do_object
Trace(save_trace)
Return 0

Delete_object:
save_trace = Trace('N')
target_object = Findobject('Select a target object to delete', dialup_launch_folder)
Call Do_object
Trace(save_trace)
Return 0

Do_object:
save_trace = Trace('N')
If target_object <> '' Then
   Do
      title = Objtitle(sztitle)
      If create_new | update_old Then
         Do
            vlist. = ''
            d = 0
            d = d + 1
            If create_new Then
               Do
                  vlist.d = 'Create a launch object for' target_object '-' title || '?'
                  vtitle = 'Ready to create launch object'
               End
            Else
               Do
                  vlist.d = 'Update launch object -' target_object '-' title || '?'
                  vtitle = 'Ready to update launch object'
               End
            vlist.0 = d
            vlist = Listbox(vtitle, Min(d, 10), 3)
            If vlist = 'OK' Then
               Do
                  d = 0
                  d = d + 1; vtext.d = 'Enter a title for the launch object, or'
                  d = d + 1; vtext.d = 'press "OK" to accept' title
                  d = d + 1; vtext.d = 'as the title of the launch object'
                  vtext.0 = d
                  vtext.vstring = title
                  vwide = Length(vtext.vstring) + 10
                  vbox = VInputBox(vtitle, vtext, vwide, 1)
                  If vbox = 'OK' Then
                     title = vtext.vstring
                  vlist. = ''
                  d = 0
                  If injoy_dialer Then
                     Do
                        d = d + 1; vlist.d = '   InJoy Dialer'
                     End
                  If ibm_dialer Then
                     Do
                        d = d + 1; vlist.d = '   AT&T Dialer'
                     End
                  vlist.0 = d
                  vtitle = 'Select a dialer for' title
                  vlist = Listbox(vtitle, Min(d, 10), 3)
                  If vlist = 'OK' Then
                     Do
                        Parse Var vlist.vstring dialer_parm .
                        dialer_parm = Space(dialer_parm)
                        d = 0
                        d = d + 1; vtext.d = 'Should' title 'be started'
                        d = d + 1; vtext.d = 'before the' dialer_parm 'dialer has connected ?'
                        d = d + 1; vtext.d = ''
                        d = d + 1; vtext.d = 'If' title 'accesses the Internet'
                        d = d + 1; vtext.d = 'when it is opened, you should answer NO'
                        vtext.0 = d
                        vtitle = title
                        vbox = VMsgBox(vtitle, vtext, 6)
                        If vbox = 'NO' Then
                           dialer_wait = 1
                        Else
                           dialer_wait = 0
                        dialer_parm = Translate(dialer_parm)
                        If dialer_parm = 'AT&T' Then
                           dialer_parm = 'IBM'
                        If dialer_parm = 'INJOY' Then
                           Do
                              d = 0
                              d = d + 1; vtext.d = 'Do you want to use the InJoy configuration'
                              d = d + 1; vtext.d = injoy_host 'for' title || '?'
                              vtext.0 = d
                              vtitle = what_r_we
                              vbox = VMsgBox(vtitle, vtext, 6)
                              If vbox = 'NO' Then
                                 Do
                                    injoy_new_host = Selecthost()
                                    If (injoy_new_host <> '') & injoy_new_host <> injoy_host Then
                                       injoy_new_host = '-H:' || injoy_new_host
                                    Else
                                       injoy_new_host = ''
                                 End
                              Else
                                 injoy_new_host = ''
                           End
                        Else
                           injoy_new_host = ''
                        target_parms = dialer_parm
                        If create_new Then
                           Do
                              obj_dialup = '<DialUp_' || Strip(target_object, , '<')
                              target_parms = target_parms '"' || Strip(target_object) || '"'
                           End
                        Else
                           Do
                              obj_dialup = target_object
                              Parse Value('.' old_setup_parms) With . '<' old_target_object '>' .
                              target_parms = target_parms '"<' || Strip(old_target_object) || '>"'
                           End
                        If injoy_new_host <> '' Then
                           target_parms = Space(target_parms injoy_new_host)
                        If dialer_wait Then
                           target_parms = target_parms '-W'
                        Else
                           target_parms = target_parms '-NW'
                        d = 0
                        d = d + 1
                        If create_new Then
                           vtext.d = 'Ready to create new launch object'
                        Else
                           vtext.d = 'Ready to update launch object'
                        vtext.0 = d
                        vtitle = title
                        vbox = VMsgBox(vtitle, vtext, 3)
                        If vbox = 'OK' Then
                           Do
                              If create_new Then
                                 Do
                                    class = 'WPProgram'
                                    location = dialup_launch_folder
                                    obj = 'OBJECTID=' || obj_dialup || ';'
                                    exec = 'EXENAME=' || dialup_exec || ';'
                                    object_parms = 'PARAMETERS=' || Strip(target_parms) || ';MINIMIZED=YES;'
                                    Parse Value Gettargeticon(target_object) With icon_data
                                    If icon_data \= '' Then
                                       object_parms = object_parms || icon_data
                                    object_parms = obj || exec || object_parms
                                    If SysCreateObject(class, title, location, object_parms, 'U') Then
                                       Do
                                          If icon_data = '' Then
                                             Call Copyicon target_folder, target_object, obj_dialup
                                          d = 0
                                          d = d + 1; vtext.d = 'Would you like to move the target object'
                                          d = d + 1; vtext.d = target_object 'to' dialup_target_title || '?'
                                          vtext.0 = d
                                          vtitle = 'Move target object?'
                                          vbox = VMsgBox(vtitle, vtext, 6)
                                          If vbox = 'YES' Then
                                             Call SysMoveObject target_object, dialup_target_folder
                                          vbox = Infobox(title 'created')
                                       End
                                    Else
                                       vbox = Infobox('Failed to create' title)
                                 End
                              Else
                                 Do
                                    If dialup_exec <> old_dialup_exec ,
                                       | target_parms <> old_setup_parms Then
                                       Do
                                          If dialup_exec <> old_dialup_exec Then
                                             exec = 'EXENAME=' || dialup_exec || ';'
                                          Else
                                             exec = ''
                                          If target_parms <> old_setup_parms Then
                                             object_parms = 'PARAMETERS=' || Strip(target_parms) || ';'
                                          Else
                                             object_parms = ''
                                          object_parms = exec || object_parms
                                          If SysSetObjectData(target_object, object_parms) Then
                                             vbox = Infobox(title 'updated')
                                          Else
                                             vbox = Infobox('Failed to update' title)
                                       End
                                    Else
                                       vbox = Infobox('No changes are required for' title)
                                 End
                           End
                        Else
                           vbox = Infobox('Create/Update of' title 'cancelled')
                     End
                  Else
                     vbox = Infobox('Create/Update of' title 'cancelled')
               End
            Else
               Do
                  If create_new Then
                     vbox = Infobox('Creation of DialUp launch object bypassed for' target_object)
                  Else
                     vbox = Infobox('Update of DailUp launch object bypassed for' title)
               End
         End
      Else
         Do
            d = 0
            d = d + 1; vtext.d = 'Delete launch object -' title || '?'
            vtext.0 = d
            vtitle = 'Ready to delete launch object'
            vbox = VMsgBox(vtitle, vtext, 3)
            If vbox = 'OK' Then
               Do
                  d = 0
                  d = d + 1; vtext.d = 'Confirm deletion of' title
                  vtext.0 = d
                  vtitle = title
                  vbox = VMsgBox(vtitle, vtext, 3)
                  If vbox = 'OK' Then
                     Do
                        If SysDestroyObject(target_object) Then
                           vbox = Infobox(title 'deleted')
                        Else
                           vbox = Infobox('Deletion of -' title 'failed')
                     End
                  Else
                     vbox = Infobox('Deletion of -' title 'cancelled')
               End
            Else
               vbox = Infobox('Deletion of launch object -' title 'bypassed')
         End
   End
Else
   vbox = Infobox('No object selected')
vlist = 'OK'
Trace(save_trace)
Return 0

Cleanup:
save_trace = Trace('N')
If Fileexists(icon_temp) Then
   Call SysFileDelete icon_temp
If \Rxfuncquery('Vexit') Then
   Call VExit
Do While RxPIDLst('vrexx.exe', 'k')
End
Call Directory cur_dir
Trace(save_trace)
Return 0

Load_funcs:
Parse Source . . cmd_file .
cmd_name = Filespec('N', cmd_file)
cmd_name = Left(cmd_name, Lastpos('.', cmd_name) - 1)
cmd_dir = Left(cmd_file, Lastpos('\', cmd_file) - 1)
cur_dir = Directory()
Call Directory cmd_dir

null = 'null'

If Rxfuncquery('SysDropFuncs') Then
   Call Rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

Call Rxfuncadd 'VInit', 'VREXX', 'VINIT'
vrexx_init = VInit()
If vrexx_init = 'ERROR' Then
   Do
      vrexx_ver = VGetVersion()
      If vrexx_ver <> '1.1' Then
         Do
            If \Rxfuncquery('Vexit') Then
               Call VExit
            Do While RxPIDLst('vrexx.exe', 'k')/* try to kill and initialize */
            End
            Call Rxfuncadd 'VInit', 'VREXX', 'VINIT'
            vrexx_init = VInit()
            If vrexx_init = 'ERROR' Then
               Do
                  Say 'Unable to initialize VRexx'
                  Return 0
               End
         End
   End

Call VDialogPos 50, 67

If Rxfuncquery('WPToolsLoadFuncs') Then
   Do
      rc_func = Rxfuncadd('WPToolsLoadFuncs', 'WPTOOLS', 'WPToolsLoadFuncs')
      If rc_func = 0 Then
         Call WPToolsLoadFuncs
      Else
         Do
            vbox = Errorbox('Unable to register WPToolsLoadFuncs')
            Return 0
         End
   End
Else
   Call WPToolsLoadFuncs

dialer_queues = 'DIALUP_INJOY DIALUP_IBM'
Do i = 1 To Words(dialer_queues)
   dialer_queue = Word(dialer_queues, i)
   new_queue = Rxqueue('create', dialer_queue)
   /* delete new queue if the one wanted already exists */
   If new_queue <> dialer_queue Then
      Call Rxqueue 'delete', dialer_queue
End

Return 1

/* set up dialer object id */
Getdialerobjectid:
Procedure Expose what_r_we ini_file setup_new ini_error null szclass ,
   sztitle szsetupstring target_folder update_old old_dialup_exec old_setup_parms
save_trace = Trace('N')
Parse Arg dialer_title, dialer_appl
object_exe = ''
object_path = ''
object_title = ''
objectid = SysIni(ini_file, dialer_appl, 'objectid')
If objectid = ini_error Then
   Do
      objectid = null
      Call SysIni ini_file, dialer_appl, 'objectid', objectid
   End
hostid = SysIni(ini_file, dialer_appl, 'hostid')
If hostid = ini_error Then
   Do
      hostid = null
      Call SysIni ini_file, dialer_appl, 'hostid', hostid
   End
If objectid = null Then
   Do
      d = 0
      d = d + 1; vtext.d = 'Support the' dialer_title 'Dialer?'
      vtext.0 = d
      vtitle = what_r_we
      vbox = VMsgBox(vtitle, vtext, 6)
      If vbox = 'YES' Then
         Do
            rc_object = 0
            Do Until rc_object
               vtitle = 'Please select your' dialer_title 'Dialer object'
               objectid = Findobject(vtitle)
               d = 0
               d = d + 1; vtext.d = 'Press "OK" to use the' dialer_title 'Dialer object'
               d = d + 1; vtext.d = 'or press "CANCEL" to exit'
               vtext.0 = d
               vtitle = 'The' dialer_title 'Dialer object selected is' objectid
               vbox = VMsgBox(vtitle, vtext, 3)
               If vbox = 'OK' Then
                  Do
                     Call SysIni ini_file, dialer_appl, 'objectid', objectid
                     Call SysIni ini_file, dialer_appl, 'hostid', hostid
                     rc_object = 1
                  End
               Else
                  Do
                     objectid = null
                     Call SysIni ini_file, dialer_appl, 'objectid', objectid
                     hostid = null
                     Call SysIni ini_file, dialer_appl, 'hostid', hostid
                     vbox = Errorbox('Exiting DialUp Utility')
                     rc_object = 0
                  End
            End
         End
      Else
         Do
            objectid = null
            Call SysIni ini_file, dialer_appl, 'objectid', objectid
            hostid = null
            Call SysIni ini_file, dialer_appl, 'hostid', hostid
            rc_object = 1
         End
   End
Else
   Do
      rc_object = 1
      If setup_new Then
         Do
            d = 0
            d = d + 1; vtext.d = 'Support the' dialer_title 'Dialer?'
            vtitle = what_r_we
            vbox = VMsgBox(vtitle, vtext, 6)
            If vbox = 'YES' Then
               Do
                  d = 0
                  d = d + 1; vtext.d = 'The current' dialer_title 'Dialer object is' objectid
                  d = d + 1; vtext.d = 'Press "OK" to use the' dialer_title 'object'
                  d = d + 1; vtext.d = 'or press "CANCEL" to select a new object'
                  vtext.0 = d
                  vtitle = what_r_we
                  vbox = VMsgBox(vtitle, vtext, 3)
                  If vbox = 'CANCEL' Then
                     Do
                        vtitle = 'Please select your' dialer_title 'Dialer object'
                        new_objectid = Findobject(vtitle)
                        d = 0
                        d = d + 1; vtext.d = 'Press "OK" to accept' new_objectid 'as the' dialer_title 'Dialer object'
                        d = d + 1; vtext.d = 'or press "CANCEL" to keep' objectid 'as the' dialer_title 'Dialer object'
                        vtext.0 = d
                        vtitle = 'The' dialer_title 'Dialer object selected is' new_objectid
                        vbox = VMsgBox(vtitle, vtext, 3)
                        If vbox = 'OK' Then
                           Do
                              objectid = new_objectid
                              Call SysIni ini_file, dialer_appl, 'objectid', objectid
                              hostid = null
                              Call SysIni ini_file, dialer_appl, 'hostid', hostid
                              rc_object = 1
                           End
                     End
               End
            Else
               Do
                  objectid = null
                  Call SysIni ini_file, dialer_appl, 'objectid', objectid
                  hostid = null
                  Call SysIni ini_file, dialer_appl, 'hostid', hostid
                  rc_object = 1
               End
         End
   End
If rc_object & objectid <> null Then
   Do
      Call WPToolsQueryObject objectid, 'szClass', 'szTitle', 'szSetupString'
      Parse Var szsetupstring program 'EXENAME=' object_path ';' .
      object_path = Strip(object_path)
      If Pos(':', object_path) = 0 Then
         object_path = SysSearchPath('path', object_exe)
      If object_path <> '' Then
         Do
            If dialer_title = 'ATT' & ,
               Pos('TCPDIAL', Translate(object_path)) = 0 Then
               Do
                  vbox = Errorbox('The old ATT dialer is not supported')
                  objectid = null
                  Call SysIni ini_file, dialer_appl, 'objectid', objectid
                  hostid = null
                  Call SysIni ini_file, dialer_appl, 'hostid', hostid
               End
            object_exe = object_path
            object_path = Left(object_path, Lastpos('\', object_path) - 1)
            object_title = Objtitle(sztitle)
         End
      Else
         rc_object = 0
   End
Trace(save_trace)
Return Space(rc_object objectid hostid object_path object_exe object_title)

Selecthost: Procedure Expose injoy_hosts.
injoy_host = ''
vlist. = ''
x = 0
If injoy_host.0 <> 0 Then
   Do
      Do i = 1 To injoy_hosts.0
         x = x + 1; vlist.x = x injoy_hosts.i
         vlist.0 = x
      End
      vlist.vstring = vlist.1
      vtitle = 'Select the InJoy host to be used'
      vdeep = vlist.0
      vlist = Listbox(vtitle, Min(vdeep, 10), 3)
      If vlist = 'OK' Then
         Parse Var vlist.vstring ans injoy_host
   End
Return injoy_host

Check_dialer_task: Procedure Expose tasks.
save_trace = Trace('N')
Parse Arg dialer_id, dialer_exe
rc_dialer = 0
Select
   When dialer_id = 'INJOY' Then
      Do
         rc_dialer = (RxPIDLst(dialer_exe) <> 0)
         If \rc_dialer & Dialupq(dialer_id) Then
            Call Dialupq dialer_id, 'OFFLINE'
      End
   When dialer_id = 'IBM' Then
      Do
         Call Directory ibm_path
         Address cmd '@tcpdial -status > nul'
         rc_tcpdial = rc
         Call Directory cmd_dir
         rc_dialer = (rc_tcpdial = 0) | (rc_tcpdial = 20)
      End
   Otherwise Nop
End
Trace(save_trace)
Return rc_dialer

Dialupq: Procedure
save_trace = Trace('N')
Parse Upper Arg dialer_id, action
Select
   When dialer_id = 'INJOY' Then
      Do
         old_queue = Rxqueue('Get')
         dialup_queue = 'DIALUP_INJOY'
         Select
            When action = 'ONLINE' Then
               Do
                  new_queue = Rxqueue('create', dialup_queue)
                  /* delete new queue if the one wanted already exists */
                  If new_queue <> dialup_queue Then
                     Call Rxqueue 'Delete', new_queue
                  Call Rxqueue 'Set', dialup_queue
                  Queue dialup_queue
                  dialed = 1
               End
            When action = 'OFFLINE' Then
               Do
                  Call Rxqueue 'Delete', dialup_queue
                  dialed = 0
               End
            Otherwise Do
               Call Rxqueue 'Set', dialup_queue
               dialed = (Queued() <> 0)
            End
         End
         Call Rxqueue 'Set', old_queue
      End
   When dialer_id = 'IBM' Then
      Do
         Call Directory ibm_path
         Address cmd '@tcpdial -status > nul'
         rc_tcpdial = rc
         Call Directory cmd_dir
         If rc_tcpdial = 0 Then
            dialed = 1
         Else
            dialed = 0
      End
   Otherwise Nop
End
Trace (save_trace)
Return dialed

Listbox: Procedure Expose vtitle vlist.
save_trace = Trace('N')
Parse Arg title, vdeep, vbutton
vwide = 0
Do x = 1 To vlist.0
   vwide = Max(Length(vlist.x), vwide)
End
vwide = Max(Length(vtitle), vwide)
vlist = VListBox(vtitle, vlist, vwide, vdeep, vbutton)
Trace(save_trace)
Return vlist

Errorbox: Procedure
save_trace = Trace('N')
Parse Arg message
d = 0
d = d + 1
vtext.d = message
vtext.0 = d
vtitle = 'Error Message'
vbox = VMsgBox(vtitle, vtext, 1)
Trace(save_trace)
Return vbox

Infobox: Procedure
save_trace = Trace('N')
Parse Arg message
d = 0
d = d + 1
vtext.d = message
vtext.0 = d
vtitle = 'Information Message'
vbox = VMsgBox(vtitle, vtext, 1)
Trace(save_trace)
Return vbox

Fileexists: Procedure
save_trace = Trace('N')
Parse Arg file_name
result = Stream(file_name, 'C', 'QUERY EXISTS')
answer = (result <> '')
Trace(save_trace)
Return answer

Findobject: Procedure Expose szclass sztitle szsetupstring target_folder update_old old_dialup_exec old_setup_parms
save_trace = Trace('N')
Parse Arg vtitle, start
If start = '' Then
   object = '<WP_DESKTOP>'
Else
   object = start
target_folder = object
If WPToolsFolderContent(object, 'results.', 'F') Then
   Do
      vlist. = ''
      Do i = 1 To results.0
         Call WPToolsQueryObject results.i, 'szClass', 'szTitle', 'szSetupString', 'szLocation'
         title = Objtitle(sztitle)
         vlist.0 = i; vlist.i = i '-' title
      End
      If vtitle = '' Then
         vtitle = 'Select folder/program or press "Cancel" to quit'
      vdeep = i
      vlist = Listbox(vtitle, Min(vdeep, 10), 3)
      If vlist = 'OK' Then
         Parse Var vlist.vstring ans .
      Else
         ans = ''
      If ans <> '' Then
         Do
            object = results.ans
            Do Until ans = ''
               If WPToolsQueryObject(object, 'szClass', 'szTitle', 'szSetupString', 'szLocation') Then
                  Do
                     title = Objtitle(sztitle)
                     If Objfolder(szclass) Then
                        Do
                           object = Checkobjectid(object)
                           target_folder = object
                           If WPToolsFolderContent(object, 'results.', 'F') Then
                              Do
                                 title = Objtitle(sztitle)
                                 vlist. = ''
                                 Do i = 1 To results.0
                                    Call WPToolsQueryObject results.i, 'szClass', 'szTitle', 'szSetupString', 'szLocation'
                                    title = Objtitle(sztitle)
                                    vlist.0 = i; vlist.i = i '-' title
                                 End
                                 vtitle = 'Select folder/program or press "Cancel" to quit'
                                 vdeep = i
                                 vlist = Listbox(vtitle, Min(vdeep, 10), 3)
                                 If vlist = 'OK' Then
                                    Parse Var vlist.vstring ans .
                                 Else
                                    ans = ''
                                 If ans <> '' Then
                                    object = results.ans
                              End
                           Else
                              Do
                                 vbox = Errorbox('Unable to display' title)
                                 ans = ''
                              End
                        End
                     Else
                        Do
                           vlist. = ''
                           d = 0
                           d = d + 1; vlist.d = 'Object -' object
                           d = d + 1; vlist.d = 'Class -' szclass
                           d = d + 1; vlist.d = 'Title -' title
                           If update_old Then
                              Do
                                 Parse Value('.' szsetupstring) With . 'EXENAME=' old_dialup_exec ';'
                                 d = d + 1; vlist.d = 'Executable -' old_dialup_exec
                                 Parse Value('.' szsetupstring) With . 'PARAMETERS=' old_setup_parms ';'
                                 d = d + 1; vlist.d = 'Parameters -' old_setup_parms
                              End
                           vlist.0 = d
                           vdeep = d
                           vtitle = title 'is an object with the followng characteristics'
                           vlist = Listbox(vtitle, Min(vdeep, 10), 1)
                           ans = ''
                        End
                  End
               Else
                  Do
                     d = 0
                     d = d + 1; vtext.d = object 'is not an object'
                     vtext.0 = d
                     vtitle = 'Error'
                     vbox = VMsgBox(vtitle, vtext, 1)
                     ans = ''
                  End
            End
         End
   End
If \Objfolder(szclass) Then
   object = Checkobjectid(object)
Else
   object = ''
If \Abbrev(object, '<') Then
   object = ''
Trace(save_trace)
Return object

Objtitle: Procedure
save_trace = Trace('N')
Parse Arg title
title = Space(Translate(title, , D2c(94) || D2c(13) || D2c(10) || '^', ' ',))
Trace(save_trace)
Return title

Objfolder: Procedure
save_trace = Trace('N')
folder_classes = 'WPFolder'
Parse Arg class
If Wordpos(class, folder_classes) > 0 Then
   answer = 1
Else
   answer = 0
Trace(save_trace)
Return answer

Objectexists: Procedure
save_trace = Trace('N')
Parse Arg object
answer = WPToolsQueryObject(object)
Trace(save_trace)
Return answer

Checkobjectid: Procedure Expose sztitle szsetupstring
save_trace = Trace('N')
Parse Arg old_object
If Pos('OBJECTID=', szsetupstring) = 0 Then
   Do
      new_title = Objtitle(sztitle)
      new_object = '<' || Translate(new_title, , ' /', '_') || '>'
      If Objectexists(new_object) Then
         Do i = 1 Until rc_obj = 0
            new_object = '<' || Translate(new_title i, , ' ', '_') || '>'
            rc_obj = Objectexists(new_object)
         End
      d = 0
      d = d + 1; vtext.d = 'DialUp requires that its objects have valid object ids'
      d = d + 1; vtext.d = new_object 'will be assigned as the object id'
      object_setup = 'OBJECTID=' || new_object || ';'
      If WPToolsSetObjectData(old_object, object_setup) Then
         Do
            d = d + 1; vtext.d = 'Object id of' old_object 'updated to' new_object
            object = new_object
         End
      Else
         Do
            d = d + 1; vtext.d = 'Object id update failed for' old_object
            object = ''
         End
      vtext.0 = d
      vtitle = old_object 'does not contain a valid object id'
      vbox = VMsgBox(vtitle, vtext, 1)
   End
Else
   object = old_object
Trace(save_trace)
Return object

Copyicon: Procedure Expose what_r_we
save_trace = Trace('N')
Parse Arg folder, source, target
d = 0
d = d + 1; vtext.d = 'Would you like the DialUp launch object to have the'
d = d + 1; vtext.d = '   same icon as the target object? (Y/n)'
vtext.0 = d
vtitle = what_r_we
vbox = VMsgBox(vtitle, vtext, 6)
If vbox = 'YES' Then
   Do
      Call SysOpenObject folder, 'DEFAULT', 'TRUE'
      Call SysOpenObject target, 'SETTINGS', 'TRUE'
      d = 0
      d = d + 1; vtext.d = 'The folder containing the target object and the settings'
      d = d + 1; vtext.d = 'of the DialUp object are now opened, and you can drag'
      d = d + 1; vtext.d = 'the target object icon to the DialUp object icon page'
      d = d + 1; vtext.d = 'Press "OK" after setting the new icon'
      vtext.0 = d
      vtitle = what_r_we
      vbox = VMsgBox(vtitle, vtext, 1)
   End
Trace(save_trace)
Return

Gettargeticon: Procedure Expose szclass szsetupstring icon_temp
save_trace = Trace('N')
Parse Arg source
locations = 'PM_Workplace:Location'
objects = 'PM_Abstract:Objects'
icons = 'PM_Abstract:Icons'
answer = ''
ini_error = 'ERROR:'
icon_found = 0
icon_temp = SysTempFileName(Value('TMP', ,'OS2ENVIRONMENT') || '\temp???.ico')
iconpos = ''
iconfile = ''
/* set icon data according to class */
Select
   When szclass = 'WPUrl' Then
      Do
         iconfile = 'ICONRESOURCE=29,WPINET'
         icon_found = 1
      End
   Otherwise Nop
End
If Pos('ICON', szsetupstring) \= 0 Then
   Do
      /* get any pertinent information from the setup string */
      iconpos = Pos('ICONPOS=', szsetupstring)
      If iconpos \= 0 Then
         Do
            Parse Var szsetupstring iconpos 'ICONPOS=' iconpos ';' .
            iconpos = 'ICONPOS=' || iconpos
         End
      iconfile = Pos('ICONFILE=', szsetupstring)
      If iconfile \= 0 Then
         Do
            Parse Var szsetupstring iconfile 'ICONFILE=' iconfile ';' .
            iconfile = 'ICONFILE=' || iconfile
            icon_found = 1
         End
      Else
         Do
            iconfile = Pos('ICONRESOURCE=', szsetupstring)
            If iconfile \=0 Then
               Do
                  Parse Var szsetupstring iconfile 'ICONRESOURCE=' iconfile ';' .
                  iconfile = 'ICONRESOURCE=' || iconfile
                  icon_found = 1
               End
         End
   End
If \icon_found Then
   Do
      /* check source object program for icon */
      program = Pos('EXENAME=', szsetupstring)
      Parse Var szsetupstring program 'EXENAME=' program ';' .
      program = Strip(program)
      If program \= '' Then
         Do
            If SysGetEA(program, '.icon', 'icondata') = 0 Then
               Do
                  Parse Var icondata . 5 source_icon
                  If Length(source_icon) > 0 Then
                     Do
                        Call Puttargeticon source_icon, icon_temp
                        iconfile = 'ICONFILE=' || icon_temp
                        icon_found = 1
                     End
               End
         End
   End
If icon_found Then
   Do
      If iconpos \= '' Then
         answer = Strip(answer || iconpos || ';')
      If iconfile \= '' Then
         answer = Strip(answer || iconfile || ';')
   End
Else
   Do
      vbox = Errorbox('Unable to locate icon for' source)
   End
Trace(save_trace)
Return answer

Puttargeticon: Procedure Expose icon_temp
save_trace = Trace('N')
Parse Arg source_icon
If (Stream(icon_temp, 'C', 'QUERY EXISTS') \= '') Then
   Call SysFileDelete(icon_temp)
Do i = 1 To Length(source_icon)
   rc_icon = Charout(icon_temp, Substr(source_icon, i, 1))
End
If Length(source_icon) \= 0 Then
   rc_icon = Charout(icon_temp)
Trace(save_trace)
Return

Backup_folder: Procedure Expose dialup_launch_folder cmd_dir
backup. = ''
x = 0
If WPToolsQueryObject(dialup_launch_folder, 'szClass', 'szTitle', 'szSetupString', 'szLocation') Then
   Do
      x = x + 1; backup.x = szclass
      x = x + 1; backup.x = sztitle
      x = x + 1; backup.x = szlocation
      x = x + 1; backup.x = szsetupstring
      If WPToolsFolderContent(dialup_launch_folder, 'objects.' , 'F') Then
         Do
            Do i = 1 To objects.0
               If WPToolsQueryObject(objects.i, 'szClass', 'szTitle', 'szSetupString', 'szLocation') Then
                  Do
                     x = x + 1; backup.x = szclass
                     x = x + 1; backup.x = sztitle
                     x = x + 1; backup.x = szlocation
                     x = x + 1; backup.x = szsetupstring
                  End
            End
            backup.0 = x
            backup_file = cmd_dir || '\dialupf.bak'
            If Fileexists(backup_file) Then
               Call SysFileDelete(backup_file)
            Call Stream backup_file, 'c', 'open write'
            Do i = 1 To backup.0
               Call Lineout backup_file, backup.i
            End
            Call Stream backup_file, 'c', 'close'
            vbox = Infobox(dialup_launch_folder 'backed up to' backup_file)
         End
      Else
         vbox = Errorbox('Unable to query objects in' dialup_launch_folder)
   End
Else
   vbox = Errorbox('Unable to locate' dialup_launch_folder)
Return 0

Restore_folder: Procedure Expose cmd_dir
backup_file = cmd_dir || '\dialupf.bak'
If Fileexists(backup_file) Then
   Do
      d = 0
      d = d + 1; vtext.d = 'Ready to restore' backup_file
      d = d + 1; vtext.d = 'Be aware that all of your icons'
      d = d + 1; vtext.d = 'and shadows will be lost'
      vtext.0 = d
      title = 'Restore DialUp launch folder'
      vbox = VMsgBox(vtitle, vtext, 3)
      If vbox <> 'OK' Then
         Return 0
      vbox = ''
      backup. = ''
      x = 0
      vtext. = ''
      y = 0
      Call Stream backup_file, 'c', 'open read'
      Do While Lines(backup_file) <> 0
         x = x + 1
         backup.x = Linein(backup_file)
         backup.0 = x
      End
      Call Stream backup_file, 'c', 'close'
      class = backup.1
      title = backup.2
      location = backup.3
      object_parms = backup.4
      If SysCreateObject(class, title, location, object_parms, 'R') Then
         Do
            y = y + 1; vtext.y = 'Created folder' title
            Do i = 5 To backup.0 By 4
               j = i + 1; k = i + 2; l = i + 3
               If SysCreateObject(backup.i, backup.j, backup.k, backup.l, 'F') Then
                  Do; y = y + 1; vtext.y = 'Created object -' backup.j; End
               Else
                  Do; y = y + 1; vtext.y = 'Unable to create object -' backup.j; End
            End
            vtext.0 = y
            vtitle = 'Restored' backup_file 'to' title
            vbox = VMsgBox(vtitle, 'vtext', 1)
         End
      Else
         vbox = Errorbox('Unable to create folder' title)
   End
Else
   vbox = Errorbox('Unable to locate backup file' backup_file)
Return 0
