/*
Install - DialUp - coordinate InJoy dialer
Copyright 1999 - 2000 by Chuck McKinnis,  Sandia Park, NM (USA)
mckinnis@attglobal.net
*/

Trace 'N'
version = '1.34'
what_r_we = 'DialUp v'||version 'Copyright 1999, 2000 by Charles H. McKinnis'

Parse Source . . cmd_file .
cmd_name = Filespec('N', cmd_file)
cmd_name = Left(cmd_name, Lastpos('.', cmd_name) - 1)
cmd_dir = Left(cmd_file, Lastpos('\', cmd_file) - 1)
cur_dir = Directory()
Call Directory cmd_dir

vbox = Infobox('If you are upgrading a previous version of DialUp,  Please')
vbox = Infobox('answer No to the next question until you have read dialup.doc.')
vbox = Infobox('Install DialUp? y/N')
Parse Upper Pull ans .
If \Abbrev(ans, 'Y') Then
   Do
      Parse Var Version whole '.' decimal
      Address cmd '@E.EXE' cmd_dir || '\dialup.doc'
      Signal Cleanup
   End

If Rxfuncquery('SysDropFuncs') Then
   Call Rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

Signal On Failure Name cleanup
Signal On Halt Name cleanup
Signal On Syntax Name cleanup

Say what_r_we

obj_view = 'DEFAULT'
obj_flag = 'TRUE'
nl = D2c(94)                                              /* new line */
vbox = 0

class = 'WPFolder'
location = '<WP_DESKTOP>'
title = 'DialUp'
setup = 'OBJECTID=<WP_DIALUP>;'
If SysCreateObject(class, title, location, setup, 'U') Then
   vbox = Infobox(title 'folder created or updated')
Else
   vbox = Errorbox('Unable to create or update' title)
If vbox Then
   Signal Cleanup

class = 'WPFolder'
location = '<WP_DIALUP>'
title = 'DialUp Launch Objects'
setup = 'OBJECTID=<WP_DIALUP_LAUNCH>;'
If SysCreateObject(class, title, location, setup, 'U') Then
   vbox = Infobox(title 'folder created or updated')
Else
   vbox = Errorbox('Unable to create or update' title)
If vbox Then
   Signal Cleanup

class = 'WPFolder'
location = '<WP_DIALUP>'
title = 'DialUp Target Objects'
setup = 'OBJECTID=<WP_DIALUP_TARGETS>;'
If SysCreateObject(class, title, location, setup, 'U') Then
   vbox = Infobox(title 'folder created or updated')
Else
   vbox = Errorbox('Unable to create or update' title)
If vbox Then
   Signal Cleanup

class = 'WPProgram'
location = '<WP_DIALUP>'
title = 'DialUp' || nl || 'Documentation'
obj = 'OBJECTID=<WP_DIALUP_DOC>;'
exec = 'EXENAME=e.exe;'
doc_file = Stream('dialup.doc', 'c', 'query exists')
parm = 'PARAMETERS=' || doc_file || ';'
setup = obj || exec || parm
If SysCreateObject(class, title, location, setup, 'U') Then
   vbox = Infobox(title 'created or updated')
Else
   vbox = Errorbox('Unable to create or update' title)
If vbox Then
   Signal Cleanup


class = 'WPProgram'
location = '<WP_DIALUP>'
title = 'DialUp' || nl || 'Utility'
obj = 'OBJECTID=<WP_DIALUP_UTILITY>;'
exec_name = Stream('dialupu.cmd', 'c', 'query exists')
exec = 'EXENAME=' || exec_name || ';'
iconfile = 'ICONFILE=' || cmd_dir || '\dialup.ico;'
parm = 'MINIMIZED=YES;NOAUTOCLOSE=NO;'
setup = obj || exec || iconfile || parm
If SysCreateObject(class, title, location, setup, 'U') Then
   vbox = Infobox(title 'created or updated')
Else
   vbox = Errorbox('Unable to create or update' title)
If vbox Then
   Signal Cleanup

vbox = Infobox('The DialUp Utility will now be started')
awake = SysOpenObject('<WP_DIALUP_UTILITY>', obj_view, obj_flag)
If \awake Then
   vbox = Errorbox('Unable to start DialUp Utility')


Cleanup:
Call Directory cur_dir
Return 0

Errorbox:
Procedure
Parse Arg message
vtitle = 'Error Message -'
Say vtitle message
Return 1

Infobox:
Procedure
Parse Arg message
Say message
Return 0
