/*
RxPIDLst()

   Uses KILLPID.EXE (FM/2 Utilities) to get the current list of executing
   sessions.

   Usage:  RxPIDLst(task_name, action)
      task_name - text string to find in the task list
      action -
         Query - (default) Locate the task specified in the search argument.
                 Returns the PID of the search argument if successful or
                 0 if unsuccessful.
         Kill  - Calls KILLPID.EXE to terminate the task specified in
                 search argument.
                 Returns 1 if the task specified in the search argument
                 was terminated or 0 if the task specified in the search
                 argument was not located.
         List  - Build a list of all executing tasks and their PIDs.
                 Returns the identifier of a private Rexx queue that
                 contains all of the executing tasks.  The format of
                 data in the queue is PID task_identifier
   Copyright 2000 by Chuck McKinnis,  Sandia Park, NM (USA) 27 Aug 2000
*/
save_trace = Trace('N')
Parse Upper Arg task_name, action, .
action = Strip(Left(action, 1))
If Pos(action, 'Q K L') = 0 Then
   action = 'Q'
crlf = D2c(13) || D2c(10)
tasks. = ''
tasks.0 = 0
j = 0
xrc = 0

pid_queue = Rxqueue('create')                       /* create a queue */
old_queue = Rxqueue('set', pid_queue)              /* make it current */
Address cmd '@KILLPID -list | rxqueue' pid_queue
Do i = 1 While Queued() <> 0
   Parse Pull pid_number exe_name .
   If Datatype(pid_number, 'W') & ,
      exe_name <> 'processes,' Then
      Do
         exe_name = Space(Translate(exe_name, '  ', crlf))
         If action = 'Q' | action = 'K' Then
            Do
               If Pos(task_name, exe_name) <> 0 Then
                  Do
                     If action = 'Q' Then
                        xrc = pid_number
                     Else
                        Do
                           Address cmd '@KILLPID' pid_number
                           xrc = 1
                        End
                     Leave i
                  End
            End
         Else
            Do
               j = tasks.0 + 1
               tasks.j = pid_number exe_name
               tasks.0 = j
            End
      End
End
Call Rxqueue 'delete', pid_queue                 /* delete work queue */

If action = 'L' Then                      /* load queue with PID list */
   Do
      task_queue = Rxqueue('create')                /* create a queue */
      old_queue = Rxqueue('set', task_queue)       /* make it current */
      Do i = 1 To tasks.0
         Queue pid_number exe_name
      End
      xrc = task_queue
   End

Call Rxqueue 'set', old_queue                    /* restore old queue */
Return xrc                 /* return value, 0, 1, or queue identifier */
