/* returns the day of the week given a calendar date
   Date formats:  mm-dd-yy
                  mm-dd-yyyy
                  mm/dd/yy
                  mm/dd/yyyy
                  yyyymmdd
    Option: '( STACK' returns two words:
                 0 based day of week: 0 is Sunday, etc
                 and the English name for that day
*/
versionString = '1.0.2  2024-5-12'
parse source opSys . ourFullName .
parse value filespec('name',ourFullName) with exname '.' exExtension

days="0 31 59 90 120 151 181 212 243 273 304 334"
DayNames="Sunday Monday Tuesday Wednesday Thursday Friday Saturday"

baseYear = 1700
dy = 4             /* algorithm adjustment for January 1, 1700 */

parse upper arg aDate '(' optn
if aDate = '' | aDate = '?' | translate(aDate) = '-H' then do
   say ''
   say 'Version:' versionString
   say 'Syntax:' exname 'date < ( Stack >'
   say 'Where date is a valid date form:'
   say '          mm-dd-yy'
   say '          mm-dd-yyyy'
   say '          mm/dd/yy'
   say '          mm/dd/yyyy'
   say '          yyyymmdd'
   say '  a 2 digit year implies 19xx when yy > current year, otherwise 20xx'
   say '  when no specific year is given the current year is implied.'
   say ' Optional "STACK" to push the results onto the REXX console input stack'
   say '      so it is available by the calling REXX script via a pull statement.'
   exit 100
end

aDate = translate(aDate,'-','/')
if length(strip(aDate)) = 8 & datatype(aDate) = 'NUM'
   then parse var aDate yyyy +4 mm +2 dd
   else parse var aDate mm '-' dd '-' yyyy .
/* make an assumption about a 2 digit year */
if yyyy = ''
   then yyyy = left(date('S'),4)
if yyyy < 100 then do
   if yyyy < substr(date('s'),3,2) + 4 
      then yyyy = yyyy + 2000
      else yyyy = yyyy + 1900
end
prettyDate = right('0'||mm,2)||'/'||right('0'||dd,2)||'/'||yyyy

/* ly is 1 if it is a leap year */
daysPerMonth = '31 28 31 30 31 30 31 31 30 31 30 31'
if yyyy // 4 = 0 then ly = 1 ; else ly = 0
if yyyy // 100 = 0 then ly = 0
if yyyy // 400 = 0 then ly = 1 

possibleDays = word(daysPerMonth,mm)
if mm = 2 then possibleDays = possibleDays + ly

if yyyy < baseYear | yyyy > 2200 | mm > 12 | dd > possibleDays then do
   say 'Erroneous date format:' aDate '  We can handle dates from' baseYear 'to 2200'
   if mm = 2 & dd = 29 & ly = 0
      then say yyyy 'is not a leap year so February 29th does not exist!'
   if pos('STACK',optn) > 0
      then push -1 'ERROR'
   exit 8
end

/* lp4 is number of leap years since the base, lp100 makes century adjustments */
pastYears = (yyyy) - baseYear
lp4 = (pastYears) % 4
lp100 = (pastYears) % 100
if yyyy >= 2000 then lp100 = lp100 - 1

/* calc number of days in the current year */
dy = dy + word(days,mm) + dd
if mm < 3         /* Jan and Feb haven't had the leap day yet */
   then dy = dy - ly

/*
say mm||'-'||dd||'-'yyyy 'days so far' word(days,mm) '+' dd 'is:' dy  'Leap Year:' ly 'previous leap years' lp4 '* 365 =' dy + (pastYears * 365) + lp4
*/

/* add in days in completed previous years */
dy = dy + (pastYears * 365) + lp4 - lp100

/* calc day of the week */
dow = dy // 7
weekday=word(DayNames,dow+1)

if pos('STACK',optn) > 0
   then push dow weekday
   else say prettyDate 'is' dow weekday
exit
