/* Enhanced Change Directory command that supports wild cards
   and vague recursion down a directory tree */

versionString = '2.0.0 2022-12-22'
fsSeparator = '\'
finalDirList.0 = 0

parse arg request
if request = '' | request = '?' then do
   say 'Enhanced Change Directory (CD) command,  By Allen Heath'
   say '   Wild cards and partial paths accepted.'
   say '   When only one possible result is matched, it changes directory,'
   say'        otherwise a pick list of matches is presented to select from.'
   say ''
   say 'Simple case: CD! directory_spec'
   say '   Changes to directory_spec relative current directory just like CD would.'
   say '   Short Cut case when directory spec contains a wild card'
   say 'Unlimited nesting case: CD! \*\directory_spec'
   say 'Limited relative path matching:  CD! path_spec\directory_spec'
   say '   Where path_spec may contain a wild card'
   say ''
   say 'The more specific the faster it can run chasing less of the tree.'
   exit 100
end

/* Read screen size to limit the selection list to a single screen */
parse value SysTextScreenSize() with rows cols

'@setlocal'
reqDirectory = filespec('name',request)
reqPath = filespec('path',request)
reqDrive = filespec('drive',request)

if reqDrive = ''
   then testingDrive = filespec('drive',directory())
   else testingDrive = reqDrive
testingDrive = translate(testingDrive)

if left(reqPath,1) = fsSeparator then do
   testingPath = fsSeparator
   reqPath = substr(reqPath,2)
end
else do
   testingPath = strip(filespec('path',directory(testingDrive))||filespec('name',directory(testingDrive)),'T',fsSeparator)||fsSeparator
   if left(reqPath,3) = '..\' then do
      /* traverse back up the tree to the parent */
      do while left(reqPath,3) = '..\'
         reqPath = substr(reqPath,4)
         testingPath = filespec('path',strip(testingPath,'T',fsSeparator))
      end
   end
end

call recursePaths '"'||testingDrive||testingPath||'" "'||reqPath||'"'

'@endlocal'

changeDir = ''
if finalDirList.0 > 1 then do
   if finalDirList.0 < rows - 4 then do
      say 'Multiple possibilities are found...'
      do i = 1 to finalDirList.0
         parse value finalDirList.i with . . . . aDir
         say right(' '||i,2) aDir
      end
     
      say 'Pick one?  (or just ENTER to skip)'
      pull number

      if datatype(number) = 'NUM' 
         then if number > 0 & number <= finalDirList.0 & trunc(number) = number
            then changeDir = finalDirList.number
            else say number 'is not a valid response!'
         else if number <> ''
            then say "You didn't select a numbered line"
   end
   else say finalDirList.0 'possibilities,  Narrow your selection mask.'
end
else if finalDirList.0 = 1
   then changeDir = finalDirList.1

if changeDir = ''
   then say "Couldn't resolve a match!"
   else do
      parse var changeDIr . . . . aDir
      there = directory(strip(aDir))
   end
exit

recursePaths: procedure expose finalDirList. fsSeparator reqPath reqDirectory request
   arg parms
   parse var parms '"' relativePath '"' . '"' morePaths '"'

   /* parse the path spec for the first subdirectory spec */
   p = pos(fsSeparator,morePaths)
   aDir = strip(left(morePaths,p),'T',fsSeparator)
   if p > 0
      then morePaths = substr(morePaths,p+1)
      else morePaths = ''
   
   /* checking for paths along the subdirectory chain? */
   if aDir <> '' then do

      /* enumerate all directories here that match this part of the path spec */
      rc = SysFileTree(relativePath||aDir,pathList,'D')

      do p = 1 to pathList.0
         parse value pathList.p with . . . . there
         there = strip(there)||fsSeparator
      
         /* is there a match on the requested directory name? */
         nDirs = check4FinalDir(there)
         if nDirs > 0 
            then rc = SysStemCopy(dirList,finalDirList,1,finalDirList.0+1)
      
         /* more parts to the path to examine? */
         if morePaths <> ''
               then call recursePaths there morePaths

         /* unlimitted wild card recursion? */
         if aDir = '*'
            then call recursePaths '"'||there||'" "'||aDir||fsSeparator||'"'
      end
   end
   else do   /* just check this relative path for the final directory */
      nDirs = check4FinalDir(relativePath)
      if nDirs > 0 
         then rc = SysStemCopy(dirList,finalDirList,1,finalDirList.0+1)
   end
return

check4FinalDir:
   arg checkingPath

   /* check for final candidate directories matching the requested directory */
   rc = SysFileTree(checkingPath||reqDirectory,dirList,'D')

return dirList.0
