/*        TAR-COMMAND-DATEI         */
/*                                  */
/*   zur Sicherung aller Platten    */
/*                                  */
/*        Incremental.cmd           */
/*                                  */
/*     Inkrementale Sicherung       */
/*                                  */

'@echo off'

'mt blocksize 512'
'mt blocksize 512'

/* -------------------------------- */
/*    Vorbelegung der Dateinamen    */
/* -------------------------------- */

Backup_Drives      = 'c:/ d:/ e:/ f:/ g:/ '
Exclude_File       = 'f:\tar\exclude.lst'
Log_Nr_File        = 'f:\tar\numbers\Back_Log.Nr'
Back_Date_File     = 'f:\tar\dates\Back_Date.dat'
Dump_File          = 'f:\tar\dates\Back_Date.dmp'

/* -------------------------------- */
/*      Rexx-Funktionen laden       */
/* -------------------------------- */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* -------------------------------- */
/*   Datum des Backups erstellen    */
/* -------------------------------- */

PARSE VALUE date('E') with cTag'/'cMonat'/'cJahr
cDatumNeu=''
cDatumNeu=insert(cDatumNeu,cTag)
cDatumNeu=insert(cDatumNeu,'.')
cDatumNeu=insert(cDatumNeu,cMonat)
cDatumNeu=insert(cDatumNeu,'.')
cDatumNeu=insert(cDatumNeu,cJahr)

/* ---------------------------- */
/* Naechste Logfilenummer lesen */
/* ---------------------------- */

Log_Nr = linein(Log_Nr_File)
Log_Nr = Log_Nr+1
Log_Nr = strip(Log_Nr)

call lineout Log_Nr_File, Log_Nr,1
call lineout Log_Nr_File

/* ------------------------------------- */
/* Logfile und Accessfile zusammensetzen */
/* ------------------------------------- */

LogFile='f:\tar\full_l\Inc_#'Log_Nr'.log'
Access_File='f:\tar\full_a\Tape_Inc_#'Log_Nr'.acc'

/* ------------------------------- */
/* Datum des letzten Backups holen */
/* ------------------------------- */

Last_Date = linein(Back_Date_File)

call lineout LogFile, '', 1
call TextOut LogFile, '+++ Logfile "'LogFile'"'
call TextOut LogFile, '+++ Letztes Backup am 'Last_Date'.'

/* ----------------------------------- */
/* Neues Dump-Datum in Datei schreiben */
/* ----------------------------------- */

New_Dump = Next_Dump_Date( LogFile )
call lineout Back_Date_File, New_Dump, 1

/* -------------------- */
/* Bereiche ausklammern */
/* -------------------- */

call Exclude_Files '*.BAK'          , Exclude_File , LogFile
call Exclude_Files '*.bak'          , Exclude_File , LogFile
call Exclude_Files '*.tmp'          , Exclude_File , LogFile
call Exclude_Files '*.TMP'          , Exclude_File , LogFile

call Exclude_Files 'f:\filenetz'    , Exclude_File , LogFile
call Exclude_Files 'e:\filenetz'    , Exclude , LogFile
call Exclude_Files 'e:\hotstuff'    , Exclude_File , LogFile

call lineout Exclude_File

call TextOut Logfile, '+++ Zurckspulen'
comm='mt rew 2>>'LogFile
call TextOut LogFile, '>>> 'comm
(comm)

/* ---------------------------------- */
/* Backup-Befehlszeile zusammensetzen */
/* ---------------------------------- */

cZeile='tar -cppp -V"Incremental-Backup #'
cZeile=insert(cZeile,Log_Nr )
cZeile=insert(cZeile,' vom ' )
cZeile=insert(cZeile,cDatumNeu'"')
cZeile=insert(cZeile,' -Gi -g'translate( Dump_File, '/', '\' ) )
cZeile=insert(cZeile,' -N"'Last_Date'" ' )
cZeile=insert(cZeile,' -b 126' )
cZeile=insert(cZeile, ' -D'translate( Access_File, '/','\' ) )
cZeile=insert(cZeile, ' -X'translate( Exclude_File, '/','\' ) )
cZeile=insert(cZeile, ' -E -P --total 'Backup_Drives )
cZeile=insert(cZeile, ' 2>> ')
cZeile=insert(cZeile,LogFile )

call TextOut LogFile, '+++ TAR ausfhren :'
call TextOut LogFile, cZeile
(cZeile)

call TextOut Logfile, '+++ Zurckspulen (fertig)'
comm='mt -nowait rew 2>>' LogFile
call TextOut LogFile, '>>> 'comm
(comm)

/* ---------------------------------------- */
/* Das aktuelle Datum ins Logfile schreiben */
/* ---------------------------------------- */

call TextOut LogFile, '+++ Backup beendet um 'time('N')

/* --------------------- */
/* Exclude-Files lschen */
/* --------------------- */

comm='del' Exclude_File ' 2>nul:'
call TextOut LogFile, '>>> 'comm
(comm)

exit

/* ------------------------------------------------------------------------ */
/* ---                       Bentigte Unterprogramme                   --- */
/* ------------------------------------------------------------------------ */

/* -------------------------------------- */
/* Eventuelles anhaengen eines Parameters */
/* -------------------------------------- */

Exclude_Files:

  call lineout arg(3), ''
  say ''
  call lineout arg(2), translate( arg(1),'/','\' )
  call lineout arg(3), '>>> "'arg(1)'" nicht sichern.'
  say '>>> "'arg(1)'" nicht sichern.'

  return

/* ----------------------------------------------- */
/* Ausgabe eines Textes in File und auf Bildschirm */
/* ----------------------------------------------- */

TextOut:

   call lineout arg(1), ''
   call lineout arg(1), arg(2)
   call lineout arg(1)

   say ''
   say arg(2)

   return

/* ----------------------------------------------- */
/* Ausgabe des aktuellen Datums fuer die Sicherung */
/* ----------------------------------------------- */

next_dump_date:

 PARSE VALUE date('U') with cMonat'/'cTag'/'cJahr
 PARSE Value time() with cStunde':'cMinute':'cSekunde

 select
   when cMonat =  1 then Monat = 'Jan'
   when cMonat =  2 then Monat = 'Feb'
   when cMonat =  3 then Monat = 'Mar'
   when cMonat =  4 then Monat = 'Apr'
   when cMonat =  5 then Monat = 'May'
   when cMonat =  6 then Monat = 'Jun'
   when cMonat =  7 then Monat = 'Jul'
   when cMonat =  8 then Monat = 'Aug'
   when cMonat =  9 then Monat = 'Sep'
   when cMonat = 10 then Monat = 'Oct'
   when cMonat = 11 then Monat = 'Nov'
   when cMonat = 12 then Monat = 'Dec'
 
 end

 Datum = Monat' 'cTag' 'cStunde':'cMinute' 19'cJahr
 call TextOut arg(1), '+++ Datum des aktuellen Backups : 'Datum

 return Datum

/* ------------------------------------------------------------------------ */


