/* MAIN object*/
// This program counts the lines of code in a project by reading
//   each source file in a directory, determining which object
//   that files contains a part of and then totaling all the object
//   lines of code, reporting them, and from that finding the
//   total lines of code and reporting it.

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

/* ARG!!! Hack Hack Hack!!!*/
char ReadDir[80];

#include "e:\pspsrc\llist.h"
#include "oi.h"

int  FoundObjectInList(LList *ObjL, char *name);
void BuildList(LList *ObjL);
int  CountList(LList *ObjL);
void PrintList(LList *ObjL, int TLOC);

LList       ObjectList;         // List of Objects
void main(int argc,char *argv[])
{
  int         TLOC=0;

  if (argc==0){
    printf("Please supply the directory to scan as a parameter.\n");
    exit (0);
  }

  strcpy(ReadDir,argv[1]);        // Just slip the parm in here.
  if (strlen(ReadDir)==0){
    FILE *out;
    if(NULL==(out=fopen("data2.dat","wt"))){
      printf("Error:  Can't write results.");
      exit(1);
    }
    fprintf(out,"Please supply a source directory.\n");
    fclose(out);
    exit(1);
  }

				  // Scan all files in said directory,
				  //   Everything with the proper extension
				  //   is assigned to an object.
  BuildList(&ObjectList);

				  // Go through all objects and inform
				  //   them that they should count their
				  //   OLOC.  Returns total counted.
  TLOC=CountList(&ObjectList);

				  // Have each object print it's name and count,
				  //   and then prints the total.
  PrintList(&ObjectList, TLOC);
}

int  FoundObjectInList(LList *ObjL, char *name)
{
  CObjectInfo *temp;              // Pointer to an Object Info class

  if (ObjL->NumNodes==0){
    return(0);
  }

  ObjL->Restart();                    // Start at start of list.
  do{
    temp=(CObjectInfo*)ObjL->Retrieve(LL_DATA);
    if (0==strcmp(temp->WhatIsYourName(),name)){
      return(1);
    }
    ObjL->Next();
				  // Check objects until out of objects
				  // or name is found.
  } while (ObjL->AtEnd == FALSE);
  return(0);
}

void BuildList(LList *ObjL)
{
  char   dirtemp[60];
  char   dirname[60];
  char   opnfile[60];
  char   tempfile[60];
  int    readtype=0;

//  DIR    *dir;
//  struct dirent *ent;
  struct find_t ffblk;

  FILE   *srcfile;
  char   *ext;
  char   *name;
  char   *endname;

  char   Object[35];
  char   line[80];
  char   fullfile[60];
  int    done;
  int    flag=0;

  char   cmntchrs[55]="\t\n /*`~!@#$%^&*()[]{}\|;':<?>,.";

  CObjectInfo *temp;        // Pointer to an Object Info class

/*
  if(-1==getcurdir(0,dirtemp)){
    printf("Error reading the current directory.\n");
  }
  sprintf(dirname,"\\%s",dirtemp);

//  strcpy(dirname,ReadDir);        // Slid the parm in here.

  if ((dir = opendir(dirname)) == NULL)  {
    perror("Unable to access directory!\n");
    exit(1);
  }
*/

  strcpy(dirname,ReadDir);        // Slid the parm in here.
  strcat(dirname,"\\*.h");

  done = _dos_findfirst(dirname,_A_NORMAL,&ffblk);
  while (readtype<4){
    while ((done!=0)&&(flag==0)){
      readtype++;
      if (readtype==1){
	strcpy(dirname,ReadDir);        // Slid the parm in here.
	strcat(dirname,"\\*.hpp");
	done = _dos_findfirst(dirname,_A_NORMAL,&ffblk);
      }
      if (readtype==2){
	strcpy(dirname,ReadDir);        // Slid the parm in here.
	strcat(dirname,"\\*.c");
	done = _dos_findfirst(dirname,_A_NORMAL,&ffblk);
      }
      if (readtype==3){
	strcpy(dirname,ReadDir);        // Slid the parm in here.
	strcat(dirname,"\\*.cpp");
	done = _dos_findfirst(dirname,_A_NORMAL,&ffblk);
      }
      if (readtype==4) flag=1;
    }

    if (done==0){
      strupr(ffblk.name);
      strcpy(tempfile,ffblk.name);

      ext=tempfile;
      if (ext!=NULL){
	ext=strchr( ext,'.');
      }
    }
    else {
      ext=NULL;
    }

    if( ext != NULL &&
       (0==strcmp(ext,".C")   ||
	0==strcmp(ext,".CPP") ||
	0==strcmp(ext,".H")   ||
	0==strcmp(ext,".HPP") )){

      strcpy(opnfile,ReadDir);
      strcat(opnfile,"\\");
      strcat(opnfile,ffblk.name);


      if(NULL==(srcfile=fopen(opnfile,"rt"))){
	printf("Unable to open file %s.",opnfile);
      }
      else{

	name=NULL;
	while (name==NULL && !feof(srcfile)){
	  fgets(line,80,srcfile);
	  name=line;

//          what=strcspn(line,"\t\n /*");// Points to first non-comment character
	  while (NULL!=strchr(cmntchrs,*name) && name!=NULL){
	    name++;
	  }
	}

	if (name!=NULL){
	  endname=name;
	  while (NULL==strchr(cmntchrs,*endname) && endname!=NULL){
	    endname++;
	  }

	  *endname=NULL;          // Null terminate the name.

	  strcpy(Object,name);    // Copy the name into Object.

				  // Check if there is already an object,
				  //   of this name...

				  // Found Object returns 1 if the object is
				  //   in the list and 0 if not.  The list
				  //   cur pointer is left pointing to the
				  //   correct object.
	  if(1==FoundObjectInList(ObjL, name)){
				  // Add this file name to the object
	    temp=(CObjectInfo*)ObjL->Retrieve(LL_DATA);
	    strcpy(fullfile,ReadDir);
	    strcat(fullfile,"\\");
	    strcat(fullfile,ffblk.name);
	    temp->AddFile(fullfile);
	  }
	  else{
				  // Create this object & add the file name.
	    ObjL->Add(new CObjectInfo,LL_ADD_AFTER);
	    ObjL->Next();
	    temp=(CObjectInfo*)ObjL->Retrieve(LL_DATA);

	    strcpy(fullfile,ReadDir);
	    strcat(fullfile,"\\");
	    strcat(fullfile,ffblk.name);
	    temp->AddFile(fullfile);
	    temp->YourNameIs(Object);
	  }
	}
	fclose(srcfile);
//        printf("%15s holds object %s...\n",ent->d_name,name);
      }
    }
    if (readtype != 4){
      done = _dos_findnext(&ffblk);
    }
  }
}

int  CountList(LList *ObjL)
{
  CObjectInfo *temp;              // Pointer to an Object Info class
  int TLOC=0;

  ObjectList.Restart();                    // Start at start of list.
  do{
    temp=(CObjectInfo*)ObjectList.Retrieve(LL_DATA);

    TLOC += temp->Count_OLOC();

    ObjectList.Next();
				  // Count objects until out of objects
  } while (ObjectList.AtEnd == FALSE);

  return(TLOC);                   // Return the total.
}

void PrintList(LList *ObjL, int TLOC)
{
  CObjectInfo *temp;              // Pointer to an Object Info class
  FILE *out;

  if(NULL==(out=fopen("data2.dat","wt"))){
    printf("Error:  Can't write results.");
    exit(1);
  }

  ObjL->Restart();                    // Start at start of list.
  do{
    temp=(CObjectInfo*)ObjL->Retrieve(LL_DATA);

    temp->Print_OLOC(out);

    ObjL->Next();
				  // Count objects until out of objects
  } while (ObjL->AtEnd == FALSE);

  fprintf(out,"\nTotal LOC:     %d\n",TLOC);
  fclose(out);
}
