// CSimpson
//   Numerical integration by the Simpsons method.
//   This is a parent class.  The function to be integrated
//   Must be derived from this class and have the funciton
//   to be integrated in the over-ridden mehtod IntMe();

#include "stdio.h"
#include "stdlib.h"
#include "math.h"
#include "values.h"

#ifndef CSIMPSON
#define CSIMPSON

#define INFINITY MAXDOUBLE        // Allows us to hold the value of
                                  //  infinity in a finit floating point
                                  //  variable.


class CSimpson
{
  public:
  CSimpson(void);

  double         Gamma(double x); // Gamma is used by multiple functions
                                  //  so it is here for convenience.
  virtual double IntMe(double x); // Overridable function to hold the
                                  //  function to integrate.
                                  // Sets the private member tolerance.
  void           SetTolerance(double Tol);
                                  // Integrates the desired funcition by
                                  //  taking into account for infinity and
                                  //  calling the CalcSimpsons funtion.
  double         Integrate(double low, double high, double total);

  private:                        // Calculates simpsons summation using
                                  //  the info generated in Integrate.
  void           CalcSimpsons(double low, double high);

  int            n;               // Number of blocks in use.
  double         cur_result;      // current simpsons result.
  double         old_result;      // previous simpsons result.
  double         result;          // actual found result.
  double         width;           // width of each block.
  double         tolerance;       // error tolerance
};


#endif