// LRSet
// Method definition for the LRSet class

#include "lrset.h"

LRSet::LRSet(void)
{
  B0=0;
  B1=0;
}

void LRSet::AddList(LList *ReadList)
{

}

void LRSet::AddFile(char *filename)
{
  FILE *input;
  char *next_num;
  char line[80];

  double x;
  double y;

  if(NULL==(input=fopen(filename,"rt"))){
    printf("Unable to open requested data file.\n");
    printf("Program aborts.\n");
    exit(1);
  }

  Restart();                    // Start at start of list.
  fgets(line, 80, input);     // Read a line of input.
  do{

    if (line[0]!='\n' && line[0]!=NULL){
      x=atof(line);
      next_num=strchr(line,' ');
      y=atof(next_num);

      AddNode(x,y);
    }
    fgets(line, 80, input);     // Read a line of input.
  } while (!feof(input));
  fclose(input);
}

void LRSet::AddNode(double x, double y)
{
  DataPoint *temp;

  Add(new DataPoint,LL_ADD_AFTER);
  Next();
  temp=(DataPoint*)Retrieve(LL_DATA);
  temp->x=x;
  temp->y=y;
}

void LRSet::CalcLR(void)
{
  DataPoint *temp;

  double est_act_sum=0;
  double est_sqrd_sum=0;
  double est_sum=0;
  double act_sum=0;

  double est_ave=0;
  double act_ave=0;


  Restart();                    // Start at start of list.
  do{
    temp=(DataPoint*)Retrieve(LL_DATA);

    est_sum+=temp->x;
    act_sum+=temp->y;

    est_act_sum+=(temp->x * temp->y);
    est_sqrd_sum+=(temp->x * temp->x);

    Next();
                                  // Count objects until out of objects
  } while (AtEnd == FALSE);

  est_ave=est_sum / NumNodes;
  act_ave=act_sum / NumNodes;

  B1=est_act_sum - (NumNodes * (est_ave * act_ave));
  B1/=est_sqrd_sum - (NumNodes * (est_ave * est_ave));

  B0=act_ave - (B1 * est_ave);
}

