// Main
// This program outputs a Upper and Lower bound around a
//  computed prediction based on previous data about estimated
//  and actual LOC occurances.  All the data is printed to the
//  screen, but the input data must come from a file.

#include "conio.h"                // So I can use clrscr().
#include "rfind.h"                // RangeFinder Class.  (workhorse)

void main(void)
{
  RangeFinder RF;                 // Instantiate RangeFinder.

  char filename[50];              // Filename
  char temp[50];                  // text buffer.
  double percent=0;               // Percent of error to look for.
  double estimate=0;              // New estimated LOC.

  clrscr();                       // Change all screen pixels black

  printf("Welcome to the Range Finder.\n");
  printf("Enter the name of the file containing your data.\n");
  gets(filename);                 // Get the file for input data.

  printf("Enter the percentage of confidence you would like.\n");
  gets(temp);
  percent=atof(temp);             // Find the % confidence desired.

  printf("Enter the estimated LOC for your current program.\n");
  gets(temp);
  estimate=atof(temp);            // Find the estimate.

                                  // Do all the work.
  RF.CalcRange(percent, filename, estimate);

                                  // Print the results found.
  printf("Results:\n\n");
  printf("B0               %lf\n",RF.B0);
  printf("B1               %lf\n",RF.B1);
  printf("Range            %lf\n",RF.Range);
  printf("Projected LOC    %lf\n",RF.PLOC);
  printf("UPI              %lf\n",RF.UPI);
  printf("LPI              %lf\n",RF.LPI);
}







