package net.sf.colossus.server;


import java.io.*;


/**
 * Class XMLSnapshotFilter implements a FilenameFilter for savegames.
 * @author David Ripton
 * @version $Id: XMLSnapshotFilter.java,v 1.3 2004/01/22 01:26:41 dripton Exp $
 */

public final class XMLSnapshotFilter extends javax.swing.filechooser.FileFilter
    implements FilenameFilter
{
    public static final String description = "snapshots";


    public boolean accept(File dir, String name)
    {
        if (name.endsWith(Constants.xmlExtension))
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    public boolean accept(File f)
    {
        if (f.isDirectory())
        {
            return true;
        }
        String name = f.getName();
        return accept(null, name);
    }

    public String getDescription()
    {
        return description;
    }
}

