#!/usr/bin/env python2
# Needs Python 2.3+ for sets

__version__ = "$Id: test_predictsplits.py,v 1.17 2004/03/31 02:14:31 dripton Exp $"

import unittest
from predictsplits import PredictSplits, CreatureInfo, Node, AllPredictSplits


class PredictSplitsTestCase(unittest.TestCase):

    starting_creatures = ["Titan", "Angel", "Ogre", "Ogre", "Centaur", 
      "Centaur", "Gargoyle", "Gargoyle"]

    def testPredictSplits1(self):
        print "\ntest 1 begins"

        ps = PredictSplits("Rd", "Rd01", self.starting_creatures)
        ps.printLeaves()

        turn = 1
        print "Turn", turn
        ps.getLeaf("Rd01").split(4, "Rd02", turn)
        ps.getLeaf("Rd01").merge(ps.getLeaf("Rd02"), turn)
        ps.getLeaf("Rd01").split(4, "Rd02", turn)
        ps.getLeaf("Rd01").revealCreatures(["Ogre", "Ogre"])
        ps.getLeaf("Rd01").addCreature("Troll")
        ps.getLeaf("Rd02").revealCreatures(["Centaur", "Centaur"])
        ps.getLeaf("Rd02").addCreature("Lion")
        assert(not ps.getLeaf("Rd01").allCertain())
        assert(not ps.getLeaf("Rd02").allCertain())
        ps.printLeaves()

        turn = 2
        print "Turn", turn
        ps.getLeaf("Rd01").revealCreatures(["Gargoyle"])
        ps.getLeaf("Rd01").addCreature("Gargoyle")
        ps.getLeaf("Rd02").revealCreatures(["Lion"])
        ps.getLeaf("Rd02").addCreature("Lion")
        assert(not ps.getLeaf("Rd01").allCertain())
        assert(not ps.getLeaf("Rd02").allCertain())
        ps.printLeaves()

        turn = 3
        print "Turn", turn
        ps.getLeaf("Rd01").revealCreatures(["Titan"])
        ps.getLeaf("Rd01").addCreature("Warlock")
        ps.getLeaf("Rd02").addCreature("Gargoyle")
        assert(ps.getLeaf("Rd01").allCertain())
        assert(ps.getLeaf("Rd02").allCertain())
        ps.printLeaves()

        turn = 4
        print "Turn", turn
        ps.getLeaf("Rd01").split(2, "Rd03", turn)
        ps.getLeaf("Rd02").split(2, "Rd04", turn)
        ps.getLeaf("Rd01").revealCreatures(["Gargoyle", "Gargoyle"])
        ps.getLeaf("Rd01").addCreature("Cyclops")
        ps.getLeaf("Rd02").revealCreatures(["Gargoyle", "Gargoyle"])
        ps.getLeaf("Rd02").addCreature("Cyclops")
        assert(not ps.getLeaf("Rd01").allCertain())
        assert(not ps.getLeaf("Rd02").allCertain())
        assert(not ps.getLeaf("Rd03").allCertain())
        assert(not ps.getLeaf("Rd04").allCertain())
        ps.printLeaves()

        turn = 5
        print "Turn", turn
        ps.getLeaf("Rd01").revealCreatures(["Warlock"])
        ps.getLeaf("Rd01").addCreature("Warlock")
        ps.getLeaf("Rd02").addCreature("Ogre")
        ps.getLeaf("Rd03").revealCreatures(["Ogre", "Ogre"])
        ps.getLeaf("Rd03").addCreature("Troll")
        ps.getLeaf("Rd04").revealCreatures(["Centaur", "Centaur"])
        ps.getLeaf("Rd04").addCreature("Lion")
        assert(ps.getLeaf("Rd01").allCertain())
        assert(ps.getLeaf("Rd02").allCertain())
        assert(ps.getLeaf("Rd03").allCertain())
        assert(ps.getLeaf("Rd04").allCertain())
        ps.printLeaves()

        turn = 6
        print "Turn", turn
        ps.getLeaf("Rd02").split(2, "Rd05", turn)
        ps.getLeaf("Rd01").revealCreatures(["Titan", "Warlock", "Warlock",
            "Cyclops", "Troll", "Gargoyle", "Gargoyle"])
        ps.getLeaf("Rd01").removeCreatures(["Gargoyle", "Gargoyle"])
        ps.getLeaf("Rd02").removeCreature("Angel")
        ps.getLeaf("Rd01").addCreature("Angel")
        ps.getLeaf("Rd02").revealCreatures(["Lion", "Lion"])
        ps.getLeaf("Rd02").addCreature("Minotaur")
        ps.getLeaf("Rd04").revealCreatures(["Lion"])
        ps.getLeaf("Rd04").addCreature("Lion")
        ps.getLeaf("Rd02").revealCreatures(["Cyclops", "Minotaur", "Lion",
            "Lion", "Ogre"])
        ps.getLeaf("Rd02").addCreature("Minotaur")
        ps.getLeaf("Rd02").removeCreatures(["Cyclops", "Minotaur", "Minotaur",
            "Lion", "Lion", "Ogre"])
        assert(ps.getLeaf("Rd01").allCertain())
        assert(ps.getLeaf("Rd03").allCertain())
        assert(ps.getLeaf("Rd04").allCertain())
        assert(ps.getLeaf("Rd05").allCertain())
        ps.printLeaves()

        turn = 7
        print "Turn", turn
        ps.getLeaf("Rd01").addCreature("Angel")
        ps.getLeaf("Rd03").revealCreatures(["Troll"])
        ps.getLeaf("Rd03").addCreature("Troll")
        ps.getLeaf("Rd04").revealCreatures(["Lion"])
        ps.getLeaf("Rd04").addCreature("Lion")
        assert(ps.getLeaf("Rd01").allCertain())
        assert(ps.getLeaf("Rd03").allCertain())
        assert(ps.getLeaf("Rd04").allCertain())
        assert(ps.getLeaf("Rd05").allCertain())
        ps.printLeaves()

        turn = 8
        print "Turn", turn
        ps.getLeaf("Rd01").split(2, "Rd02", turn)
        ps.getLeaf("Rd01").revealCreatures(["Cyclops"])
        ps.getLeaf("Rd01").addCreature("Cyclops")
        ps.getLeaf("Rd05").revealCreatures(["Gargoyle", "Gargoyle"])
        ps.getLeaf("Rd05").addCreature("Cyclops")
        assert(not ps.getLeaf("Rd01").allCertain())
        assert(not ps.getLeaf("Rd02").allCertain())
        assert(ps.getLeaf("Rd03").allCertain())
        assert(ps.getLeaf("Rd04").allCertain())
        assert(ps.getLeaf("Rd05").allCertain())
        ps.printLeaves()

        turn = 9
        print "Turn", turn
        ps.getLeaf("Rd01").revealCreatures(["Troll"])
        ps.getLeaf("Rd01").addCreature("Troll")
        ps.getLeaf("Rd03").revealCreatures(["Troll"])
        ps.getLeaf("Rd03").addCreature("Troll")
        ps.getLeaf("Rd04").revealCreatures(["Lion", "Lion", "Lion"])
        ps.getLeaf("Rd04").addCreature("Griffon")
        ps.getLeaf("Rd05").revealCreatures(["Cyclops"])
        ps.getLeaf("Rd05").addCreature("Cyclops")
        assert(not ps.getLeaf("Rd01").allCertain())
        assert(not ps.getLeaf("Rd02").allCertain())
        assert(ps.getLeaf("Rd03").allCertain())
        assert(ps.getLeaf("Rd04").allCertain())
        assert(ps.getLeaf("Rd05").allCertain())
        ps.printLeaves()

        turn = 10
        print "Turn", turn
        ps.getLeaf("Rd01").split(2, "Rd06", turn)
        assert(not ps.getLeaf("Rd01").allCertain())
        assert(not ps.getLeaf("Rd02").allCertain())
        assert(ps.getLeaf("Rd03").allCertain())
        assert(ps.getLeaf("Rd04").allCertain())
        assert(ps.getLeaf("Rd05").allCertain())
        assert(not ps.getLeaf("Rd06").allCertain())
        ps.printLeaves()

        turn = 11
        print "Turn", turn
        ps.getLeaf("Rd04").revealCreatures(["Griffon", "Lion", "Lion", "Lion",
            "Centaur", "Centaur"])
        ps.getLeaf("Rd01").revealCreatures(["Cyclops"])
        ps.getLeaf("Rd01").addCreature("Cyclops")
        ps.getLeaf("Rd03").revealCreatures(["Troll", "Troll"])
        ps.getLeaf("Rd03").addCreature("Ranger")
        assert(not ps.getLeaf("Rd01").allCertain())
        assert(not ps.getLeaf("Rd02").allCertain())
        assert(ps.getLeaf("Rd03").allCertain())
        assert(ps.getLeaf("Rd04").allCertain())
        assert(ps.getLeaf("Rd05").allCertain())
        assert(not ps.getLeaf("Rd06").allCertain())
        ps.printLeaves()

        turn = 12
        print "Turn", turn
        ps.getLeaf("Rd02").addCreature("Centaur")
        ps.getLeaf("Rd03").revealCreatures(["Troll", "Troll"])
        ps.getLeaf("Rd03").addCreature("Warbear")
        ps.getLeaf("Rd05").revealCreatures(["Cyclops"])
        ps.getLeaf("Rd05").addCreature("Cyclops")
        assert(not ps.getLeaf("Rd01").allCertain())
        assert(not ps.getLeaf("Rd02").allCertain())
        assert(ps.getLeaf("Rd03").allCertain())
        assert(ps.getLeaf("Rd04").allCertain())
        assert(ps.getLeaf("Rd05").allCertain())
        assert(not ps.getLeaf("Rd06").allCertain())
        ps.printLeaves()

        turn = 13
        print "Turn", turn
        ps.getLeaf("Rd01").revealCreatures(["Titan", "Warlock", "Warlock",
            "Cyclops", "Cyclops", "Cyclops"])
        ps.getLeaf("Rd05").revealCreatures(["Cyclops", "Cyclops", "Cyclops"])
        ps.getLeaf("Rd05").addCreature("Behemoth")
        assert(ps.getLeaf("Rd01").allCertain())
        assert(ps.getLeaf("Rd02").allCertain())
        assert(ps.getLeaf("Rd03").allCertain())
        assert(ps.getLeaf("Rd04").allCertain())
        assert(ps.getLeaf("Rd05").allCertain())
        assert(ps.getLeaf("Rd06").allCertain())
        ps.printLeaves()

        turn = 14
        print "Turn", turn
        ps.getLeaf("Rd04").revealCreatures(["Griffon", "Lion", "Lion", "Lion",
                                              "Centaur", "Centaur"])
        ps.getLeaf("Rd02").removeCreature("Angel")
        ps.getLeaf("Rd04").addCreature("Angel")
        ps.getLeaf("Rd04").removeCreatures(["Angel", "Lion", "Lion", "Lion",
                                            "Centaur", "Centaur"])
        ps.getLeaf("Rd04").addCreature("Angel")
        assert(ps.getLeaf("Rd01").allCertain())
        assert(ps.getLeaf("Rd02").allCertain())
        assert(ps.getLeaf("Rd03").allCertain())
        assert(ps.getLeaf("Rd04").allCertain())
        assert(ps.getLeaf("Rd05").allCertain())
        assert(ps.getLeaf("Rd06").allCertain())
        ps.printLeaves()

        print "test 1 ends"


    def testPredictSplits2(self):
        print "\ntest 2 begins"

        ps = PredictSplits("Rd", "Rd11", self.starting_creatures)
        ps.printLeaves()

        turn = 1
        print "Turn", turn
        ps.getLeaf("Rd11").split(4, "Rd10", turn)
        ps.getLeaf("Rd10").revealCreatures(["Ogre", "Ogre"])
        ps.getLeaf("Rd10").addCreature("Troll")
        ps.getLeaf("Rd11").revealCreatures(["Gargoyle"])
        ps.getLeaf("Rd11").addCreature("Gargoyle")
        assert(not ps.getLeaf("Rd10").allCertain())
        assert(not ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 2
        print "Turn", turn
        ps.getLeaf("Rd10").revealCreatures(["Troll"])
        ps.getLeaf("Rd10").addCreature("Troll")
        assert(not ps.getLeaf("Rd10").allCertain())
        assert(not ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 3
        print "Turn", turn
        ps.getLeaf("Rd10").revealCreatures(["Troll", "Troll"])
        ps.getLeaf("Rd10").addCreature("Ranger")
        ps.getLeaf("Rd11").revealCreatures(["Gargoyle", "Gargoyle"])
        ps.getLeaf("Rd11").addCreature("Cyclops")
        assert(not ps.getLeaf("Rd10").allCertain())
        assert(not ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 4
        print "Turn", turn
        ps.getLeaf("Rd10").revealCreatures(["Titan", "Ranger", "Troll",
            "Troll", "Gargoyle", "Ogre", "Ogre"])
        ps.printLeaves()
        ps.getLeaf("Rd10").removeCreature("Gargoyle")
        ps.getLeaf("Rd11").removeCreature("Angel")
        ps.getLeaf("Rd10").addCreature("Angel")
        assert(ps.getLeaf("Rd10").allCertain())
        assert(ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 5
        print "Turn", turn
        ps.getLeaf("Rd10").split(2, "Rd01", turn)
        ps.getLeaf("Rd10").revealCreatures(["Troll"])
        ps.getLeaf("Rd10").addCreature("Troll")
        ps.getLeaf("Rd01").revealCreatures(["Ogre", "Ogre"])
        ps.getLeaf("Rd01").addCreature("Troll")
        assert(ps.getLeaf("Rd01").allCertain())
        assert(ps.getLeaf("Rd10").allCertain())
        assert(ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 6
        print "Turn", turn
        ps.getLeaf("Rd01").revealCreatures(["Troll", "Ogre", "Ogre"])
        ps.getLeaf("Rd01").revealCreatures(["Troll"])
        ps.getLeaf("Rd01").addCreature("Troll")
        ps.getLeaf("Rd10").revealCreatures(["Troll", "Troll", "Troll"])
        ps.getLeaf("Rd10").addCreature("Wyvern")
        ps.getLeaf("Rd11").revealCreatures(["Cyclops"])
        ps.getLeaf("Rd11").addCreature("Cyclops")
        assert(ps.getLeaf("Rd01").allCertain())
        assert(ps.getLeaf("Rd10").allCertain())
        assert(ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 7
        print "Turn", turn
        ps.getLeaf("Rd10").split(2, "Rd06", turn)
        ps.getLeaf("Rd11").revealCreatures(["Centaur", "Centaur"])
        ps.getLeaf("Rd11").addCreature("Lion")
        assert(ps.getLeaf("Rd01").allCertain())
        assert(not ps.getLeaf("Rd06").allCertain())
        assert(not ps.getLeaf("Rd10").allCertain())
        assert(ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 8
        print "Turn", turn
        ps.getLeaf("Rd11").split(2, "Rd07", turn)
        ps.getLeaf("Rd01").revealCreatures(["Troll", "Troll", "Ogre", "Ogre"])
        ps.getLeaf("Rd10").removeCreature("Angel")
        ps.getLeaf("Rd01").addCreature("Angel")
        ps.getLeaf("Rd01").removeCreatures(["Troll", "Troll", "Ogre", "Ogre"])
        ps.getLeaf("Rd01").addCreature("Angel")
        ps.getLeaf("Rd10").revealCreatures(["Wyvern"])
        ps.getLeaf("Rd10").addCreature("Wyvern")
        ps.getLeaf("Rd11").revealCreatures(["Lion"])
        ps.getLeaf("Rd11").addCreature("Lion")
        assert(ps.getLeaf("Rd01").allCertain())
        assert(not ps.getLeaf("Rd06").allCertain())
        assert(not ps.getLeaf("Rd07").allCertain())
        assert(not ps.getLeaf("Rd10").allCertain())
        assert(not ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 9
        print "Turn", turn
        ps.getLeaf("Rd07").addCreature("Centaur")
        ps.getLeaf("Rd11").revealCreatures(["Cyclops"])
        ps.getLeaf("Rd11").addCreature("Cyclops")
        assert(ps.getLeaf("Rd01").allCertain())
        assert(not ps.getLeaf("Rd06").allCertain())
        assert(not ps.getLeaf("Rd07").allCertain())
        assert(not ps.getLeaf("Rd10").allCertain())
        assert(not ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 10
        print "Turn", turn
        ps.getLeaf("Rd11").split(2, "Rd08", turn)
        ps.getLeaf("Rd01").revealCreatures(["Angel", "Angel"])
        ps.getLeaf("Rd06").revealCreatures(["Troll", "Troll"])
        ps.getLeaf("Rd06").addCreature("Warbear")
        ps.getLeaf("Rd07").revealCreatures(["Centaur"])
        ps.getLeaf("Rd07").addCreature("Centaur")
        ps.getLeaf("Rd08").revealCreatures(["Centaur", "Centaur"])
        ps.getLeaf("Rd08").addCreature("Lion")
        ps.getLeaf("Rd10").revealCreatures(["Ranger"])
        ps.getLeaf("Rd10").addCreature("Ranger")
        ps.getLeaf("Rd11").revealCreatures(["Cyclops", "Cyclops", "Cyclops"])
        ps.getLeaf("Rd11").addCreature("Behemoth")
        ps.getLeaf("Rd01").revealCreatures(["Angel", "Angel"])
        ps.getLeaf("Rd01").removeCreatures(["Angel", "Angel"])
        assert(ps.getLeaf("Rd06").allCertain())
        assert(ps.getLeaf("Rd07").allCertain())
        assert(ps.getLeaf("Rd08").allCertain())
        assert(ps.getLeaf("Rd10").allCertain())
        assert(ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 11
        print "Turn", turn
        ps.getLeaf("Rd06").revealCreatures(["Troll", "Troll"])
        ps.getLeaf("Rd06").addCreature("Ranger")
        ps.getLeaf("Rd07").revealCreatures(["Centaur", "Centaur"])
        ps.getLeaf("Rd07").addCreature("Lion")
        ps.getLeaf("Rd08").revealCreatures(["Lion"])
        ps.getLeaf("Rd08").addCreature("Lion")
        ps.getLeaf("Rd10").revealCreatures(["Titan"])
        ps.getLeaf("Rd10").addCreature("Warlock")
        assert(ps.getLeaf("Rd06").allCertain())
        assert(ps.getLeaf("Rd07").allCertain())
        assert(ps.getLeaf("Rd08").allCertain())
        assert(ps.getLeaf("Rd10").allCertain())
        assert(ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 12
        print "Turn", turn
        ps.getLeaf("Rd10").split(2, "Rd05", turn)
        ps.getLeaf("Rd05").revealCreatures(["Troll"])
        ps.getLeaf("Rd05").addCreature("Troll")
        ps.getLeaf("Rd06").revealCreatures(["Troll", "Troll"])
        ps.getLeaf("Rd06").addCreature("Warbear")
        ps.getLeaf("Rd07").revealCreatures(["Lion"])
        ps.getLeaf("Rd07").addCreature("Lion")
        ps.getLeaf("Rd11").revealCreatures(["Lion", "Lion"])
        ps.getLeaf("Rd11").addCreature("Ranger")
        assert(not ps.getLeaf("Rd05").allCertain())
        assert(ps.getLeaf("Rd06").allCertain())
        assert(ps.getLeaf("Rd07").allCertain())
        assert(ps.getLeaf("Rd08").allCertain())
        assert(not ps.getLeaf("Rd10").allCertain())
        assert(ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 13
        print "Turn", turn
        ps.getLeaf("Rd11").split(2, "Rd04", turn)
        ps.getLeaf("Rd05").revealCreatures(["Troll", "Troll"])
        ps.getLeaf("Rd05").addCreature("Warbear")
        ps.getLeaf("Rd07").revealCreatures(["Gargoyle", "Gargoyle"])
        ps.getLeaf("Rd07").addCreature("Cyclops")
        ps.getLeaf("Rd11").revealCreatures(["Ranger"])
        ps.getLeaf("Rd11").addCreature("Ranger")
        ps.getLeaf("Rd08").revealCreatures(["Lion", "Lion", "Centaur",
                "Centaur"])
        ps.getLeaf("Rd08").removeCreatures(["Lion", "Lion", "Centaur",
                "Centaur"])
        assert(not ps.getLeaf("Rd04").allCertain())
        assert(not ps.getLeaf("Rd05").allCertain())
        assert(ps.getLeaf("Rd06").allCertain())
        assert(ps.getLeaf("Rd07").allCertain())
        assert(not ps.getLeaf("Rd10").allCertain())
        assert(not ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 14
        print "Turn", turn
        ps.getLeaf("Rd06").revealCreatures(["Warbear", "Warbear", "Ranger",
                "Troll", "Troll"])
        ps.getLeaf("Rd04").revealCreatures(["Cyclops"])
        ps.getLeaf("Rd04").addCreature("Cyclops")
        ps.getLeaf("Rd06").revealCreatures(["Ranger"])
        ps.getLeaf("Rd06").addCreature("Ranger")
        ps.getLeaf("Rd10").revealCreatures(["Wyvern", "Wyvern"])
        ps.getLeaf("Rd10").addCreature("Hydra")
        ps.getLeaf("Rd11").revealCreatures(["Ranger"])
        ps.getLeaf("Rd11").addCreature("Ranger")
        assert(not ps.getLeaf("Rd04").allCertain())
        assert(not ps.getLeaf("Rd05").allCertain())
        assert(ps.getLeaf("Rd06").allCertain())
        assert(ps.getLeaf("Rd07").allCertain())
        assert(not ps.getLeaf("Rd10").allCertain())
        assert(not ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 15
        print "Turn", turn
        ps.getLeaf("Rd07").split(2, "Rd02", turn)
        ps.getLeaf("Rd11").split(2, "Rd01", turn)
        ps.getLeaf("Rd05").revealCreatures(["Troll"])
        ps.getLeaf("Rd05").addCreature("Troll")
        ps.getLeaf("Rd06").revealCreatures(["Ranger"])
        ps.getLeaf("Rd06").addCreature("Ranger")
        ps.getLeaf("Rd11").revealCreatures(["Cyclops", "Cyclops"])
        ps.getLeaf("Rd11").addCreature("Gorgon")
        assert(not ps.getLeaf("Rd01").allCertain())
        assert(not ps.getLeaf("Rd02").allCertain())
        assert(not ps.getLeaf("Rd04").allCertain())
        assert(not ps.getLeaf("Rd05").allCertain())
        assert(ps.getLeaf("Rd06").allCertain())
        assert(not ps.getLeaf("Rd07").allCertain())
        assert(not ps.getLeaf("Rd10").allCertain())
        assert(not ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 16
        print "Turn", turn
        ps.getLeaf("Rd06").revealCreatures(["Warbear", "Warbear", "Ranger",
                "Ranger", "Ranger", "Troll", "Troll"])
        ps.getLeaf("Rd01").revealCreatures(["Ranger"])
        ps.getLeaf("Rd01").addCreature("Ranger")
        ps.getLeaf("Rd04").revealCreatures(["Cyclops"])
        ps.getLeaf("Rd04").addCreature("Cyclops")
        ps.getLeaf("Rd05").revealCreatures(["Ranger"])
        ps.getLeaf("Rd05").addCreature("Ranger")
        ps.getLeaf("Rd07").revealCreatures(["Lion", "Lion"])
        ps.getLeaf("Rd07").addCreature("Ranger")
        ps.getLeaf("Rd10").revealCreatures(["Ranger"])
        ps.getLeaf("Rd10").addCreature("Ranger")
        ps.getLeaf("Rd11").revealCreatures(["Ranger"])
        ps.getLeaf("Rd11").addCreature("Ranger")
        assert(not ps.getLeaf("Rd01").allCertain())
        assert(not ps.getLeaf("Rd02").allCertain())
        assert(not ps.getLeaf("Rd04").allCertain())
        assert(ps.getLeaf("Rd05").allCertain())
        assert(ps.getLeaf("Rd06").allCertain())
        assert(not ps.getLeaf("Rd07").allCertain())
        assert(ps.getLeaf("Rd10").allCertain())
        assert(not ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 17
        print "Turn", turn
        ps.getLeaf("Rd06").split(2, "Rd08", turn)
        ps.getLeaf("Rd11").split(2, "Rd03", turn)
        ps.getLeaf("Rd08").revealCreatures(["Troll", "Troll"])
        ps.getLeaf("Rd08").removeCreatures(["Troll", "Troll"])
        ps.getLeaf("Rd05").revealCreatures(["Warbear"])
        ps.getLeaf("Rd05").addCreature("Warbear")
        ps.getLeaf("Rd11").revealCreatures(["Behemoth"])
        ps.getLeaf("Rd11").addCreature("Behemoth")
        assert(not ps.getLeaf("Rd01").allCertain())
        assert(not ps.getLeaf("Rd02").allCertain())
        assert(not ps.getLeaf("Rd03").allCertain())
        assert(ps.getLeaf("Rd04").allCertain())
        assert(ps.getLeaf("Rd05").allCertain())
        assert(ps.getLeaf("Rd06").allCertain())
        assert(not ps.getLeaf("Rd07").allCertain())
        assert(ps.getLeaf("Rd10").allCertain())
        assert(not ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 18
        print "Turn", turn
        ps.getLeaf("Rd10").split(2, "Rd12", turn)
        ps.getLeaf("Rd01").revealCreatures(["Ranger"])
        ps.getLeaf("Rd01").addCreature("Ranger")
        ps.getLeaf("Rd11").revealCreatures(["Gorgon"])
        ps.getLeaf("Rd11").addCreature("Gorgon")
        ps.getLeaf("Rd12").revealCreatures(["Ranger", "Ranger"])
        ps.getLeaf("Rd12").removeCreatures(["Ranger", "Ranger"])
        assert(not ps.getLeaf("Rd01").allCertain())
        assert(not ps.getLeaf("Rd02").allCertain())
        assert(not ps.getLeaf("Rd03").allCertain())
        assert(ps.getLeaf("Rd04").allCertain())
        assert(ps.getLeaf("Rd05").allCertain())
        assert(ps.getLeaf("Rd06").allCertain())
        assert(not ps.getLeaf("Rd07").allCertain())
        assert(ps.getLeaf("Rd10").allCertain())
        assert(not ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 19
        print "Turn", turn
        ps.getLeaf("Rd11").split(2, "Rd08", turn)
        ps.getLeaf("Rd07").revealCreatures(["Cyclops", "Ranger", "Lion",
                "Lion", "Centaur", "Centaur"])
        ps.getLeaf("Rd07").removeCreatures(["Lion", "Centaur", "Centaur"])
        ps.getLeaf("Rd01").revealCreatures(["Ranger"])
        ps.getLeaf("Rd01").addCreature("Ranger")
        ps.getLeaf("Rd03").revealCreatures(["Cyclops"])
        ps.getLeaf("Rd03").addCreature("Cyclops")
        ps.getLeaf("Rd04").revealCreatures(["Cyclops", "Cyclops"])
        ps.getLeaf("Rd04").addCreature("Gorgon")
        ps.getLeaf("Rd07").revealCreatures(["Ranger"])
        ps.getLeaf("Rd07").addCreature("Ranger")
        ps.getLeaf("Rd08").revealCreatures(["Ranger"])
        ps.getLeaf("Rd08").addCreature("Ranger")
        assert(not ps.getLeaf("Rd01").allCertain())
        assert(ps.getLeaf("Rd02").allCertain())
        assert(not ps.getLeaf("Rd03").allCertain())
        assert(ps.getLeaf("Rd04").allCertain())
        assert(ps.getLeaf("Rd05").allCertain())
        assert(ps.getLeaf("Rd06").allCertain())
        assert(ps.getLeaf("Rd07").allCertain())
        assert(not ps.getLeaf("Rd08").allCertain())
        assert(ps.getLeaf("Rd10").allCertain())
        assert(not ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        turn = 20
        print "Turn", turn
        ps.getLeaf("Rd04").revealCreatures(["Gorgon", "Cyclops", "Cyclops",
                "Cyclops", "Lion"])
        ps.getLeaf("Rd10").revealCreatures(["Titan", "Hydra", "Wyvern",
                "Wyvern", "Warlock"])
        ps.getLeaf("Rd10").addCreature("Angel")
        ps.getLeaf("Rd05").revealCreatures(["Warbear", "Warbear", "Ranger",
                "Ranger", "Troll", "Troll", "Troll"])
        ps.getLeaf("Rd10").removeCreature("Angel")
        ps.getLeaf("Rd05").removeCreature("Troll")
        ps.getLeaf("Rd05").addCreature("Angel")
        ps.getLeaf("Rd05").removeCreatures(["Angel", "Warbear", "Warbear",
                "Ranger", "Ranger", "Troll"])
        assert(not ps.getLeaf("Rd01").allCertain())
        assert(ps.getLeaf("Rd02").allCertain())
        assert(not ps.getLeaf("Rd03").allCertain())
        assert(ps.getLeaf("Rd04").allCertain())
        assert(ps.getLeaf("Rd05").allCertain())
        assert(ps.getLeaf("Rd06").allCertain())
        assert(ps.getLeaf("Rd07").allCertain())
        assert(not ps.getLeaf("Rd08").allCertain())
        assert(ps.getLeaf("Rd10").allCertain())
        assert(not ps.getLeaf("Rd11").allCertain())
        ps.printLeaves()

        print "test 2 ends"


    def testPredictSplits3(self):
        print "\ntest 3 begins"

        ps = PredictSplits("Gr", "Gr07", self.starting_creatures)
        ps.printLeaves()

        turn = 1
        print "Turn", turn
        ps.getLeaf("Gr07").split(4, "Gr11", turn)
        ps.getLeaf("Gr07").revealCreatures(["Gargoyle", "Gargoyle"])
        ps.getLeaf("Gr07").addCreature("Cyclops")
        ps.getLeaf("Gr11").revealCreatures(["Centaur"])
        ps.getLeaf("Gr11").addCreature("Centaur")
        assert(not ps.getLeaf("Gr07").allCertain())
        assert(not ps.getLeaf("Gr11").allCertain())
        ps.printLeaves()

        turn = 2
        print "Turn", turn
        ps.getLeaf("Gr07").revealCreatures(["Gargoyle", "Gargoyle"])
        ps.getLeaf("Gr07").addCreature("Cyclops")
        ps.getLeaf("Gr11").revealCreatures(["Ogre"])
        ps.getLeaf("Gr11").addCreature("Ogre")
        assert(not ps.getLeaf("Gr07").allCertain())
        assert(not ps.getLeaf("Gr11").allCertain())
        ps.printLeaves()

        turn = 3
        print "Turn", turn
        ps.getLeaf("Gr11").revealCreatures(["Centaur", "Centaur", "Centaur"])
        ps.getLeaf("Gr11").addCreature("Warbear")
        assert(not ps.getLeaf("Gr07").allCertain())
        assert(not ps.getLeaf("Gr11").allCertain())
        ps.printLeaves()

        print "test 3 ends"


    def testPredictSplits4(self):
        print "\ntest 4 begins"
        creatures = []
        creatures.append(CreatureInfo('Angel', True, True))
        creatures.append(CreatureInfo('Gargoyle', True, True))
        creatures.append(CreatureInfo('Centaur', True, True))
        creatures.append(CreatureInfo('Centaur', False, True))
        creatures.append(CreatureInfo('Centaur', True, False))
        n = Node("Gd10", 1, creatures, None)
        n.revealCreatures(['Gargoyle', 'Gargoyle'])
        print n
        assert(n.allCertain())
        print "test 4 ends"


    def testPredictSplits5(self):
        print "\ntest 5 begins"
        ps = PredictSplits("Gd", "Gd04", self.starting_creatures)
        ps.getLeaf("Gd04").revealCreatures(['Titan', 'Angel', 'Gargoyle',
          'Gargoyle', 'Centaur', 'Centaur', 'Ogre', 'Ogre'])
        ps.printLeaves()
        assert(ps.getLeaf("Gd04").allCertain())

        turn = 1
        print "\nTurn", turn
        ps.getLeaf("Gd04").split(4, "Gd12", turn)
        ps.getLeaf("Gd12").revealCreatures(['Titan'])
        ps.getLeaf("Gd04").revealCreatures(['Centaur'])
        ps.getLeaf("Gd04").addCreature("Centaur")
        ps.getLeaf("Gd12").revealCreatures(['Titan'])
        ps.getLeaf("Gd12").addCreature("Warlock")
        ps.printLeaves()
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd12").numUncertainCreatures() == 3)

        turn = 2
        ps.getLeaf("Gd04").revealCreatures(['Ogre', 'Ogre'])
        ps.getLeaf("Gd04").addCreature("Troll")
        ps.getLeaf("Gd12").revealCreatures(['Gargoyle', 'Gargoyle'])
        ps.getLeaf("Gd12").addCreature("Cyclops")
        ps.printLeaves()
        assert(ps.getLeaf("Gd04").allCertain())
        assert(ps.getLeaf("Gd12").allCertain())

        turn = 3
        ps.getLeaf("Gd04").revealCreatures(['Centaur', 'Centaur'])
        ps.getLeaf("Gd04").addCreature("Lion")
        ps.printLeaves()
        assert(ps.getLeaf("Gd04").allCertain())
        assert(ps.getLeaf("Gd12").allCertain())

        turn = 4
        print "\nTurn", turn
        ps.getLeaf("Gd04").split(2, "Gd07", turn)
        ps.getLeaf("Gd04").revealCreatures(['Troll'])
        ps.getLeaf("Gd04").addCreature("Troll")
        ps.printLeaves()
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 4)
        assert(ps.getLeaf("Gd07").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd12").allCertain())

        turn = 5
        print "\nTurn", turn
        ps.getLeaf("Gd04").revealCreatures(['Lion'])
        ps.getLeaf("Gd04").addCreature("Lion")
        ps.getLeaf("Gd12").revealCreatures(['Centaur'])
        ps.getLeaf("Gd12").addCreature("Centaur")
        ps.printLeaves()
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 3)
        assert(ps.getLeaf("Gd07").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd12").allCertain())

        turn = 6
        print "\nTurn", turn
        ps.getLeaf("Gd04").split(2, "Gd08", turn)
        ps.getLeaf("Gd12").split(2, "Gd03", turn)
        ps.getLeaf("Gd08").revealCreatures(['Ogre'])
        ps.getLeaf("Gd08").addCreature("Ogre")
        ps.getLeaf("Gd12").revealCreatures(['Centaur', 'Centaur'])
        ps.getLeaf("Gd12").addCreature("Lion")
        ps.getLeaf("Gd07").revealCreatures(['Centaur', 'Centaur'])
        ps.getLeaf("Gd07").addCreature("Lion")
        ps.getLeaf("Gd12").revealCreatures(['Lion'])
        ps.getLeaf("Gd12").addCreature("Lion")
        ps.printLeaves()
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 3)
        assert(ps.getLeaf("Gd07").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd08").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd12").numUncertainCreatures() == 3)

        turn = 7
        print "\nTurn", turn
        ps.getLeaf("Gd12").split(2, "Gd09", turn)
        ps.getLeaf("Gd03").revealCreatures(['Gargoyle', 'Gargoyle'])
        ps.getLeaf("Gd03").addCreature("Cyclops")
        ps.getLeaf("Gd07").revealCreatures(['Lion'])
        ps.getLeaf("Gd07").addCreature("Lion")
        ps.getLeaf("Gd08").revealCreatures(['Ogre', 'Ogre'])
        ps.getLeaf("Gd08").addCreature("Troll")
        ps.printLeaves()
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 3)
        assert(ps.getLeaf("Gd07").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd08").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd09").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd12").numUncertainCreatures() == 5)

        turn = 8
        print "\nTurn", turn
        ps.getLeaf("Gd04").revealCreatures(['Lion', 'Lion'])
        ps.getLeaf("Gd04").addCreature("Ranger")
        ps.getLeaf("Gd07").revealCreatures(['Lion', 'Lion'])
        ps.getLeaf("Gd07").addCreature("Ranger")
        ps.getLeaf("Gd08").revealCreatures(['Troll'])
        ps.getLeaf("Gd08").addCreature("Troll")
        ps.getLeaf("Gd12").revealCreatures(['Cyclops'])
        ps.getLeaf("Gd12").addCreature("Cyclops")
        ps.printLeaves()
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd07").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd08").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd09").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd12").numUncertainCreatures() == 4)

        turn = 10
        print "\nTurn", turn
        ps.getLeaf("Gd07").revealCreatures(['Ranger'])
        ps.getLeaf("Gd07").addCreature("Ranger")
        ps.getLeaf("Gd12").revealCreatures(['Lion', 'Lion'])
        ps.getLeaf("Gd12").addCreature("Ranger")
        ps.printLeaves()
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd07").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd08").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd09").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd12").numUncertainCreatures() == 2)

        turn = 11
        print "\nTurn", turn
        ps.getLeaf("Gd03").revealCreatures(['Cyclops'])
        ps.getLeaf("Gd03").addCreature("Cyclops")
        ps.getLeaf("Gd07").revealCreatures(['Lion', 'Lion'])
        ps.getLeaf("Gd07").addCreature("Ranger")
        ps.getLeaf("Gd09").revealCreatures(['Centaur'])
        ps.getLeaf("Gd09").addCreature("Centaur")
        ps.getLeaf("Gd08").removeCreature("Troll")
        ps.getLeaf("Gd08").removeCreature("Troll")
        ps.getLeaf("Gd08").removeCreature("Ogre")
        ps.getLeaf("Gd08").removeCreature("Ogre")
        ps.getLeaf("Gd08").removeCreature("Ogre")
        ps.printLeaves()
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd07").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd08")) is None
        assert(ps.getLeaf("Gd09").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd12").numUncertainCreatures() == 2)

        turn = 12
        print "\nTurn", turn
        ps.getLeaf("Gd07").split(2, "Gd06", turn)
        ps.getLeaf("Gd09").revealCreatures(['Centaur', 'Centaur'])
        ps.getLeaf("Gd09").addCreature("Lion")
        ps.printLeaves()
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd06").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd07").numUncertainCreatures() == 4)
        assert(ps.getLeaf("Gd09").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd12").numUncertainCreatures() == 2)

        turn = 13
        print "\nTurn", turn
        ps.getLeaf("Gd12").split(2, "Gd10", turn)
        ps.getLeaf("Gd03").revealCreatures(['Cyclops'])
        ps.getLeaf("Gd03").addCreature("Cyclops")
        ps.getLeaf("Gd04").revealCreatures(['Lion', 'Lion'])
        ps.getLeaf("Gd04").addCreature("Ranger")
        ps.getLeaf("Gd12").revealCreatures(['Cyclops', 'Cyclops'])
        ps.getLeaf("Gd12").addCreature("Gorgon")
        ps.printLeaves()
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd06").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd07").numUncertainCreatures() == 4)
        assert(ps.getLeaf("Gd09").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd10").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd12").numUncertainCreatures() == 3)

        turn = 14
        print "\nTurn", turn
        ps.getLeaf("Gd04").split(2, "Gd02", turn)
        ps.getLeaf("Gd07").revealCreatures(['Lion', 'Lion'])
        ps.getLeaf("Gd07").addCreature("Minotaur")
        ps.getLeaf("Gd09").revealCreatures(['Centaur', 'Centaur', 'Centaur'])
        ps.getLeaf("Gd09").addCreature("Warbear")
        ps.getLeaf("Gd10").revealCreatures(['Lion'])
        ps.getLeaf("Gd10").addCreature("Lion")
        ps.getLeaf("Gd12").revealCreatures(['Cyclops'])
        ps.getLeaf("Gd12").addCreature("Cyclops")
        ps.printLeaves()
        assert(ps.getLeaf("Gd02").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 5)
        assert(ps.getLeaf("Gd06").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd07").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd09").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd10").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd12").numUncertainCreatures() == 3)

        turn = 15
        print "\nTurn", turn
        ps.getLeaf("Gd12").split(2, "Gd11", turn)
        ps.printLeaves()
        assert(ps.getLeaf("Gd02").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 5)
        assert(ps.getLeaf("Gd06").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd07").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd09").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd10").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd12").numUncertainCreatures() == 4)

        turn = 16
        print "\nTurn", turn
        ps.getLeaf("Gd07").revealCreatures(['Ranger', 'Ranger', 'Ranger',
          'Minotaur', 'Lion', 'Lion'])
        ps.getLeaf("Gd04").removeCreature("Angel")
        ps.getLeaf("Gd07").addCreature("Angel")
        ps.getLeaf("Gd02").revealCreatures(['Lion', 'Lion'])
        ps.getLeaf("Gd02").addCreature("Ranger")
        ps.getLeaf("Gd11").revealCreatures(['Ranger'])
        ps.getLeaf("Gd11").addCreature("Ranger")
        ps.printLeaves()
        assert(ps.getLeaf("Gd02").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd06").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd07").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd09").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd10").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd12").numUncertainCreatures() == 3)

        turn = 17
        print "\nTurn", turn
        ps.getLeaf("Gd07").split(2, "Gd08", turn)
        ps.getLeaf("Gd02").revealCreatures(['Ranger'])
        ps.getLeaf("Gd02").addCreature("Ranger")
        ps.getLeaf("Gd04").revealCreatures(['Troll'])
        ps.getLeaf("Gd04").addCreature("Troll")
        ps.getLeaf("Gd09").revealCreatures(['Lion'])
        ps.getLeaf("Gd09").addCreature("Lion")
        ps.getLeaf("Gd10").revealCreatures(['Lion', 'Lion', 'Lion'])
        ps.getLeaf("Gd11").revealCreatures(['Cyclops'])
        ps.getLeaf("Gd11").addCreature("Cyclops")
        ps.getLeaf("Gd07").revealCreatures(['Angel', 'Ranger', 'Ranger',
          'Ranger', 'Minotaur'])
        ps.getLeaf("Gd07").removeCreature("Minotaur")
        ps.getLeaf("Gd07").removeCreature("Angel")
        ps.getLeaf("Gd07").removeCreature("Ranger")
        ps.getLeaf("Gd07").removeCreature("Ranger")
        ps.getLeaf("Gd07").removeCreature("Ranger")
        ps.getLeaf("Gd04").revealCreatures(['Ranger', 'Ranger', 'Troll',
          'Troll', 'Troll'])
        ps.getLeaf("Gd04").removeCreature("Ranger")
        ps.getLeaf("Gd04").removeCreature("Ranger")
        ps.getLeaf("Gd04").removeCreature("Troll")
        ps.getLeaf("Gd04").removeCreature("Troll")
        ps.getLeaf("Gd04").removeCreature("Troll")
        ps.getLeaf("Gd02").revealCreatures(['Lion'])
        ps.printLeaves()
        assert(ps.getLeaf("Gd02").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd04") is None)
        assert(ps.getLeaf("Gd06").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd07") is None)
        assert(ps.getLeaf("Gd08").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd09").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd10").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd12").numUncertainCreatures() == 0)

        turn = 18
        print "\nTurn", turn
        ps.getLeaf("Gd02").addCreature("Lion")
        ps.getLeaf("Gd08").revealCreatures(['Lion', 'Lion'])
        ps.getLeaf("Gd08").addCreature("Ranger")
        ps.getLeaf("Gd10").revealCreatures(['Lion', 'Lion'])
        ps.getLeaf("Gd10").addCreature("Ranger")
        ps.getLeaf("Gd06").removeCreature("Centaur")
        ps.getLeaf("Gd06").removeCreature("Centaur")
        ps.printLeaves()
        assert(ps.getLeaf("Gd02").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd06") is None)
        assert(ps.getLeaf("Gd08").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd09").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd10").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd12").numUncertainCreatures() == 0)

        turn = 19
        print "\nTurn", turn
        ps.getLeaf("Gd03").revealCreatures(['Cyclops', 'Cyclops'])
        ps.getLeaf("Gd03").addCreature("Gorgon")
        ps.getLeaf("Gd10").revealCreatures(['Lion'])
        ps.getLeaf("Gd10").addCreature("Lion")
        ps.printLeaves()
        assert(ps.getLeaf("Gd02").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd08").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd09").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd10").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd12").numUncertainCreatures() == 0)

        turn = 20
        print "\nTurn", turn
        ps.getLeaf("Gd02").revealCreatures(['Lion', 'Lion', 'Lion'])
        ps.getLeaf("Gd08").revealCreatures(['Lion'])
        ps.getLeaf("Gd08").addCreature("Lion")
        ps.getLeaf("Gd09").revealCreatures(['Lion'])
        ps.getLeaf("Gd09").addCreature("Lion")
        ps.getLeaf("Gd11").revealCreatures(['Ranger'])
        ps.getLeaf("Gd11").addCreature("Troll")
        ps.printLeaves()
        assert(ps.getLeaf("Gd02").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd08").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd09").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd10").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd12").numUncertainCreatures() == 0)

        turn = 22
        print "\nTurn", turn
        ps.getLeaf("Gd09").split(2, "Gd07", turn)
        ps.getLeaf("Gd03").revealCreatures(['Cyclops', 'Cyclops', 'Cyclops'])
        ps.getLeaf("Gd03").addCreature("Behemoth")
        ps.getLeaf("Gd08").revealCreatures(['Ranger'])
        ps.getLeaf("Gd08").addCreature("Troll")
        ps.getLeaf("Gd09").revealCreatures(['Warbear'])
        ps.getLeaf("Gd09").addCreature("Warbear")
        ps.getLeaf("Gd10").revealCreatures(['Ranger'])
        ps.getLeaf("Gd10").addCreature("Troll")
        ps.getLeaf("Gd11").revealCreatures(['Ranger'])
        ps.getLeaf("Gd11").addCreature("Lion")
        ps.getLeaf("Gd12").revealCreatures(['Cyclops', 'Cyclops'])
        ps.getLeaf("Gd12").addCreature("Gorgon")
        ps.printLeaves()
        assert(ps.getLeaf("Gd02").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd07").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd08").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd09").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd10").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd12").numUncertainCreatures() == 0)

        turn = 23
        print "\nTurn", turn
        ps.getLeaf("Gd03").split(2, "Gd05", turn)
        ps.getLeaf("Gd02").revealCreatures(['Ranger'])
        ps.getLeaf("Gd02").addCreature("Troll")
        ps.getLeaf("Gd03").revealCreatures(['Cyclops', 'Cyclops'])
        ps.getLeaf("Gd03").addCreature("Gorgon")
        ps.getLeaf("Gd07").revealCreatures(['Centaur'])
        ps.getLeaf("Gd07").addCreature("Centaur")
        ps.getLeaf("Gd08").revealCreatures(['Lion'])
        ps.getLeaf("Gd08").addCreature("Lion")
        ps.getLeaf("Gd11").revealCreatures(['Lion'])
        ps.getLeaf("Gd11").addCreature("Lion")
        ps.getLeaf("Gd12").revealCreatures(['Cyclops'])
        ps.getLeaf("Gd12").addCreature("Cyclops")
        ps.printLeaves()
        assert(ps.getLeaf("Gd02").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 3)
        assert(ps.getLeaf("Gd05").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd07").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd08").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd09").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd10").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd12").numUncertainCreatures() == 0)

        turn = 24
        print "\nTurn", turn
        ps.getLeaf("Gd02").split(2, "Gd04", turn)
        ps.getLeaf("Gd10").split(2, "Gd06", turn)
        ps.getLeaf("Gd02").revealCreatures(['Ranger'])
        ps.getLeaf("Gd02").addCreature("Troll")
        ps.getLeaf("Gd03").revealCreatures(['Cyclops', 'Cyclops', 'Cyclops'])
        ps.getLeaf("Gd03").addCreature("Behemoth")
        ps.getLeaf("Gd05").revealCreatures(['Gargoyle', 'Gargoyle'])
        ps.getLeaf("Gd05").addCreature("Cyclops")
        ps.getLeaf("Gd08").revealCreatures(['Lion'])
        ps.getLeaf("Gd08").addCreature("Centaur")
        ps.printLeaves()
        assert(ps.getLeaf("Gd02").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd05").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd06").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd07").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd08").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd09").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd10").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gd12").numUncertainCreatures() == 0)
        print "\ntest 5 ends"


    def testPredictSplits6(self):
        print "\ntest 6 begins"
        ps = PredictSplits("Gr", "Gr11", self.starting_creatures)
        ps.printLeaves()

        turn = 1
        print "\nTurn", turn
        ps.getLeaf("Gr11").split(4, "Gr02", turn)
        ps.getLeaf("Gr02").revealCreatures(['Titan'])
        ps.getLeaf("Gr02").revealCreatures(['Gargoyle', 'Gargoyle'])
        ps.getLeaf("Gr02").addCreature("Cyclops")
        ps.getLeaf("Gr11").revealCreatures(['Centaur'])
        ps.getLeaf("Gr11").addCreature("Centaur")
        ps.printLeaves()
        assert(ps.getLeaf("Gr02").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gr11").numUncertainCreatures() == 1)

        turn = 2
        print "\nTurn", turn
        ps.getLeaf("Gr02").revealCreatures(['Titan'])
        ps.getLeaf("Gr02").addCreature("Warlock")
        ps.getLeaf("Gr11").revealCreatures(['Centaur'])
        ps.getLeaf("Gr11").addCreature("Centaur")
        ps.printLeaves()
        assert(ps.getLeaf("Gr02").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gr11").numUncertainCreatures() == 1)

        turn = 3
        print "\nTurn", turn
        ps.getLeaf("Gr02").revealCreatures(['Cyclops'])
        ps.getLeaf("Gr02").addCreature("Cyclops")
        ps.getLeaf("Gr11").revealCreatures(['Centaur', 'Centaur'])
        ps.getLeaf("Gr11").addCreature("Lion")
        ps.printLeaves()
        assert(ps.getLeaf("Gr02").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gr11").numUncertainCreatures() == 1)

        turn = 4
        print "\nTurn", turn
        ps.getLeaf("Gr02").split(2, "Gr10", turn)
        ps.getLeaf("Gr11").split(3, "Gr03", turn)
        ps.getLeaf("Gr11").merge(ps.getLeaf("Gr03"), turn)
        ps.printLeaves()
        assert(ps.getLeaf("Gr02").numUncertainCreatures() == 5)
        assert(ps.getLeaf("Gr10").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gr11").numUncertainCreatures() == 1)

        turn = 5
        print "\nTurn", turn
        ps.getLeaf("Gr11").split(3, "Gr12", turn)
        ps.getLeaf("Gr02").revealCreatures(['Warlock'])
        ps.getLeaf("Gr02").addCreature("Warlock")
        ps.getLeaf("Gr10").revealCreatures(['Gargoyle', 'Gargoyle'])
        ps.getLeaf("Gr10").addCreature("Cyclops")
        ps.printLeaves()
        assert(ps.getLeaf("Gr02").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gr10").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gr11").numUncertainCreatures() == 4)
        assert(ps.getLeaf("Gr12").numUncertainCreatures() == 3)
        ps.getLeaf("Gr12").revealCreatures(['Centaur', 'Centaur', 'Centaur'])
        ps.printLeaves()
        ps.getLeaf("Gr12").addCreature("Warbear")
        ps.printLeaves()
        assert(ps.getLeaf("Gr02").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gr10").numUncertainCreatures() == 0)
        assert(ps.getLeaf("Gr11").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gr12").numUncertainCreatures() == 0)

        ps.getLeaf("Gr10").revealCreatures(['Cyclops', 'Gargoyle', 'Gargoyle'])
        ps.getLeaf("Gr10").removeCreature("Cyclops")
        ps.getLeaf("Gr10").revealCreatures(['Gargoyle', 'Gargoyle'])
        ps.getLeaf("Gr10").addCreature("Cyclops")
        ps.getLeaf("Gr10").removeCreature("Cyclops")
        ps.getLeaf("Gr10").removeCreature("Gargoyle")
        ps.getLeaf("Gr10").removeCreature("Gargoyle")
        ps.printLeaves()
        assert(not ps.getLeaf("Gr02").allCertain())
        assert(not ps.getLeaf("Gr11").allCertain())
        assert(ps.getLeaf("Gr12").allCertain())

        turn = 6
        print "\nTurn", turn
        ps.getLeaf("Gr02").revealCreatures(['Centaur'])
        ps.getLeaf("Gr02").addCreature("Centaur")
        ps.printLeaves()
        assert(ps.getLeaf("Gr02").allCertain())
        assert(ps.getLeaf("Gr11").allCertain())
        assert(ps.getLeaf("Gr12").allCertain())
        print "\ntest 6 ends"


    def testPredictSplits7(self):
        print "\ntest 7 begins"
        ps = PredictSplits("Gr", "Gr08", self.starting_creatures)
        ps.printLeaves()

        turn = 1
        print "Turn", turn
        ps.getLeaf("Gr08").split(4, "Gr04", turn)
        ps.getLeaf("Gr04").revealCreatures(["Titan"])
        ps.getLeaf("Gr04").revealCreatures(["Titan"])
        ps.getLeaf("Gr04").addCreature("Warlock")
        ps.getLeaf("Gr08").revealCreatures(["Centaur"])
        ps.getLeaf("Gr08").addCreature("Centaur")
        ps.printLeaves()
        assert(not ps.getLeaf("Gr04").allCertain())
        assert(not ps.getLeaf("Gr08").allCertain())

        turn = 2
        print "Turn", turn
        ps.getLeaf("Gr04").revealCreatures(["Gargoyle"])
        ps.getLeaf("Gr04").addCreature("Gargoyle")
        ps.printLeaves()
        assert(not ps.getLeaf("Gr04").allCertain())
        assert(not ps.getLeaf("Gr08").allCertain())

        turn = 3
        print "Turn", turn
        ps.getLeaf("Gr04").revealCreatures(["Gargoyle", "Gargoyle"])
        ps.getLeaf("Gr04").addCreature("Cyclops")
        ps.printLeaves()
        assert(not ps.getLeaf("Gr04").allCertain())
        assert(not ps.getLeaf("Gr08").allCertain())

        turn = 4
        print "Turn", turn
        ps.getLeaf("Gr04").split(2, "Gr06", turn)
        ps.getLeaf("Gr04").revealCreatures(["Ogre"])
        ps.getLeaf("Gr04").addCreature("Ogre")
        ps.getLeaf("Gr08").revealCreatures(["Centaur", "Centaur"])
        ps.getLeaf("Gr08").addCreature("Lion")
        ps.printLeaves()
        assert(not ps.getLeaf("Gr04").allCertain())
        assert(not ps.getLeaf("Gr06").allCertain())
        assert(not ps.getLeaf("Gr08").allCertain())

        turn = 5
        print "Turn", turn
        ps.getLeaf("Gr04").revealCreatures(["Cyclops"])
        ps.getLeaf("Gr04").addCreature("Cyclops")
        ps.getLeaf("Gr06").addCreature("Ogre")
        ps.getLeaf("Gr08").revealCreatures(["Lion"])
        ps.getLeaf("Gr08").addCreature("Lion")
        ps.printLeaves()
        assert(not ps.getLeaf("Gr04").allCertain())
        assert(not ps.getLeaf("Gr06").allCertain())
        assert(not ps.getLeaf("Gr08").allCertain())
        assert(ps.getLeaf("Gr06").numCertainCreatures() == 1)

        turn = 6
        print "Turn", turn
        ps.getLeaf("Gr04").split(2, "Gr07", turn)
        ps.getLeaf("Gr08").split(2, "Gr11", turn)
        ps.getLeaf("Gr04").revealCreatures(["Titan"])
        ps.getLeaf("Gr04").addCreature("Warlock")
        ps.getLeaf("Gr06").revealCreatures(["Ogre"])
        ps.getLeaf("Gr06").addCreature("Ogre")
        ps.getLeaf("Gr11").removeCreatures(["Centaur", "Centaur"])
        ps.printLeaves()
        assert(not ps.getLeaf("Gr04").allCertain())
        assert(not ps.getLeaf("Gr06").allCertain())
        assert(not ps.getLeaf("Gr07").allCertain())
        assert(not ps.getLeaf("Gr08").allCertain())

        turn = 7
        print "Turn", turn
        ps.getLeaf("Gr04").revealCreatures(["Cyclops"])
        ps.getLeaf("Gr04").addCreature("Cyclops")
        ps.getLeaf("Gr06").revealCreatures(["Ogre", "Ogre"])
        ps.getLeaf("Gr06").addCreature("Troll")
        ps.getLeaf("Gr07").revealCreatures(["Ogre"])
        ps.getLeaf("Gr07").addCreature("Ogre")
        ps.printLeaves()
        assert(not ps.getLeaf("Gr04").allCertain())
        assert(not ps.getLeaf("Gr06").allCertain())
        assert(not ps.getLeaf("Gr07").allCertain())
        assert(not ps.getLeaf("Gr08").allCertain())

        turn = 8
        print "Turn", turn
        ps.getLeaf("Gr04").split(2, "Gr12", turn)
        ps.printLeaves()

        ps.getLeaf("Gr07").revealCreatures(["Ogre", "Ogre", "Ogre"])
        ps.getLeaf("Gr07").addCreature("Minotaur")
        ps.getLeaf("Gr08").revealCreatures(["Gargoyle"])
        ps.getLeaf("Gr08").addCreature("Gargoyle")
        ps.getLeaf("Gr06").removeCreatures(["Troll", "Gargoyle", "Gargoyle",
          "Ogre", "Ogre"])
        ps.getLeaf("Gr12").removeCreatures(["Cyclops", "Ogre"])
        ps.printLeaves()
        assert(ps.getLeaf("Gr04").allCertain())
        assert(ps.getLeaf("Gr07").allCertain())
        assert(ps.getLeaf("Gr08").allCertain())

        turn = 9
        print "Turn", turn
        ps.getLeaf("Gr08").revealCreatures(["Gargoyle", "Gargoyle"])
        ps.getLeaf("Gr08").addCreature("Cyclops")
        ps.printLeaves()
        assert(ps.getLeaf("Gr04").allCertain())
        assert(ps.getLeaf("Gr07").allCertain())
        assert(ps.getLeaf("Gr08").allCertain())

        turn = 11
        print "Turn", turn
        ps.getLeaf("Gr08").split(2, "Gr01", turn)
        ps.getLeaf("Gr04").revealCreatures(["Titan"])
        ps.getLeaf("Gr04").addCreature("Warlock")
        ps.getLeaf("Gr08").revealCreatures(["Cyclops"])
        ps.getLeaf("Gr08").addCreature("Cyclops")
        ps.printLeaves()
        assert(not ps.getLeaf("Gr01").allCertain())
        assert(ps.getLeaf("Gr04").allCertain())
        assert(ps.getLeaf("Gr07").allCertain())
        assert(not ps.getLeaf("Gr08").allCertain())

        turn = 12
        print "Turn", turn
        ps.getLeaf("Gr04").revealCreatures(["Cyclops"])
        ps.getLeaf("Gr04").addCreature("Cyclops")
        ps.getLeaf("Gr08").revealCreatures(["Lion"])
        ps.getLeaf("Gr08").addCreature("Lion")
        ps.printLeaves()
        ps.getLeaf("Gr01").removeCreatures(["Gargoyle", "Gargoyle"])
        ps.printLeaves()
        assert(ps.getLeaf("Gr04").allCertain())
        assert(ps.getLeaf("Gr07").allCertain())
        assert(ps.getLeaf("Gr08").allCertain())

        turn = 13
        print "Turn", turn
        ps.getLeaf("Gr08").split(2, "Gr02", turn)
        ps.getLeaf("Gr07").revealCreatures(["Ogre", "Ogre"])
        ps.getLeaf("Gr07").addCreature("Troll")
        ps.printLeaves()
        assert(not ps.getLeaf("Gr02").allCertain())
        assert(ps.getLeaf("Gr04").allCertain())
        assert(ps.getLeaf("Gr07").allCertain())
        assert(not ps.getLeaf("Gr08").allCertain())

        turn = 14
        print "Turn", turn
        ps.getLeaf("Gr04").split(2, "Gr06", turn)
        ps.getLeaf("Gr04").revealCreatures(["Cyclops"])
        ps.getLeaf("Gr04").addCreature("Cyclops")
        ps.getLeaf("Gr06").revealCreatures(["Cyclops"])
        ps.getLeaf("Gr06").addCreature("Cyclops")
        ps.getLeaf("Gr08").revealCreatures(["Cyclops"])
        ps.getLeaf("Gr08").addCreature("Cyclops")
        ps.printLeaves()
        assert(not ps.getLeaf("Gr02").allCertain())
        assert(not ps.getLeaf("Gr04").allCertain())
        assert(not ps.getLeaf("Gr06").allCertain())
        assert(ps.getLeaf("Gr07").allCertain())
        assert(not ps.getLeaf("Gr08").allCertain())

        turn = 15
        print "Turn", turn
        ps.getLeaf("Gr06").removeCreatures(["Cyclops", "Cyclops", "Cyclops"])
        ps.getLeaf("Gr02").revealCreatures(["Centaur"])
        ps.getLeaf("Gr02").addCreature("Centaur")
        ps.printLeaves()
        assert(not ps.getLeaf("Gr02").allCertain())
        assert(ps.getLeaf("Gr04").allCertain())
        assert(ps.getLeaf("Gr07").allCertain())
        assert(not ps.getLeaf("Gr08").allCertain())

        turn = 16
        print "Turn", turn
        ps.getLeaf("Gr04").revealCreatures(["Cyclops"])
        ps.getLeaf("Gr04").addCreature("Cyclops")
        ps.getLeaf("Gr07").revealCreatures(["Ogre", "Ogre", "Ogre"])
        ps.getLeaf("Gr07").addCreature("Minotaur")
        ps.getLeaf("Gr08").revealCreatures(["Lion"])
        ps.getLeaf("Gr08").addCreature("Lion")
        ps.printLeaves()
        assert(not ps.getLeaf("Gr02").allCertain())
        assert(ps.getLeaf("Gr04").allCertain())
        assert(ps.getLeaf("Gr07").allCertain())
        assert(not ps.getLeaf("Gr08").allCertain())

        turn = 17
        print "Turn", turn
        ps.getLeaf("Gr02").removeCreatures(["Lion", "Centaur", "Centaur"])
        ps.printLeaves()
        assert(ps.getLeaf("Gr04").allCertain())
        assert(ps.getLeaf("Gr07").allCertain())
        assert(ps.getLeaf("Gr08").allCertain())
        ps.getLeaf("Gr08").split(2, "Gr12", turn)
        ps.getLeaf("Gr08").revealCreatures(["Cyclops", "Cyclops"])
        ps.getLeaf("Gr08").addCreature("Gorgon")
        ps.printLeaves()
        assert(ps.getLeaf("Gr04").allCertain())
        assert(ps.getLeaf("Gr07").allCertain())
        assert(not ps.getLeaf("Gr08").allCertain())
        assert(not ps.getLeaf("Gr12").allCertain())

        turn = 18
        print "Turn", turn
        ps.getLeaf("Gr12").removeCreatures(["Lion", "Lion"])
        assert(ps.getLeaf("Gr04").allCertain())
        assert(ps.getLeaf("Gr07").allCertain())
        assert(ps.getLeaf("Gr08").allCertain())
        ps.getLeaf("Gr04").split(2, "Gr12", turn)
        ps.getLeaf("Gr07").split(2, "Gr09", turn)
        ps.getLeaf("Gr08").revealCreatures(["Cyclops", "Cyclops"])
        ps.getLeaf("Gr08").addCreature("Gorgon")
        ps.printLeaves()
        assert(not ps.getLeaf("Gr04").allCertain())
        assert(not ps.getLeaf("Gr07").allCertain())
        assert(ps.getLeaf("Gr08").allCertain())
        assert(not ps.getLeaf("Gr09").allCertain())
        assert(not ps.getLeaf("Gr12").allCertain())

        turn = 19
        print "Turn", turn
        ps.getLeaf("Gr09").removeCreatures(["Ogre", "Ogre"])
        ps.getLeaf("Gr08").split(2, "Gr06", turn)
        ps.getLeaf("Gr07").revealCreatures(["Minotaur", "Minotaur"])
        ps.getLeaf("Gr07").addCreature("Unicorn")
        ps.getLeaf("Gr08").revealCreatures(["Cyclops", "Cyclops"])
        ps.getLeaf("Gr08").addCreature("Gorgon")
        ps.printLeaves()
        assert(not ps.getLeaf("Gr04").allCertain())
        assert(not ps.getLeaf("Gr06").allCertain())
        assert(ps.getLeaf("Gr07").allCertain())
        assert(not ps.getLeaf("Gr08").allCertain())
        assert(not ps.getLeaf("Gr12").allCertain())

        turn = 20
        print "Turn", turn
        ps.getLeaf("Gr06").removeCreatures(["Gorgon", "Lion"])
        ps.getLeaf("Gr08").revealCreatures(["Cyclops", "Cyclops", "Cyclops"])
        ps.getLeaf("Gr08").addCreature("Behemoth")
        ps.getLeaf("Gr12").revealCreatures(["Cyclops"])
        ps.getLeaf("Gr12").addCreature("Cyclops")
        ps.printLeaves()
        assert(not ps.getLeaf("Gr04").allCertain())
        assert(ps.getLeaf("Gr07").allCertain())
        assert(ps.getLeaf("Gr08").allCertain())
        assert(not ps.getLeaf("Gr12").allCertain())

        turn = 21
        print "Turn", turn
        ps.getLeaf("Gr04").revealCreatures(["Cyclops"])
        ps.getLeaf("Gr04").addCreature("Gargoyle")
        ps.getLeaf("Gr12").revealCreatures(["Cyclops", "Cyclops", "Cyclops"])
        ps.getLeaf("Gr12").addCreature("Behemoth")
        ps.printLeaves()
        assert(ps.getLeaf("Gr04").allCertain())
        assert(ps.getLeaf("Gr07").allCertain())
        assert(ps.getLeaf("Gr08").allCertain())
        assert(ps.getLeaf("Gr12").allCertain())
        print "\ntest 7 ends"


    def testPredictSplits8(self):
        print "\ntest 8 begins"
        ps = PredictSplits("Gd", "Gd03", self.starting_creatures)

        turn = 1
        print "\nTurn", turn
        ps.getLeaf("Gd03").split(4, "Gd04", turn)
        ps.getLeaf("Gd03").revealCreatures(['Ogre'])
        ps.getLeaf("Gd03").addCreature("Ogre")
        ps.getLeaf("Gd04").revealCreatures(['Gargoyle', 'Gargoyle'])
        ps.getLeaf("Gd04").addCreature("Cyclops")
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 2)
        ps.printLeaves()

        turn = 2
        print "\nTurn", turn
        ps.getLeaf("Gd03").revealCreatures(['Centaur'])
        ps.getLeaf("Gd03").addCreature("Centaur")
        ps.getLeaf("Gd04").revealCreatures(['Ogre'])
        ps.getLeaf("Gd04").addCreature("Ogre")
        ps.printLeaves()
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 1)
        ps.printLeaves()

        turn = 3
        print "\nTurn", turn
        ps.getLeaf("Gd04").revealCreatures(['Cyclops'])
        ps.getLeaf("Gd04").addCreature("Cyclops")
        ps.printLeaves()
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 1)

        turn = 4
        print "\nTurn", turn
        ps.getLeaf("Gd04").split(2, "Gd11", turn)
        ps.getLeaf("Gd04").revealCreatures(['Ogre', 'Ogre'])
        ps.getLeaf("Gd04").addCreature("Troll")
        ps.printLeaves()
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 3)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 2)

        turn = 5
        print "\nTurn", turn
        ps.getLeaf("Gd04").revealCreatures(['Cyclops'])
        ps.getLeaf("Gd04").addCreature("Cyclops")
        ps.getLeaf("Gd11").revealCreatures(['Gargoyle', 'Gargoyle'])
        ps.getLeaf("Gd11").addCreature("Cyclops")
        ps.printLeaves()
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 0)

        turn = 6
        print "\nTurn", turn
        ps.getLeaf("Gd04").split(2, "Gd10", turn)
        ps.printLeaves()
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 4)
        assert(ps.getLeaf("Gd10").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 0)

        turn = 7
        print "\nTurn", turn
        ps.getLeaf("Gd04").revealCreatures(['Cyclops', 'Cyclops', 'Cyclops'])
        ps.getLeaf("Gd04").addCreature("Behemoth")
        ps.printLeaves()
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd10").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 0)

        turn = 8
        print "\nTurn", turn
        ps.getLeaf("Gd03").revealCreatures(['Ogre', 'Ogre'])
        ps.getLeaf("Gd03").addCreature("Troll")
        ps.printLeaves()
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd10").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 0)

        turn = 9
        print "\nTurn", turn
        ps.getLeaf("Gd03").split(2, "Gd01", turn)
        ps.printLeaves()
        ps.getLeaf("Gd04").revealCreatures(['Troll'])
        ps.getLeaf("Gd04").addCreature("Troll")
        ps.getLeaf("Gd03").revealCreatures(['Troll'])
        ps.getLeaf("Gd03").addCreature("Troll")
        ps.getLeaf("Gd11").revealCreatures(['Cyclops'])
        ps.getLeaf("Gd11").addCreature("Cyclops")
        ps.printLeaves()
        assert(ps.getLeaf("Gd01").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 3)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd10").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 0)

        ps.getLeaf("Gd01").removeCreature("Centaur")
        ps.getLeaf("Gd01").removeCreature("Centaur")
        ps.printLeaves()
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd10").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 0)

        turn = 10
        print "\nTurn", turn
        ps.getLeaf("Gd04").split(2, "Gd08", turn)
        ps.getLeaf("Gd11").revealCreatures(['Cyclops'])
        ps.getLeaf("Gd11").addCreature("Cyclops")
        ps.printLeaves()
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 4)
        assert(ps.getLeaf("Gd08").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd10").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 0)

        ps.getLeaf("Gd10").removeCreature("Ogre")
        ps.getLeaf("Gd10").removeCreature("Ogre")
        ps.printLeaves()
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 4)
        assert(ps.getLeaf("Gd08").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 0)

        turn = 11
        print "\nTurn", turn
        ps.getLeaf("Gd03").revealCreatures(['Troll'])
        ps.getLeaf("Gd03").addCreature("Troll")
        ps.printLeaves()
        print "\ntest 8 ends"
        assert(ps.getLeaf("Gd03").numUncertainCreatures() == 1)
        assert(ps.getLeaf("Gd04").numUncertainCreatures() == 4)
        assert(ps.getLeaf("Gd08").numUncertainCreatures() == 2)
        assert(ps.getLeaf("Gd11").numUncertainCreatures() == 0)


    def testPredictSplits9(self):
        print "\ntest 9 begins"
        aps = AllPredictSplits()
        aps.append(PredictSplits("Gd", "Gd08", self.starting_creatures))
        aps.append(PredictSplits("Bu", "Bu02", self.starting_creatures))
        aps.append(PredictSplits("Gr", "Gr12", self.starting_creatures))
        aps.append(PredictSplits("Br", "Br06", self.starting_creatures))
        aps.append(PredictSplits("Bk", "Bk06", self.starting_creatures))
        aps.append(PredictSplits("Rd", "Rd06", self.starting_creatures))

        aps.check(); aps.printLeaves()
        turn = 1
        print "\nTurn", turn
        aps.getLeaf("Gd08").split(4, "Gd03", turn)
        aps.getLeaf("Gd03").revealCreatures(['Gargoyle', 'Gargoyle'])
        aps.getLeaf("Gd03").addCreature("Cyclops")
        aps.getLeaf("Gd08").revealCreatures(['Ogre'])
        aps.getLeaf("Gd08").addCreature("Ogre")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 2)
        assert(aps.getLeaf("Gd08").numUncertainCreatures() == 2)
        aps.getLeaf("Bu02").split(4, "Bu05", turn)
        aps.getLeaf("Bu02").revealCreatures(['Centaur'])
        aps.getLeaf("Bu02").addCreature("Centaur")
        aps.getLeaf("Bu05").revealCreatures(['Gargoyle', 'Gargoyle'])
        aps.getLeaf("Bu05").addCreature("Cyclops")
        assert(aps.getLeaf("Bu02").numUncertainCreatures() == 2)
        assert(aps.getLeaf("Bu05").numUncertainCreatures() == 2)
        aps.getLeaf("Gr12").split(4, "Gr08", turn)
        aps.getLeaf("Gr08").revealCreatures(['Titan'])
        aps.getLeaf("Gr08").revealCreatures(['Ogre', 'Ogre'])
        aps.getLeaf("Gr08").addCreature("Troll")
        aps.getLeaf("Gr12").revealCreatures(['Centaur'])
        aps.getLeaf("Gr12").addCreature("Centaur")
        assert(aps.getLeaf("Gr08").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gr12").numUncertainCreatures() == 1)
        aps.getLeaf("Br06").split(4, "Br01", turn)
        aps.getLeaf("Br01").revealCreatures(['Titan'])
        aps.getLeaf("Br01").revealCreatures(['Gargoyle', 'Gargoyle'])
        aps.getLeaf("Br01").addCreature("Cyclops")
        aps.getLeaf("Br06").revealCreatures(['Centaur'])
        aps.getLeaf("Br06").addCreature("Centaur")
        assert(aps.getLeaf("Br01").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Br06").numUncertainCreatures() == 1)
        aps.getLeaf("Bk06").split(4, "Bk10", turn)
        aps.getLeaf("Bk06").revealCreatures(['Ogre'])
        aps.getLeaf("Bk06").addCreature("Ogre")
        aps.getLeaf("Bk10").revealCreatures(['Gargoyle', 'Gargoyle'])
        aps.getLeaf("Bk10").addCreature("Cyclops")
        assert(aps.getLeaf("Bk06").numUncertainCreatures() == 2)
        assert(aps.getLeaf("Bk10").numUncertainCreatures() == 2)
        aps.getLeaf("Rd06").split(4, "Rd02", turn)
        aps.getLeaf("Rd02").revealCreatures(['Ogre'])
        aps.getLeaf("Rd02").addCreature("Ogre")
        assert(aps.getLeaf("Rd02").numUncertainCreatures() == 3)
        assert(aps.getLeaf("Rd06").numUncertainCreatures() == 4)

        aps.check(); aps.printLeaves()
        turn = 2
        print "\nTurn", turn
        aps.getLeaf("Gd03").revealCreatures(['Cyclops'])
        aps.getLeaf("Gd03").addCreature("Cyclops")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 2)
        assert(aps.getLeaf("Gd08").numUncertainCreatures() == 2)
        aps.getLeaf("Bu02").revealCreatures(['Centaur'])
        aps.getLeaf("Bu02").addCreature("Centaur")
        aps.getLeaf("Bu05").revealCreatures(['Cyclops'])
        aps.getLeaf("Bu05").addCreature("Cyclops")
        assert(aps.getLeaf("Bu02").numUncertainCreatures() == 2)
        assert(aps.getLeaf("Bu05").numUncertainCreatures() == 2)
        aps.getLeaf("Gr08").revealCreatures(['Troll'])
        aps.getLeaf("Gr08").addCreature("Troll")
        aps.getLeaf("Gr12").revealCreatures(['Gargoyle'])
        aps.getLeaf("Gr12").addCreature("Gargoyle")
        assert(aps.getLeaf("Gr08").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gr12").numUncertainCreatures() == 1)
        aps.getLeaf("Br06").revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf("Br06").addCreature("Lion")
        assert(aps.getLeaf("Br01").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Br06").numUncertainCreatures() == 1)
        aps.getLeaf("Bk06").revealCreatures(['Centaur'])
        aps.getLeaf("Bk06").addCreature("Centaur")
        aps.getLeaf("Bk10").revealCreatures(['Ogre'])
        aps.getLeaf("Bk10").addCreature("Ogre")
        assert(aps.getLeaf("Bk06").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Bk10").numUncertainCreatures() == 1)

        aps.check(); aps.printLeaves()
        turn = 3
        print "\nTurn", turn
        aps.getLeaf("Gd03").revealCreatures(['Cyclops'])
        aps.getLeaf("Gd03").addCreature("Cyclops")
        aps.getLeaf("Gd08").revealCreatures(['Ogre', 'Ogre', 'Ogre'])
        aps.getLeaf("Gd08").addCreature("Guardian")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd08").numUncertainCreatures() == 1)
        aps.getLeaf("Bu02").revealCreatures(['Ogre', 'Ogre'])
        aps.getLeaf("Bu02").addCreature("Troll")
        assert(aps.getLeaf("Bu02").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Bu05").numUncertainCreatures() == 1)
        aps.getLeaf("Gr08").revealCreatures(['Ogre'])
        aps.getLeaf("Gr08").addCreature("Ogre")
        aps.getLeaf("Gr12").revealCreatures(['Gargoyle', 'Gargoyle'])
        aps.getLeaf("Gr12").addCreature("Cyclops")
        assert(aps.getLeaf("Gr08").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gr12").numUncertainCreatures() == 1)
        aps.getLeaf("Br06").split(3, "Br12", turn)
        aps.getLeaf("Br01").revealCreatures(['Cyclops'])
        aps.getLeaf("Br01").addCreature("Cyclops")
        aps.getLeaf("Br06").revealCreatures(['Lion'])
        aps.getLeaf("Br06").addCreature("Lion")
        assert(aps.getLeaf("Br01").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Br06").numUncertainCreatures() == 2)
        assert(aps.getLeaf("Br12").numUncertainCreatures() == 3)
        aps.getLeaf("Bk06").revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf("Bk06").addCreature("Lion")
        aps.getLeaf("Bk10").revealCreatures(['Cyclops'])
        aps.getLeaf("Bk10").addCreature("Cyclops")
        assert(aps.getLeaf("Bk06").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Bk10").numUncertainCreatures() == 1)
        aps.getLeaf("Rd06").revealCreatures(['Gargoyle'])
        aps.getLeaf("Rd06").addCreature("Gargoyle")
        assert(aps.getLeaf("Rd02").numUncertainCreatures() == 3)
        assert(aps.getLeaf("Rd06").numUncertainCreatures() == 3)

        aps.check(); aps.printLeaves()
        turn = 4
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd12", turn)
        aps.getLeaf("Gd03").revealCreatures(['Centaur'])
        aps.getLeaf("Gd03").addCreature("Centaur")
        aps.getLeaf("Gd12").revealCreatures(['Gargoyle', 'Gargoyle'])
        aps.getLeaf("Gd12").addCreature("Cyclops")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd08").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 0)
        aps.getLeaf("Bu02").split(2, "Bu08", turn)
        aps.getLeaf("Bu02").merge(aps.getLeaf("Bu08"), turn)
        aps.getLeaf("Bu05").revealCreatures(['Cyclops'])
        aps.getLeaf("Bu05").addCreature("Cyclops")
        aps.getLeaf("Gr08").split(2, "Gr06", turn)
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr06"), turn)
        aps.getLeaf("Gr12").split(2, "Gr09", turn)
        aps.getLeaf("Gr09").revealCreatures(['Gargoyle', 'Gargoyle'])
        aps.getLeaf("Gr09").addCreature("Cyclops")
        aps.getLeaf("Br01").revealCreatures(['Ogre'])
        aps.getLeaf("Br01").addCreature("Ogre")
        aps.getLeaf("Br12").revealCreatures(['Centaur', 'Centaur', 'Centaur'])
        aps.getLeaf("Br12").addCreature("Warbear")
        aps.getLeaf("Bk06").split(2, "Bk04", turn)
        aps.getLeaf("Bk10").split(2, "Bk11", turn)
        aps.getLeaf("Bk06").revealCreatures(['Centaur'])
        aps.getLeaf("Bk06").addCreature("Centaur")
        aps.getLeaf("Bk11").removeCreature("Gargoyle")
        aps.getLeaf("Bk11").removeCreature("Gargoyle")
        aps.getLeaf("Rd06").revealCreatures(['Gargoyle', 'Gargoyle'])
        aps.getLeaf("Rd06").addCreature("Cyclops")

        aps.check(); aps.printLeaves()
        turn = 5
        print "\nTurn", turn
        aps.getLeaf("Gd03").revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf("Gd03").addCreature("Lion")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd08").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 0)
        aps.getLeaf("Bu02").split(2, "Bu01", turn)
        aps.getLeaf("Bu05").split(2, "Bu09", turn)
        aps.getLeaf("Bu09").revealCreatures(['Gargoyle', 'Gargoyle'])
        aps.getLeaf("Br12").revealCreatures(['Warbear', 'Centaur', 'Centaur', 
          'Centaur'])
        aps.getLeaf("Br12").removeCreature("Centaur")
        aps.getLeaf("Bu09").removeCreature("Gargoyle")
        aps.getLeaf("Bu09").removeCreature("Gargoyle")
        aps.getLeaf("Br12").revealCreatures(['Warbear', 'Centaur', 'Centaur'])
        aps.getLeaf("Br12").revealCreatures(['Warbear'])
        aps.getLeaf("Br12").addCreature("Warbear")
        aps.getLeaf("Bu05").revealCreatures(['Cyclops', 'Cyclops'])
        aps.getLeaf("Bu05").addCreature("Gorgon")
        aps.getLeaf("Gr08").split(2, "Gr01", turn)
        aps.getLeaf("Gr01").revealCreatures(['Gargoyle'])
        aps.getLeaf("Gr01").addCreature("Gargoyle")
        aps.getLeaf("Gr09").revealCreatures(['Cyclops'])
        aps.getLeaf("Gr09").addCreature("Cyclops")
        aps.getLeaf("Br01").split(2, "Br11", turn)
        aps.getLeaf("Br01").merge(aps.getLeaf("Br11"), turn)
        aps.getLeaf("Bk10").revealCreatures(['Titan'])
        aps.getLeaf("Bk10").addCreature("Warlock")

        aps.check(); aps.printLeaves()
        turn = 6
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd06", turn)
        aps.getLeaf("Gd03").revealCreatures(['Cyclops', 'Cyclops', 'Cyclops'])
        aps.getLeaf("Gd03").addCreature("Behemoth")
        aps.getLeaf("Gd06").revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf("Gd06").addCreature("Lion")
        aps.getLeaf("Gd12").revealCreatures(['Cyclops'])
        aps.getLeaf("Gd12").addCreature("Cyclops")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd08").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 0)
        aps.getLeaf("Bu02").revealCreatures(['Troll'])
        aps.getLeaf("Bu02").addCreature("Troll")
        aps.getLeaf("Bu05").revealCreatures(['Titan'])
        aps.getLeaf("Bu05").addCreature("Warlock")
        aps.getLeaf("Gr01").revealCreatures(['Ogre'])
        aps.getLeaf("Gr01").addCreature("Ogre")
        aps.getLeaf("Gr09").revealCreatures(['Cyclops'])
        aps.getLeaf("Gr09").addCreature("Cyclops")
        aps.getLeaf("Gr12").revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf("Gr12").addCreature("Lion")
        aps.getLeaf("Br01").split(2, "Br09", turn)
        aps.getLeaf("Br01").merge(aps.getLeaf("Br09"), turn)
        aps.getLeaf("Br06").revealCreatures(['Lion'])
        aps.getLeaf("Br06").addCreature("Lion")
        aps.getLeaf("Br12").revealCreatures(['Warbear', 'Warbear'])
        aps.getLeaf("Br12").addCreature("Unicorn")
        aps.getLeaf("Bk06").revealCreatures(['Ogre', 'Ogre'])
        aps.getLeaf("Bk06").addCreature("Troll")
        aps.getLeaf("Bk10").revealCreatures(['Cyclops'])
        aps.getLeaf("Bk10").addCreature("Cyclops")
        aps.getLeaf("Rd06").revealCreatures(['Cyclops'])
        aps.getLeaf("Rd06").addCreature("Cyclops")

        aps.check(); aps.printLeaves()
        turn = 7
        print "\nTurn", turn
        aps.getLeaf("Gd03").revealCreatures(['Lion'])
        aps.getLeaf("Gd03").addCreature("Lion")
        aps.getLeaf("Gd08").revealCreatures(['Ogre', 'Ogre'])
        aps.getLeaf("Gd08").addCreature("Troll")
        aps.getLeaf("Gd12").revealCreatures(['Cyclops'])
        aps.getLeaf("Gd12").addCreature("Cyclops")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd08").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 0)
        aps.getLeaf("Bu05").split(2, "Bu12", turn)
        aps.getLeaf("Bu05").revealCreatures(['Titan'])
        aps.getLeaf("Bu02").revealCreatures(['Troll'])
        aps.getLeaf("Bu02").addCreature("Troll")
        aps.getLeaf("Bu05").revealCreatures(['Warlock'])
        aps.getLeaf("Bu05").addCreature("Warlock")
        aps.getLeaf("Gr12").split(3, "Gr02", turn)
        aps.getLeaf("Gr12").merge(aps.getLeaf("Gr02"), turn)
        aps.getLeaf("Gr01").revealCreatures(['Gargoyle', 'Gargoyle'])
        aps.getLeaf("Gr01").addCreature("Cyclops")
        aps.getLeaf("Br01").split(2, "Br08", turn)
        aps.getLeaf("Br01").merge(aps.getLeaf("Br08"), turn)
        aps.getLeaf("Br06").revealCreatures(['Ogre'])
        aps.getLeaf("Br06").addCreature("Ogre")
        aps.getLeaf("Br12").revealCreatures(['Unicorn'])
        aps.getLeaf("Br12").addCreature("Unicorn")
        aps.getLeaf("Bk06").split(2, "Bk12", turn)
        aps.getLeaf("Bk04").revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf("Bk04").addCreature("Lion")
        aps.getLeaf("Bk06").revealCreatures(['Lion'])
        aps.getLeaf("Bk06").addCreature("Lion")

        aps.check(); aps.printLeaves()
        turn = 8
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd04", turn)
        aps.getLeaf("Gd08").split(2, "Gd05", turn)
        aps.getLeaf("Gd03").revealCreatures(['Cyclops', 'Cyclops'])
        aps.getLeaf("Gd03").addCreature("Gorgon")
        aps.getLeaf("Gd05").revealCreatures(['Centaur'])
        aps.getLeaf("Gd05").addCreature("Centaur")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 3)
        assert(aps.getLeaf("Gd04").numUncertainCreatures() == 2)
        assert(aps.getLeaf("Gd05").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd08").numUncertainCreatures() == 3)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 0)
        aps.getLeaf("Bu02").split(2, "Bu07", turn)
        aps.getLeaf("Bu07").revealCreatures(['Centaur'])
        aps.getLeaf("Bu07").addCreature("Centaur")
        aps.getLeaf("Gr12").split(3, "Gr03", turn)
        aps.getLeaf("Gr01").revealCreatures(['Cyclops'])
        aps.getLeaf("Gr01").addCreature("Cyclops")
        aps.getLeaf("Br01").split(2, "Br09", turn)
        aps.getLeaf("Bk06").revealCreatures(['Lion'])
        aps.getLeaf("Bk06").addCreature("Lion")
        aps.getLeaf("Bk12").addCreature("Centaur")
        aps.getLeaf("Rd06").revealCreatures(['Titan', 'Cyclops', 'Cyclops', 
          'Gargoyle', 'Gargoyle', 'Centaur', 'Centaur'])
        aps.getLeaf("Gd08").revealCreatures(['Angel', 'Guardian', 'Troll', 
          'Ogre', 'Ogre'])
        aps.getLeaf("Gd08").removeCreature("Ogre")
        aps.getLeaf("Rd06").removeCreature("Gargoyle")
        aps.getLeaf("Rd02").removeCreature("Angel")
        aps.getLeaf("Rd06").addCreature("Angel")
        aps.getLeaf("Rd06").removeCreature("Centaur")
        aps.getLeaf("Gd08").removeCreature("Angel")
        aps.getLeaf("Gd08").removeCreature("Troll")
        aps.getLeaf("Rd06").removeCreature("Angel")
        aps.getLeaf("Gd08").removeCreature("Ogre")
        aps.getLeaf("Gd08").removeCreature("Guardian")
        aps.getLeaf("Rd06").revealCreatures(['Titan', 'Cyclops', 'Cyclops', 
          'Gargoyle', 'Centaur'])
        aps.getLeaf("Rd06").addCreature("Angel")

        aps.check(); aps.printLeaves()
        turn = 9
        print "\nTurn", turn
        aps.getLeaf("Gd05").revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf("Gd05").addCreature("Lion")
        aps.getLeaf("Gd06").revealCreatures(['Centaur'])
        aps.getLeaf("Gd06").addCreature("Centaur")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 3)
        assert(aps.getLeaf("Gd04").numUncertainCreatures() == 2)
        assert(aps.getLeaf("Gd05").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 0)
        aps.getLeaf("Bu01").revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf("Bu01").addCreature("Lion")
        aps.getLeaf("Bu02").revealCreatures(['Troll', 'Troll', 'Troll'])
        aps.getLeaf("Bu02").addCreature("Guardian")
        aps.getLeaf("Bu05").revealCreatures(['Cyclops'])
        aps.getLeaf("Bu05").addCreature("Cyclops")
        aps.getLeaf("Bu12").revealCreatures(['Cyclops'])
        aps.getLeaf("Bu12").addCreature("Cyclops")
        aps.getLeaf("Gr01").split(2, "Gr04", turn)
        aps.getLeaf("Bu01").removeCreature("Lion")
        aps.getLeaf("Bu01").removeCreature("Centaur")
        aps.getLeaf("Bu01").removeCreature("Centaur")
        aps.getLeaf("Gr03").revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf("Gr03").addCreature("Lion")
        aps.getLeaf("Gr04").revealCreatures(['Gargoyle', 'Gargoyle'])
        aps.getLeaf("Gr04").addCreature("Cyclops")
        aps.getLeaf("Gr08").revealCreatures(['Ogre'])
        aps.getLeaf("Gr08").addCreature("Ogre")
        aps.getLeaf("Gr12").revealCreatures(['Lion'])
        aps.getLeaf("Gr12").addCreature("Lion")
        aps.getLeaf("Br01").revealCreatures(['Cyclops'])
        aps.getLeaf("Br01").addCreature("Cyclops")
        aps.getLeaf("Bk10").split(2, "Bk11", turn)
        aps.getLeaf("Bk06").revealCreatures(['Angel', 'Troll', 'Lion', 'Lion', 
          'Lion', 'Ogre', 'Ogre'])
        aps.getLeaf("Br06").revealCreatures(['Angel', 'Lion', 'Lion', 'Lion', 
          'Ogre', 'Ogre'])
        aps.getLeaf("Br06").removeCreature("Lion")
        aps.getLeaf("Br06").removeCreature("Lion")
        aps.getLeaf("Bk06").removeCreature("Angel")
        aps.getLeaf("Br06").removeCreature("Lion")
        aps.getLeaf("Bk06").removeCreature("Ogre")
        aps.getLeaf("Br06").revealCreatures(['Ogre'])
        aps.getLeaf("Br06").addCreature("Ogre")
        aps.getLeaf("Br06").removeCreature("Angel")
        aps.getLeaf("Bk06").removeCreature("Lion")
        aps.getLeaf("Br06").removeCreature("Ogre")
        aps.getLeaf("Bk06").removeCreature("Lion")
        aps.getLeaf("Br06").removeCreature("Ogre")
        aps.getLeaf("Bk06").removeCreature("Lion")
        aps.getLeaf("Br06").removeCreature("Ogre")
        aps.getLeaf("Bk06").removeCreature("Ogre")
        aps.getLeaf("Bk06").revealCreatures(['Troll'])
        aps.getLeaf("Bk06").addCreature("Angel")
        aps.getLeaf("Gd05").removeCreature("Lion")
        aps.getLeaf("Gd05").removeCreature("Centaur")
        aps.getLeaf("Gd05").removeCreature("Centaur")
        aps.getLeaf("Gd05").removeCreature("Ogre")
        aps.getLeaf("Bk11").removeCreature("Ogre")
        aps.getLeaf("Bk11").removeCreature("Ogre")
        aps.getLeaf("Rd06").revealCreatures(['Titan'])
        aps.getLeaf("Rd06").addCreature("Warlock")
        aps.getLeaf("Rd02").revealCreatures(['Gargoyle'])
        aps.getLeaf("Rd02").addCreature("Gargoyle")

        aps.check(); aps.printLeaves()
        turn = 10
        print "\nTurn", turn
        aps.getLeaf("Gd03").revealCreatures(['Cyclops', 'Cyclops'])
        aps.getLeaf("Gd03").addCreature("Gorgon")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 3)
        assert(aps.getLeaf("Gd04").numUncertainCreatures() == 2)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 0)
        aps.getLeaf("Bu05").split(2, "Bu10", turn)
        aps.getLeaf("Rd02").removeCreature("Gargoyle")
        aps.getLeaf("Rd02").removeCreature("Gargoyle")
        aps.getLeaf("Rd02").removeCreature("Ogre")
        aps.getLeaf("Rd02").removeCreature("Ogre")
        aps.getLeaf("Rd02").removeCreature("Ogre")
        aps.getLeaf("Bu07").revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf("Bu07").addCreature("Lion")
        aps.getLeaf("Gr01").revealCreatures(['Ogre'])
        aps.getLeaf("Gr01").addCreature("Ogre")
        aps.getLeaf("Gr03").revealCreatures(['Lion'])
        aps.getLeaf("Gr03").addCreature("Lion")
        aps.getLeaf("Gr08").revealCreatures(['Troll'])
        aps.getLeaf("Gr08").addCreature("Troll")
        aps.getLeaf("Br01").revealCreatures(['Ogre', 'Ogre'])
        aps.getLeaf("Br01").addCreature("Troll")
        aps.getLeaf("Br12").revealCreatures(['Unicorn'])
        aps.getLeaf("Br12").addCreature("Unicorn")
        aps.getLeaf("Br09").removeCreature("Gargoyle")
        aps.getLeaf("Br09").removeCreature("Gargoyle")
        aps.getLeaf("Bk10").revealCreatures(['Cyclops', 'Cyclops', 'Cyclops'])
        aps.getLeaf("Bk10").addCreature("Behemoth")
        aps.getLeaf("Bk12").revealCreatures(['Centaur', 'Centaur', 'Centaur'])
        aps.getLeaf("Bk12").addCreature("Warbear")
        aps.getLeaf("Rd06").split(2, "Rd09", turn)
        aps.getLeaf("Rd09").revealCreatures(['Centaur'])
        aps.getLeaf("Rd09").addCreature("Centaur")

        aps.check(); aps.printLeaves()
        turn = 11
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd07", turn)
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd07"), turn)
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 3)
        assert(aps.getLeaf("Gd04").numUncertainCreatures() == 2)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 0)
        aps.getLeaf("Bu02").split(2, "Bu04", turn)
        aps.getLeaf("Bu02").revealCreatures(['Troll', 'Troll'])
        aps.getLeaf("Bu02").addCreature("Ranger")
        aps.getLeaf("Bu05").revealCreatures(['Warlock'])
        aps.getLeaf("Bu05").addCreature("Warlock")
        aps.getLeaf("Bu07").revealCreatures(['Lion'])
        aps.getLeaf("Bu07").addCreature("Lion")
        aps.getLeaf("Bu12").revealCreatures(['Cyclops', 'Cyclops', 'Cyclops'])
        aps.getLeaf("Bu12").addCreature("Guardian")
        aps.getLeaf("Gr08").split(2, "Gr02", turn)
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr02"), turn)
        aps.getLeaf("Gr01").revealCreatures(['Ogre', 'Ogre'])
        aps.getLeaf("Gr01").addCreature("Troll")
        aps.getLeaf("Br01").split(2, "Br03", turn)
        aps.getLeaf("Br01").merge(aps.getLeaf("Br03"), turn)
        aps.getLeaf("Br12").split(2, "Br07", turn)
        aps.getLeaf("Br12").merge(aps.getLeaf("Br07"), turn)
        aps.getLeaf("Gd04").removeCreature("Lion")
        aps.getLeaf("Gd04").removeCreature("Lion")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 0)
        aps.getLeaf("Bu04").removeCreature("Troll")
        aps.getLeaf("Bu04").removeCreature("Ogre")
        aps.getLeaf("Bk10").revealCreatures(['Cyclops', 'Cyclops'])
        aps.getLeaf("Bk10").addCreature("Gorgon")
        aps.getLeaf("Rd06").revealCreatures(['Cyclops'])
        aps.getLeaf("Rd06").addCreature("Cyclops")

        aps.check(); aps.printLeaves()
        turn = 12
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd08", turn)
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd08"), turn)
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 0)
        aps.getLeaf("Bu05").revealCreatures(['Gorgon'])
        aps.getLeaf("Bu05").addCreature("Gorgon")
        aps.getLeaf("Bu07").revealCreatures(['Ogre'])
        aps.getLeaf("Bu07").addCreature("Ogre")
        aps.getLeaf("Bu12").revealCreatures(['Cyclops', 'Cyclops'])
        aps.getLeaf("Bu12").addCreature("Gorgon")
        aps.getLeaf("Gr08").split(2, "Gr10", turn)
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr10"), turn)
        aps.getLeaf("Gr01").revealCreatures(['Cyclops'])
        aps.getLeaf("Gr01").addCreature("Cyclops")
        aps.getLeaf("Br01").split(2, "Br02", turn)
        aps.getLeaf("Br01").merge(aps.getLeaf("Br02"), turn)
        aps.getLeaf("Br12").split(2, "Br06", turn)
        aps.getLeaf("Br12").merge(aps.getLeaf("Br06"), turn)
        aps.getLeaf("Gd12").removeCreature("Cyclops")
        aps.getLeaf("Gd12").removeCreature("Cyclops")
        aps.getLeaf("Gd12").removeCreature("Cyclops")
        aps.getLeaf("Gd12").removeCreature("Gargoyle")
        aps.getLeaf("Gd12").removeCreature("Gargoyle")
        aps.getLeaf("Bk10").revealCreatures(['Titan', 'Behemoth', 'Warlock', 
          'Gorgon', 'Cyclops', 'Cyclops', 'Cyclops'])
        aps.getLeaf("Bu02").revealCreatures(['Angel', 'Guardian', 'Ranger', 
          'Troll', 'Troll'])
        aps.getLeaf("Bk10").removeCreature("Warlock")
        aps.getLeaf("Bu02").removeCreature("Angel")
        aps.getLeaf("Bk10").removeCreature("Behemoth")
        aps.getLeaf("Bu02").removeCreature("Ranger")
        aps.getLeaf("Bk10").removeCreature("Cyclops")
        aps.getLeaf("Bk06").removeCreature("Angel")
        aps.getLeaf("Bk10").addCreature("Angel")
        aps.getLeaf("Bu02").removeCreature("Troll")
        aps.getLeaf("Bu02").removeCreature("Troll")
        aps.getLeaf("Bk10").removeCreature("Angel")
        aps.getLeaf("Bu02").removeCreature("Guardian")
        aps.getLeaf("Bk10").revealCreatures(['Titan', 'Gorgon', 'Cyclops', 
          'Cyclops'])
        aps.getLeaf("Bk10").addCreature("Angel")
        aps.getLeaf("Bk06").revealCreatures(['Troll'])
        aps.getLeaf("Bk06").addCreature("Troll")
        aps.getLeaf("Rd06").revealCreatures(['Cyclops', 'Cyclops', 'Cyclops'])
        aps.getLeaf("Rd06").addCreature("Behemoth")

        aps.check(); aps.printLeaves()
        turn = 13
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd09", turn)
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd09"), turn)
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 0)
        aps.getLeaf("Bu05").split(2, "Bu02", turn)
        aps.getLeaf("Bu02").revealCreatures(['Centaur'])
        aps.getLeaf("Bu02").addCreature("Centaur")
        aps.getLeaf("Bu12").revealCreatures(['Cyclops', 'Cyclops', 'Cyclops'])
        aps.getLeaf("Bu12").addCreature("Behemoth")
        aps.getLeaf("Gr01").split(2, "Gr07", turn)
        aps.getLeaf("Gr01").merge(aps.getLeaf("Gr07"), turn)
        aps.getLeaf("Gr08").split(2, "Gr05", turn)
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr05"), turn)
        aps.getLeaf("Rd09").removeCreature("Gargoyle")
        aps.getLeaf("Rd09").removeCreature("Centaur")
        aps.getLeaf("Rd09").removeCreature("Centaur")
        aps.getLeaf("Br01").split(2, "Br07", turn)
        aps.getLeaf("Br01").merge(aps.getLeaf("Br07"), turn)
        aps.getLeaf("Br12").split(2, "Br04", turn)
        aps.getLeaf("Br12").merge(aps.getLeaf("Br04"), turn)
        aps.getLeaf("Bk12").revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf("Bk12").addCreature("Lion")

        aps.check(); aps.printLeaves()
        turn = 14
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd04", turn)
        aps.getLeaf("Gd03").revealCreatures(['Titan'])
        aps.getLeaf("Gd03").addCreature("Warlock")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 3)
        assert(aps.getLeaf("Gd04").numUncertainCreatures() == 2)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 0)
        aps.getLeaf("Bu05").revealCreatures(['Warlock'])
        aps.getLeaf("Bu05").addCreature("Warlock")
        aps.getLeaf("Bu07").addCreature("Ogre")
        aps.getLeaf("Bu10").revealCreatures(['Cyclops', 'Cyclops'])
        aps.getLeaf("Bu10").addCreature("Gorgon")
        aps.getLeaf("Bu12").revealCreatures(['Cyclops', 'Cyclops'])
        aps.getLeaf("Bu12").addCreature("Gorgon")
        aps.getLeaf("Gr01").split(2, "Gr05", turn)
        aps.getLeaf("Gr08").split(2, "Gr06", turn)
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr06"), turn)
        aps.getLeaf("Br01").split(2, "Br05", turn)
        aps.getLeaf("Br12").split(2, "Br04", turn)
        aps.getLeaf("Br01").revealCreatures(['Cyclops', 'Cyclops', 'Cyclops'])
        aps.getLeaf("Br01").addCreature("Behemoth")
        aps.getLeaf("Bk06").revealCreatures(['Troll', 'Troll'])
        aps.getLeaf("Bk06").addCreature("Ranger")

        aps.check(); aps.printLeaves()
        turn = 15
        print "\nTurn", turn
        aps.getLeaf("Gd03").revealCreatures(['Gorgon'])
        aps.getLeaf("Gd03").addCreature("Gorgon")
        aps.getLeaf("Gd06").revealCreatures(['Lion'])
        aps.getLeaf("Gd06").addCreature("Lion")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 2)
        assert(aps.getLeaf("Gd04").numUncertainCreatures() == 2)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 0)
        aps.getLeaf("Bu07").split(2, "Bu09", turn)
        aps.getLeaf("Bu12").split(2, "Bu06", turn)
        aps.getLeaf("Bu12").merge(aps.getLeaf("Bu06"), turn)
        aps.getLeaf("Bu02").addCreature("Gargoyle")
        aps.getLeaf("Bu07").revealCreatures(['Ogre', 'Ogre'])
        aps.getLeaf("Bu07").addCreature("Troll")
        aps.getLeaf("Bu09").revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf("Bu09").addCreature("Lion")
        aps.getLeaf("Bu10").addCreature("Gargoyle")
        aps.getLeaf("Gr08").split(2, "Gr06", turn)
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr06"), turn)
        aps.getLeaf("Gr03").revealCreatures(['Lion'])
        aps.getLeaf("Gr03").addCreature("Lion")
        aps.getLeaf("Bk12").removeCreature("Warbear")
        aps.getLeaf("Bk12").removeCreature("Lion")
        aps.getLeaf("Bk12").removeCreature("Centaur")
        aps.getLeaf("Bk12").removeCreature("Centaur")
        aps.getLeaf("Bk12").removeCreature("Centaur")
        aps.getLeaf("Br01").addCreature("Angel")
        aps.getLeaf("Br12").revealCreatures(['Unicorn'])
        aps.getLeaf("Br12").addCreature("Unicorn")
        aps.getLeaf("Bk04").revealCreatures(['Lion'])
        aps.getLeaf("Bk04").addCreature("Lion")
        aps.getLeaf("Bk06").revealCreatures(['Troll'])
        aps.getLeaf("Bk06").addCreature("Troll")
        aps.getLeaf("Br05").removeCreature("Ogre")
        aps.getLeaf("Br05").removeCreature("Ogre")

        aps.check(); aps.printLeaves()
        turn = 16
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd12", turn)
        aps.getLeaf("Gd06").revealCreatures(['Lion', 'Lion'])
        aps.getLeaf("Gd06").addCreature("Minotaur")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 5)
        assert(aps.getLeaf("Gd04").numUncertainCreatures() == 2)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 2)
        aps.getLeaf("Bu12").split(2, "Bu01", turn)
        aps.getLeaf("Bu12").merge(aps.getLeaf("Bu01"), turn)
        aps.getLeaf("Bu05").revealCreatures(['Gorgon'])
        aps.getLeaf("Bu05").addCreature("Gorgon")
        aps.getLeaf("Gr08").split(2, "Gr11", turn)
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr11"), turn)
        aps.getLeaf("Gr05").revealCreatures(['Ogre', 'Ogre'])
        aps.getLeaf("Gr05").addCreature("Troll")
        aps.getLeaf("Gr09").revealCreatures(['Cyclops', 'Cyclops'])
        aps.getLeaf("Gr09").addCreature("Gorgon")
        aps.getLeaf("Br01").split(2, "Br03", turn)
        aps.getLeaf("Br01").merge(aps.getLeaf("Br03"), turn)
        aps.getLeaf("Bk04").revealCreatures(['Lion', 'Lion'])
        aps.getLeaf("Bk04").addCreature("Ranger")
        aps.getLeaf("Bk06").revealCreatures(['Ranger'])
        aps.getLeaf("Bk06").addCreature("Ranger")
        aps.getLeaf("Bk10").revealCreatures(['Cyclops', 'Cyclops'])
        aps.getLeaf("Bk10").addCreature("Gorgon")
        aps.getLeaf("Rd06").split(2, "Rd11", turn)

        aps.check(); aps.printLeaves()
        turn = 17
        print "\nTurn", turn
        aps.getLeaf("Gd03").revealCreatures(['Behemoth'])
        aps.getLeaf("Gd03").addCreature("Behemoth")
        aps.getLeaf("Gd12").revealCreatures(['Gorgon'])
        aps.getLeaf("Gd12").addCreature("Gorgon")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 4)
        assert(aps.getLeaf("Gd04").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 1)
        aps.getLeaf("Bu05").split(2, "Bu08", turn)
        aps.getLeaf("Bu12").split(2, "Bu01", turn)
        aps.getLeaf("Bu12").merge(aps.getLeaf("Bu01"), turn)
        aps.getLeaf("Bu09").revealCreatures(['Lion'])
        aps.getLeaf("Bu09").addCreature("Lion")
        aps.getLeaf("Gr08").split(2, "Gr06", turn)
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr06"), turn)
        aps.getLeaf("Gr09").revealCreatures(['Gorgon', 'Cyclops', 'Cyclops', 
          'Cyclops', 'Gargoyle', 'Gargoyle'])
        aps.getLeaf("Bu07").revealCreatures(['Troll', 'Lion', 'Lion', 'Ogre', 
          'Ogre', 'Ogre'])
        aps.getLeaf("Bu07").removeCreature("Troll")
        aps.getLeaf("Gr09").removeCreature("Gorgon")
        aps.getLeaf("Gr09").removeCreature("Gargoyle")
        aps.getLeaf("Bu07").removeCreature("Ogre")
        aps.getLeaf("Gr12").removeCreature("Angel")
        aps.getLeaf("Gr09").addCreature("Angel")
        aps.getLeaf("Bu07").removeCreature("Lion")
        aps.getLeaf("Bu07").revealCreatures(['Ogre', 'Ogre'])
        aps.getLeaf("Bu07").addCreature("Troll")
        aps.getLeaf("Bu07").removeCreature("Lion")
        aps.getLeaf("Gr09").removeCreature("Cyclops")
        aps.getLeaf("Gr09").removeCreature("Gargoyle")
        aps.getLeaf("Bu07").removeCreature("Ogre")
        aps.getLeaf("Bu07").removeCreature("Ogre")
        aps.getLeaf("Gr09").removeCreature("Cyclops")
        aps.getLeaf("Bu07").removeCreature("Troll")
        aps.getLeaf("Gr09").revealCreatures(['Angel', 'Cyclops'])
        aps.getLeaf("Gr09").addCreature("Angel")
        aps.getLeaf("Br01").split(2, "Br05", turn)
        aps.getLeaf("Br01").merge(aps.getLeaf("Br05"), turn)
        aps.getLeaf("Br04").revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf("Br04").addCreature("Lion")
        aps.getLeaf("Rd06").revealCreatures(['Titan', 'Angel', 'Behemoth', 
          'Cyclops', 'Cyclops'])
        aps.getLeaf("Gr03").revealCreatures(['Lion', 'Lion', 'Lion', 
          'Centaur', 'Centaur', 'Centaur'])
        aps.getLeaf("Gr03").removeCreature("Centaur")
        aps.getLeaf("Gr03").removeCreature("Centaur")
        aps.getLeaf("Gr03").removeCreature("Lion")
        aps.getLeaf("Gr03").removeCreature("Lion")
        aps.getLeaf("Gr03").removeCreature("Lion")
        aps.getLeaf("Gr03").removeCreature("Centaur")
        aps.getLeaf("Rd06").revealCreatures(['Titan', 'Angel', 'Behemoth', 
          'Cyclops', 'Cyclops'])
        aps.getLeaf("Rd06").addCreature("Angel")
        aps.getLeaf("Rd11").revealCreatures(['Warlock', 'Cyclops'])
        aps.getLeaf("Bu09").revealCreatures(['Lion', 'Lion', 'Centaur', 
          'Centaur'])
        aps.getLeaf("Bu09").removeCreature("Lion")
        aps.getLeaf("Bu09").removeCreature("Centaur")
        aps.getLeaf("Rd11").removeCreature("Cyclops")
        aps.getLeaf("Bu09").revealCreatures(['Lion'])
        aps.getLeaf("Bu09").addCreature("Lion")
        aps.getLeaf("Rd11").removeCreature("Warlock")
        aps.getLeaf("Bu09").revealCreatures(['Lion', 'Lion', 'Centaur'])

        aps.check(); aps.printLeaves()
        turn = 18
        print "\nTurn", turn
        aps.getLeaf("Gd06").split(2, "Gd10", turn)
        aps.getLeaf("Gd06").merge(aps.getLeaf("Gd10"), turn)
        aps.getLeaf("Gd04").revealCreatures(['Cyclops', 'Cyclops'])
        aps.getLeaf("Gd04").addCreature("Gorgon")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 3)
        assert(aps.getLeaf("Gd04").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 1)
        aps.getLeaf("Bu12").split(2, "Bu04", turn)
        aps.getLeaf("Bu04").revealCreatures(['Cyclops', 'Cyclops'])
        aps.getLeaf("Bu04").addCreature("Gorgon")
        aps.getLeaf("Gr08").split(2, "Gr06", turn)
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr06"), turn)
        aps.getLeaf("Gr01").revealCreatures(['Troll'])
        aps.getLeaf("Gr01").addCreature("Troll")
        aps.getLeaf("Gr04").revealCreatures(['Cyclops'])
        aps.getLeaf("Gr04").addCreature("Gargoyle")
        aps.getLeaf("Gr05").addCreature("Gargoyle")
        aps.getLeaf("Gr09").addCreature("Gargoyle")
        aps.getLeaf("Br01").split(2, "Br06", turn)
        aps.getLeaf("Br01").revealCreatures(['Cyclops', 'Cyclops'])
        aps.getLeaf("Br01").addCreature("Gorgon")
        aps.getLeaf("Bk10").revealCreatures(['Titan', 'Angel', 'Gorgon', 
          'Gorgon', 'Cyclops', 'Cyclops'])
        aps.getLeaf("Gr05").revealCreatures(['Troll', 'Gargoyle', 'Ogre', 
          'Ogre'])
        aps.getLeaf("Gr05").removeCreature("Gargoyle")
        aps.getLeaf("Gr05").removeCreature("Ogre")
        aps.getLeaf("Bk10").removeCreature("Angel")
        aps.getLeaf("Gr05").removeCreature("Troll")
        aps.getLeaf("Bk10").removeCreature("Gorgon")
        aps.getLeaf("Gr05").removeCreature("Ogre")
        aps.getLeaf("Bk10").revealCreatures(['Titan', 'Gorgon', 'Cyclops', 
          'Cyclops'])
        aps.getLeaf("Bk10").addCreature("Angel")
        aps.getLeaf("Bk06").revealCreatures(['Ranger', 'Ranger', 'Troll', 
          'Troll', 'Troll'])
        aps.getLeaf("Gr12").revealCreatures(['Cyclops', 'Lion', 'Lion'])
        aps.getLeaf("Gr12").removeCreature("Cyclops")
        aps.getLeaf("Gr12").removeCreature("Lion")
        aps.getLeaf("Bk06").removeCreature("Ranger")
        aps.getLeaf("Bk10").removeCreature("Angel")
        aps.getLeaf("Bk06").addCreature("Angel")
        aps.getLeaf("Gr12").removeCreature("Lion")
        aps.getLeaf("Bk06").removeCreature("Ranger")
        aps.getLeaf("Bk06").revealCreatures(['Angel', 'Troll', 'Troll', 
          'Troll'])
        aps.getLeaf("Bk04").revealCreatures(['Lion', 'Lion'])
        aps.getLeaf("Bk04").addCreature("Ranger")
        aps.getLeaf("Bk10").revealCreatures(['Titan'])
        aps.getLeaf("Bk10").addCreature("Warlock")
        aps.getLeaf("Rd06").revealCreatures(['Titan', 'Angel', 'Angel', 
          'Behemoth', 'Cyclops', 'Cyclops'])
        aps.getLeaf("Gr04").revealCreatures(['Cyclops', 'Gargoyle', 'Gargoyle',
          'Gargoyle'])
        aps.getLeaf("Gr04").removeCreature("Gargoyle")
        aps.getLeaf("Gr04").removeCreature("Gargoyle")
        aps.getLeaf("Gr04").removeCreature("Cyclops")
        aps.getLeaf("Gr04").removeCreature("Gargoyle")
        aps.getLeaf("Rd06").revealCreatures(['Titan', 'Angel', 'Angel', 
          'Behemoth', 'Cyclops', 'Cyclops'])
        aps.getLeaf("Rd06").revealCreatures(['Cyclops', 'Cyclops'])
        aps.getLeaf("Rd06").addCreature("Gorgon")

        aps.check(); aps.printLeaves()
        turn = 19
        print "\nTurn", turn
        aps.getLeaf("Gd06").split(2, "Gd10", turn)
        aps.getLeaf("Gd06").merge(aps.getLeaf("Gd10"), turn)
        aps.getLeaf("Gd06").revealCreatures(['Lion'])
        aps.getLeaf("Gd06").addCreature("Lion")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 3)
        assert(aps.getLeaf("Gd04").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 1)
        aps.getLeaf("Bu02").revealCreatures(['Gorgon'])
        aps.getLeaf("Bu02").addCreature("Gorgon")
        aps.getLeaf("Bu12").revealCreatures(['Guardian'])
        aps.getLeaf("Bu12").addCreature("Guardian")
        aps.getLeaf("Gr08").split(2, "Gr07", turn)
        aps.getLeaf("Gr08").merge(aps.getLeaf("Gr07"), turn)
        aps.getLeaf("Gr01").revealCreatures(['Cyclops', 'Cyclops'])
        aps.getLeaf("Gr01").addCreature("Gorgon")
        aps.getLeaf("Bk06").revealCreatures(['Troll', 'Troll', 'Troll'])
        aps.getLeaf("Bk06").addCreature("Wyvern")

        aps.check(); aps.printLeaves()
        turn = 20
        print "\nTurn", turn
        aps.getLeaf("Gd06").split(2, "Gd08", turn)
        aps.getLeaf("Gd03").revealCreatures(['Behemoth', 'Behemoth'])
        aps.getLeaf("Gd03").addCreature("Serpent")
        aps.getLeaf("Gd06").revealCreatures(['Lion', 'Lion', 'Lion'])
        aps.getLeaf("Gd06").addCreature("Guardian")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 3)
        assert(aps.getLeaf("Gd04").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd08").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 1)
        aps.getLeaf("Bu02").revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf("Bu02").addCreature("Lion")
        aps.getLeaf("Bu10").revealCreatures(['Cyclops', 'Cyclops'])
        aps.getLeaf("Bu10").addCreature("Gorgon")
        aps.getLeaf("Gr01").split(2, "Gr03", turn)
        aps.getLeaf("Gr01").merge(aps.getLeaf("Gr03"), turn)
        aps.getLeaf("Gr08").split(2, "Gr02", turn)
        aps.getLeaf("Bu08").removeCreature("Gorgon")
        aps.getLeaf("Bu08").removeCreature("Gorgon")
        aps.getLeaf("Br01").revealCreatures(['Behemoth'])
        aps.getLeaf("Br01").addCreature("Behemoth")
        aps.getLeaf("Br06").revealCreatures(['Troll'])
        aps.getLeaf("Br06").addCreature("Troll")
        aps.getLeaf("Bk06").revealCreatures(['Angel', 'Wyvern', 'Troll', 
          'Troll', 'Troll'])
        aps.getLeaf("Gd04").revealCreatures(['Gorgon', 'Cyclops', 'Cyclops'])
        aps.getLeaf("Gd04").removeCreature("Gorgon")
        aps.getLeaf("Bk06").removeCreature("Angel")
        aps.getLeaf("Gd04").removeCreature("Cyclops")
        aps.getLeaf("Bk06").removeCreature("Wyvern")
        aps.getLeaf("Gd04").removeCreature("Cyclops")
        aps.getLeaf("Bk06").revealCreatures(['Troll', 'Troll', 'Troll'])
        aps.getLeaf("Bk06").addCreature("Angel")
        aps.getLeaf("Br04").removeCreature("Lion")
        aps.getLeaf("Br04").removeCreature("Centaur")
        aps.getLeaf("Br04").removeCreature("Centaur")

        aps.check(); aps.printLeaves()
        turn = 21
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd07", turn)
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd07"), turn)
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 3)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd08").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 1)
        aps.getLeaf("Bu04").revealCreatures(['Cyclops', 'Cyclops'])
        aps.getLeaf("Bu04").addCreature("Gorgon")
        aps.getLeaf("Bu10").revealCreatures(['Cyclops', 'Cyclops'])
        aps.getLeaf("Bu10").addCreature("Gorgon")
        aps.getLeaf("Gr01").split(2, "Gr05", turn)
        aps.getLeaf("Gr01").revealCreatures(['Gorgon', 'Cyclops', 'Cyclops', 
          'Cyclops', 'Troll'])
        aps.getLeaf("Bu05").revealCreatures(['Titan', 'Warlock', 'Warlock', 
          'Warlock', 'Warlock'])
        aps.getLeaf("Gr01").removeCreature("Gorgon")
        aps.getLeaf("Bu05").removeCreature("Warlock")
        aps.getLeaf("Gr01").removeCreature("Cyclops")
        aps.getLeaf("Gr09").removeCreature("Angel")
        aps.getLeaf("Gr01").addCreature("Angel")
        aps.getLeaf("Bu05").removeCreature("Warlock")
        aps.getLeaf("Gr01").removeCreature("Angel")
        aps.getLeaf("Gr01").removeCreature("Troll")
        aps.getLeaf("Bu05").removeCreature("Warlock")
        aps.getLeaf("Gr01").removeCreature("Cyclops")
        aps.getLeaf("Gr01").removeCreature("Cyclops")
        aps.getLeaf("Bu05").revealCreatures(['Titan', 'Warlock'])
        aps.getLeaf("Bu05").addCreature("Angel")
        aps.getLeaf("Br01").split(2, "Br10", turn)
        aps.getLeaf("Br01").merge(aps.getLeaf("Br10"), turn)

        aps.check(); aps.printLeaves()
        turn = 22
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd09", turn)
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd09"), turn)
        aps.getLeaf("Gd06").revealCreatures(['Lion', 'Lion', 'Lion'])
        aps.getLeaf("Gd06").addCreature("Griffon")
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 3)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd08").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 1)
        aps.getLeaf("Gd12").revealCreatures(['Gorgon'])
        aps.getLeaf("Gd12").addCreature("Gorgon")
        aps.getLeaf("Bu09").removeCreature("Lion")
        aps.getLeaf("Bu09").removeCreature("Lion")
        aps.getLeaf("Bu09").removeCreature("Centaur")
        aps.getLeaf("Br01").split(2, "Br07", turn)
        aps.getLeaf("Br01").merge(aps.getLeaf("Br07"), turn)
        aps.getLeaf("Bk04").revealCreatures(['Lion', 'Lion'])
        aps.getLeaf("Bk04").addCreature("Ranger")
        aps.getLeaf("Bk06").revealCreatures(['Troll', 'Troll'])
        aps.getLeaf("Bk06").addCreature("Warbear")
        aps.getLeaf("Rd06").split(2, "Rd07", turn)
        aps.getLeaf("Rd06").revealCreatures(['Gorgon'])
        aps.getLeaf("Rd06").addCreature("Gorgon")

        aps.check(); aps.printLeaves()
        turn = 23
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd05", turn)
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd05"), turn)
        aps.getLeaf("Gd06").split(2, "Gd04", turn)
        aps.getLeaf("Gd03").revealCreatures(['Titan', 'Serpent', 'Behemoth', 
          'Behemoth', 'Warlock', 'Gorgon', 'Gorgon'])
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd04").numUncertainCreatures() == 2)
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 4)
        assert(aps.getLeaf("Gd08").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 0)
        aps.getLeaf("Rd06").revealCreatures(['Titan', 'Angel', 'Behemoth', 
          'Gorgon', 'Gorgon', 'Cyclops'])
        aps.getLeaf("Rd06").removeCreature("Angel")
        aps.getLeaf("Rd06").removeCreature("Behemoth")
        aps.getLeaf("Gd03").removeCreature("Gorgon")
        aps.getLeaf("Rd06").removeCreature("Gorgon")
        aps.getLeaf("Rd06").removeCreature("Gorgon")
        aps.getLeaf("Rd06").removeCreature("Cyclops")
        aps.getLeaf("Gd03").removeCreature("Gorgon")
        aps.getLeaf("Gd03").removeCreature("Serpent")
        aps.getLeaf("Rd06").removeCreature("Titan")
        aps.getLeaf("Gd03").removeCreature("Warlock")
        aps.getLeaf("Rd07").removeCreature("Angel")
        aps.getLeaf("Rd07").removeCreature("Cyclops")
        aps.getLeaf("Gd03").revealCreatures(['Titan', 'Behemoth', 'Behemoth'])
        aps.getLeaf("Gd03").addCreature("Angel")
        aps.getLeaf("Gd06").revealCreatures(['Griffon'])
        aps.getLeaf("Gd06").addCreature("Griffon")
        aps.getLeaf("Gd12").revealCreatures(['Gorgon'])
        aps.getLeaf("Gd12").addCreature("Gorgon")
        aps.getLeaf("Br01").split(2, "Br09", turn)
        aps.getLeaf("Br01").merge(aps.getLeaf("Br09"), turn)
        aps.getLeaf("Bk04").split(2, "Bk01", turn)
        aps.getLeaf("Bk06").revealCreatures(['Angel', 'Warbear', 'Troll', 
          'Troll', 'Troll'])
        aps.getLeaf("Gr09").revealCreatures(['Angel', 'Cyclops', 'Gargoyle'])
        aps.getLeaf("Gr09").removeCreature("Gargoyle")
        aps.getLeaf("Bk06").removeCreature("Troll")
        aps.getLeaf("Gr09").removeCreature("Angel")
        aps.getLeaf("Gr09").removeCreature("Cyclops")
        aps.getLeaf("Bk06").removeCreature("Angel")
        aps.getLeaf("Bk06").revealCreatures(['Warbear', 'Troll', 'Troll'])
        aps.getLeaf("Bk04").revealCreatures(['Lion', 'Lion'])
        aps.getLeaf("Bk04").addCreature("Minotaur")
        aps.getLeaf("Bu12").revealCreatures(['Behemoth'])
        aps.getLeaf("Bu12").addCreature("Behemoth")
        aps.getLeaf("Gr05").revealCreatures(['Troll'])
        aps.getLeaf("Gr05").addCreature("Troll")
        aps.getLeaf("Br01").split(2, "Br07", turn)
        aps.getLeaf("Bk06").revealCreatures(['Troll'])
        aps.getLeaf("Bk06").addCreature("Troll")

        aps.check(); aps.printLeaves()
        turn = 24
        print "\nTurn", turn
        aps.getLeaf("Gd03").revealCreatures(['Behemoth', 'Behemoth'])
        aps.getLeaf("Gd03").addCreature("Serpent")
        aps.getLeaf("Gd06").revealCreatures(['Guardian'])
        aps.getLeaf("Gd06").addCreature("Guardian")
        aps.getLeaf("Gd12").revealCreatures(['Gorgon', 'Gorgon', 'Gorgon'])
        aps.getLeaf("Gd12").addCreature("Guardian")
        aps.check(); aps.printLeaves()
        assert(aps.getLeaf("Gd03").numUncertainCreatures() == 0)
        assert(aps.getLeaf("Gd04").numUncertainCreatures() == 2)  
        assert(aps.getLeaf("Gd06").numUncertainCreatures() == 2)
        assert(aps.getLeaf("Gd08").numUncertainCreatures() == 1)
        assert(aps.getLeaf("Gd12").numUncertainCreatures() == 0)

        aps.check(); aps.printLeaves()
        turn = 25
        print "\nTurn", turn
        aps.getLeaf("Bu12").split(2, "Bu07", turn)
        aps.getLeaf("Gr08").revealCreatures(['Titan', 'Troll', 'Troll', 
          'Troll', 'Ogre'])
        aps.getLeaf("Br06").revealCreatures(['Cyclops', 'Troll', 'Troll'])
        aps.getLeaf("Gr08").removeCreature("Ogre")
        aps.getLeaf("Br06").removeCreature("Cyclops")
        aps.getLeaf("Gr08").removeCreature("Troll")
        aps.getLeaf("Br06").revealCreatures(['Troll', 'Troll'])
        aps.getLeaf("Br06").addCreature("Ranger")
        aps.getLeaf("Br06").removeCreature("Troll")
        aps.getLeaf("Gr08").removeCreature("Troll")
        aps.getLeaf("Br06").removeCreature("Ranger")
        aps.getLeaf("Br06").removeCreature("Troll")
        aps.getLeaf("Gr08").revealCreatures(['Titan', 'Troll'])
        aps.getLeaf("Gr08").addCreature("Angel")
        aps.getLeaf("Gr08").revealCreatures(['Troll'])
        aps.getLeaf("Gr08").addCreature("Troll")
        aps.getLeaf("Bk04").revealCreatures(['Ranger', 'Ranger', 'Ranger', 
          'Minotaur', 'Lion', 'Lion'])
        aps.getLeaf("Bu05").revealCreatures(['Titan', 'Angel', 'Warlock'])
        aps.getLeaf("Bk04").removeCreature("Ranger")
        aps.getLeaf("Bu05").removeCreature("Angel")
        aps.getLeaf("Bu05").removeCreature("Warlock")
        aps.getLeaf("Bk04").removeCreature("Minotaur")
        aps.getLeaf("Bk04").removeCreature("Lion")
        aps.getLeaf("Bk04").removeCreature("Ranger")
        aps.getLeaf("Bk04").removeCreature("Ranger")
        aps.getLeaf("Bu05").removeCreature("Titan")
        aps.getLeaf("Bk04").removeCreature("Lion")
        aps.getLeaf("Bu12").removeCreature("Guardian")
        aps.getLeaf("Bu12").removeCreature("Guardian")
        aps.getLeaf("Bu12").removeCreature("Behemoth")
        aps.getLeaf("Bu12").removeCreature("Behemoth")
        aps.getLeaf("Bu12").removeCreature("Gorgon")
        aps.getLeaf("Bu10").removeCreature("Gorgon")
        aps.getLeaf("Bu10").removeCreature("Gorgon")
        aps.getLeaf("Bu10").removeCreature("Cyclops")
        aps.getLeaf("Bu10").removeCreature("Cyclops")
        aps.getLeaf("Bu10").removeCreature("Gargoyle")
        aps.getLeaf("Bu10").removeCreature("Gorgon")
        aps.getLeaf("Bu02").removeCreature("Gorgon")
        aps.getLeaf("Bu02").removeCreature("Gorgon")
        aps.getLeaf("Bu02").removeCreature("Gargoyle")
        aps.getLeaf("Bu02").removeCreature("Centaur")
        aps.getLeaf("Bu02").removeCreature("Centaur")
        aps.getLeaf("Bu02").removeCreature("Lion")
        aps.getLeaf("Bu04").removeCreature("Gorgon")
        aps.getLeaf("Bu04").removeCreature("Cyclops")
        aps.getLeaf("Bu04").removeCreature("Cyclops")
        aps.getLeaf("Bu04").removeCreature("Gorgon")
        aps.getLeaf("Bu07").removeCreature("Gorgon")
        aps.getLeaf("Bu07").removeCreature("Cyclops")
        aps.getLeaf("Bk06").revealCreatures(['Troll', 'Troll', 'Troll'])
        aps.getLeaf("Bk06").addCreature("Wyvern")

        aps.check(); aps.printLeaves()
        turn = 26
        print "\nTurn", turn
        aps.getLeaf("Gd06").split(2, "Gd11", turn)
        aps.getLeaf("Gd06").revealCreatures(['Minotaur'])
        aps.getLeaf("Gd06").addCreature("Minotaur")
        aps.getLeaf("Gd11").revealCreatures(['Lion', 'Lion'])
        aps.getLeaf("Gd11").addCreature("Ranger")
        aps.getLeaf("Bk10").revealCreatures(['Titan'])
        aps.getLeaf("Bk10").revealCreatures(['Titan', 'Warlock', 'Gorgon', 
          'Cyclops', 'Cyclops'])
        aps.getLeaf("Gr08").revealCreatures(['Titan', 'Angel', 'Troll', 
          'Troll'])
        aps.getLeaf("Bk10").removeCreature("Gorgon")
        aps.getLeaf("Gr08").removeCreature("Troll")
        aps.getLeaf("Gr08").removeCreature("Troll")
        aps.getLeaf("Bk10").removeCreature("Warlock")
        aps.getLeaf("Bk10").removeCreature("Cyclops")
        aps.getLeaf("Bk10").removeCreature("Cyclops")
        aps.getLeaf("Gr08").removeCreature("Titan")
        aps.getLeaf("Gr08").removeCreature("Angel")
        aps.getLeaf("Gr02").removeCreature("Ogre")
        aps.getLeaf("Gr02").removeCreature("Ogre")
        aps.getLeaf("Gr05").removeCreature("Troll")
        aps.getLeaf("Gr05").removeCreature("Ogre")
        aps.getLeaf("Gr05").removeCreature("Troll")
        aps.getLeaf("Bk10").revealCreatures(['Titan'])
        aps.getLeaf("Bk10").addCreature("Angel")
        aps.getLeaf("Gd11").revealCreatures(['Ranger'])
        aps.getLeaf("Gd11").addCreature("Ranger")
        aps.getLeaf("Br01").revealCreatures(['Behemoth', 'Behemoth'])
        aps.getLeaf("Br01").addCreature("Serpent")
        aps.getLeaf("Br12").revealCreatures(['Warbear', 'Warbear'])
        aps.getLeaf("Br12").addCreature("Unicorn")

        aps.check(); aps.printLeaves()
        turn = 28
        print "\nTurn", turn
        aps.getLeaf("Gd03").revealCreatures(['Serpent'])
        aps.getLeaf("Gd03").addCreature("Serpent")
        aps.getLeaf("Gd11").revealCreatures(['Lion', 'Lion'])
        aps.getLeaf("Gd11").addCreature("Ranger")
        aps.getLeaf("Br12").split(2, "Br04", turn)
        aps.getLeaf("Bk06").revealCreatures(['Warbear'])
        aps.getLeaf("Bk06").addCreature("Warbear")
        aps.getLeaf("Gd06").revealCreatures(['Griffon', 'Griffon'])
        aps.getLeaf("Gd06").addCreature("Hydra")

        aps.check(); aps.printLeaves()
        turn = 30
        print "\nTurn", turn
        aps.getLeaf("Gd06").split(2, "Gd10", turn)
        aps.getLeaf("Gd11").revealCreatures(['Ranger', 'Ranger', 'Ranger'])
        aps.getLeaf("Gd11").addCreature("Guardian")
        aps.getLeaf("Br12").revealCreatures(['Unicorn', 'Unicorn', 'Unicorn'])
        aps.getLeaf("Br12").addCreature("Guardian")
        aps.getLeaf("Br07").removeCreature("Cyclops")
        aps.getLeaf("Br07").removeCreature("Cyclops")
        aps.getLeaf("Bk10").addCreature("Angel")
        aps.getLeaf("Gd08").removeCreature("Centaur")
        aps.getLeaf("Gd08").removeCreature("Centaur")
        aps.getLeaf("Bk06").revealCreatures(['Wyvern'])
        aps.getLeaf("Bk06").addCreature("Wyvern")

        aps.check(); aps.printLeaves()
        turn = 31
        print "\nTurn", turn
        aps.getLeaf("Gd06").revealCreatures(['Minotaur', 'Minotaur'])
        aps.getLeaf("Gd06").addCreature("Unicorn")
        aps.getLeaf("Gd11").revealCreatures(['Ranger'])
        aps.getLeaf("Gd11").addCreature("Ranger")
        aps.getLeaf("Bk06").split(2, "Bk02", turn)
        aps.getLeaf("Gd04").removeCreature("Lion")
        aps.getLeaf("Gd04").removeCreature("Centaur")
        aps.getLeaf("Bk06").revealCreatures(['Troll'])
        aps.getLeaf("Bk06").addCreature("Troll")

        aps.check(); aps.printLeaves()
        turn = 32
        print "\nTurn", turn
        aps.getLeaf("Gd06").split(2, "Gd01", turn)
        aps.getLeaf("Gd11").split(2, "Gd05", turn)
        aps.getLeaf("Gd11").revealCreatures(['Ranger'])
        aps.getLeaf("Gd11").addCreature("Ranger")
        aps.getLeaf("Br04").revealCreatures(['Warbear', 'Warbear'])
        aps.getLeaf("Br04").addCreature("Unicorn")
        aps.getLeaf("Bk02").revealCreatures(['Troll', 'Troll'])
        aps.getLeaf("Bk02").addCreature("Ranger")
        aps.getLeaf("Gd03").revealCreatures(['Serpent'])
        aps.getLeaf("Gd03").addCreature("Serpent")
        aps.getLeaf("Gd05").revealCreatures(['Lion', 'Lion'])
        aps.getLeaf("Gd05").addCreature("Ranger")
        aps.getLeaf("Gd06").revealCreatures(['Hydra'])
        aps.getLeaf("Gd06").addCreature("Hydra")
        aps.getLeaf("Gd11").revealCreatures(['Ranger'])
        aps.getLeaf("Gd11").addCreature("Ranger")
        aps.getLeaf("Br12").revealCreatures(['Unicorn'])
        aps.getLeaf("Br12").addCreature("Unicorn")
        aps.getLeaf("Bk10").revealCreatures(['Titan'])
        aps.getLeaf("Br04").removeCreature("Unicorn")
        aps.getLeaf("Br04").removeCreature("Warbear")
        aps.getLeaf("Br04").removeCreature("Warbear")
        aps.getLeaf("Bk06").revealCreatures(['Wyvern', 'Wyvern'])
        aps.getLeaf("Bk06").addCreature("Hydra")
        aps.check(); aps.printLeaves()
        turn = 34
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd07", turn)
        aps.getLeaf("Gd11").split(2, "Gd02", turn)
        aps.getLeaf("Gd02").revealCreatures(['Ranger'])
        aps.getLeaf("Gd02").addCreature("Ranger")
        aps.getLeaf("Gd05").revealCreatures(['Ranger'])
        aps.getLeaf("Gd05").addCreature("Ranger")
        aps.getLeaf("Gd10").revealCreatures(['Griffon', 'Griffon'])
        aps.getLeaf("Gd10").addCreature("Hydra")
        aps.getLeaf("Gd11").revealCreatures(['Ranger'])
        aps.getLeaf("Gd11").addCreature("Ranger")
        aps.getLeaf("Br12").split(2, "Br04", turn)
        aps.getLeaf("Br01").revealCreatures(['Serpent'])
        aps.getLeaf("Br01").addCreature("Serpent")
        aps.getLeaf("Bk06").split(2, "Bk05", turn)
        aps.getLeaf("Gd02").removeCreature("Ranger")
        aps.getLeaf("Gd02").removeCreature("Ranger")
        aps.getLeaf("Gd02").removeCreature("Ranger")
        aps.getLeaf("Bk02").revealCreatures(['Ranger'])
        aps.getLeaf("Bk02").addCreature("Troll")
        aps.getLeaf("Bk05").revealCreatures(['Troll', 'Troll'])
        aps.getLeaf("Bk05").addCreature("Ranger")
        aps.getLeaf("Gd11").revealCreatures(['Guardian'])
        aps.getLeaf("Gd11").addCreature("Guardian")
        aps.check(); aps.printLeaves()
        turn = 35
        print "\nTurn", turn
        aps.getLeaf("Br01").split(2, "Br07", turn)
        aps.getLeaf("Gd10").removeCreature("Hydra")
        aps.getLeaf("Gd10").removeCreature("Griffon")
        aps.getLeaf("Gd10").removeCreature("Griffon")
        aps.getLeaf("Bk10").addCreature("Angel")
        aps.getLeaf("Bk02").revealCreatures(['Ranger', 'Troll', 'Troll', 
          'Troll'])
        aps.getLeaf("Gd07").revealCreatures(['Behemoth', 'Behemoth'])
        aps.getLeaf("Bk02").removeCreature("Ranger")
        aps.getLeaf("Gd07").removeCreature("Behemoth")
        aps.getLeaf("Bk10").removeCreature("Angel")
        aps.getLeaf("Bk02").addCreature("Angel")
        aps.getLeaf("Gd07").removeCreature("Behemoth")
        aps.getLeaf("Bk02").removeCreature("Troll")
        aps.getLeaf("Bk02").revealCreatures(['Angel', 'Troll', 'Troll'])
        aps.getLeaf("Bk05").revealCreatures(['Ranger'])
        aps.getLeaf("Bk05").addCreature("Troll")
        aps.check(); aps.printLeaves()
        turn = 36
        print "\nTurn", turn
        aps.getLeaf("Gd11").split(2, "Gd08", turn)
        aps.getLeaf("Gd11").merge(aps.getLeaf("Gd08"), turn)
        aps.getLeaf("Gd05").revealCreatures(['Lion', 'Lion'])
        aps.getLeaf("Gd05").addCreature("Ranger")
        aps.getLeaf("Br12").revealCreatures(['Unicorn'])
        aps.getLeaf("Br12").addCreature("Unicorn")
        aps.getLeaf("Bk05").revealCreatures(['Ranger'])
        aps.getLeaf("Bk05").addCreature("Ranger")
        aps.check(); aps.printLeaves()
        turn = 37
        print "\nTurn", turn
        aps.getLeaf("Gd11").split(2, "Gd08", turn)
        aps.getLeaf("Gd05").revealCreatures(['Ranger'])
        aps.getLeaf("Gd05").addCreature("Ranger")
        aps.getLeaf("Br04").revealCreatures(['Unicorn'])
        aps.getLeaf("Br04").addCreature("Unicorn")
        aps.getLeaf("Br12").revealCreatures(['Unicorn'])
        aps.getLeaf("Br12").addCreature("Unicorn")
        aps.getLeaf("Bk02").revealCreatures(['Troll'])
        aps.getLeaf("Bk02").addCreature("Troll")
        aps.getLeaf("Bk06").revealCreatures(['Hydra'])
        aps.getLeaf("Bk06").addCreature("Hydra")
        aps.getLeaf("Gd06").revealCreatures(['Hydra'])
        aps.getLeaf("Gd06").addCreature("Hydra")
        aps.getLeaf("Gd08").revealCreatures(['Ranger'])
        aps.getLeaf("Gd08").addCreature("Ranger")
        aps.check(); aps.printLeaves()
        turn = 38
        print "\nTurn", turn
        aps.getLeaf("Br12").split(2, "Br09", turn)
        aps.getLeaf("Br12").merge(aps.getLeaf("Br09"), turn)
        aps.getLeaf("Bk05").revealCreatures(['Ranger'])
        aps.getLeaf("Bk05").addCreature("Ranger")
        aps.check(); aps.printLeaves()
        turn = 39
        print "\nTurn", turn
        aps.getLeaf("Br12").split(2, "Br06", turn)
        aps.getLeaf("Br12").merge(aps.getLeaf("Br06"), turn)
        aps.getLeaf("Br01").revealCreatures(['Serpent'])
        aps.getLeaf("Br01").addCreature("Serpent")
        aps.getLeaf("Bk02").revealCreatures(['Angel', 'Troll', 'Troll', 
          'Troll'])
        aps.getLeaf("Br07").revealCreatures(['Behemoth', 'Behemoth'])
        aps.getLeaf("Br07").removeCreature("Behemoth")
        aps.getLeaf("Bk02").removeCreature("Angel")
        aps.getLeaf("Bk10").removeCreature("Angel")
        aps.getLeaf("Bk02").addCreature("Angel")
        aps.getLeaf("Bk02").removeCreature("Troll")
        aps.getLeaf("Br07").removeCreature("Behemoth")
        aps.getLeaf("Bk02").revealCreatures(['Angel', 'Troll', 'Troll'])
        aps.getLeaf("Bk02").addCreature("Archangel")
        aps.getLeaf("Bk05").revealCreatures(['Ranger'])
        aps.getLeaf("Bk05").addCreature("Ranger")
        aps.getLeaf("Bk06").revealCreatures(['Wyvern', 'Wyvern'])
        aps.getLeaf("Bk06").addCreature("Hydra")
        aps.getLeaf("Gd05").revealCreatures(['Lion', 'Lion'])
        aps.getLeaf("Gd05").addCreature("Ranger")
        aps.check(); aps.printLeaves()
        turn = 40
        print "\nTurn", turn
        aps.getLeaf("Br12").split(2, "Br05", turn)
        aps.getLeaf("Br12").merge(aps.getLeaf("Br05"), turn)
        aps.getLeaf("Bk05").split(2, "Bk03", turn)
        aps.getLeaf("Br04").removeCreature("Guardian")
        aps.getLeaf("Br04").removeCreature("Unicorn")
        aps.getLeaf("Br04").removeCreature("Unicorn")
        aps.getLeaf("Bk03").revealCreatures(['Ranger'])
        aps.getLeaf("Bk03").addCreature("Ranger")
        aps.getLeaf("Bk05").revealCreatures(['Ranger'])
        aps.getLeaf("Bk05").addCreature("Ranger")
        aps.check(); aps.printLeaves()
        turn = 41
        print "\nTurn", turn
        aps.getLeaf("Gd05").split(2, "Gd09", turn)
        aps.getLeaf("Gd03").revealCreatures(['Serpent'])
        aps.getLeaf("Gd03").addCreature("Serpent")
        aps.getLeaf("Gd05").revealCreatures(['Ranger'])
        aps.getLeaf("Gd05").addCreature("Troll")
        aps.getLeaf("Gd06").revealCreatures(['Hydra'])
        aps.getLeaf("Gd06").addCreature("Hydra")
        aps.getLeaf("Gd11").revealCreatures(['Ranger'])
        aps.getLeaf("Gd11").addCreature("Troll")
        aps.getLeaf("Br12").split(2, "Br03", turn)
        aps.getLeaf("Br12").merge(aps.getLeaf("Br03"), turn)
        aps.getLeaf("Bk05").revealCreatures(['Troll', 'Troll'])
        aps.getLeaf("Bk05").addCreature("Warbear")
        aps.check(); aps.printLeaves()
        turn = 42
        print "\nTurn", turn
        aps.getLeaf("Gd06").split(2, "Gd02", turn)
        aps.getLeaf("Gd06").merge(aps.getLeaf("Gd02"), turn)
        aps.getLeaf("Gd11").revealCreatures(['Troll'])
        aps.getLeaf("Gd11").addCreature("Troll")
        aps.getLeaf("Br12").split(2, "Br08", turn)
        aps.getLeaf("Br12").merge(aps.getLeaf("Br08"), turn)
        aps.getLeaf("Bk05").split(2, "Bk12", turn)
        aps.getLeaf("Bk02").revealCreatures(['Troll'])
        aps.getLeaf("Bk02").addCreature("Troll")
        aps.getLeaf("Bk03").revealCreatures(['Ranger', 'Ranger', 'Ranger'])
        aps.getLeaf("Bk03").addCreature("Guardian")
        aps.getLeaf("Bk10").revealCreatures(['Titan'])
        aps.getLeaf("Bk10").addCreature("Warlock")
        aps.check(); aps.printLeaves()
        turn = 43
        print "\nTurn", turn
        aps.getLeaf("Gd06").split(2, "Gd07", turn)
        aps.getLeaf("Gd11").split(2, "Gd10", turn)
        aps.getLeaf("Gd11").merge(aps.getLeaf("Gd10"), turn)
        aps.getLeaf("Br12").split(2, "Br07", turn)
        aps.getLeaf("Br12").merge(aps.getLeaf("Br07"), turn)
        aps.getLeaf("Bk06").split(2, "Bk08", turn)
        aps.check(); aps.printLeaves()
        turn = 44
        print "\nTurn", turn
        aps.getLeaf("Gd11").split(2, "Gd04", turn)
        aps.getLeaf("Gd11").merge(aps.getLeaf("Gd04"), turn)
        aps.getLeaf("Br12").split(2, "Br11", turn)
        aps.getLeaf("Br12").merge(aps.getLeaf("Br11"), turn)
        aps.getLeaf("Bk01").removeCreature("Centaur")
        aps.getLeaf("Bk01").removeCreature("Centaur")
        aps.check(); aps.printLeaves()
        turn = 45
        print "\nTurn", turn
        aps.getLeaf("Gd11").split(2, "Gd02", turn)
        aps.getLeaf("Gd11").merge(aps.getLeaf("Gd02"), turn)
        aps.getLeaf("Gd01").revealCreatures(['Minotaur', 'Minotaur'])
        aps.getLeaf("Gd01").addCreature("Unicorn")
        aps.getLeaf("Br12").split(2, "Br11", turn)
        aps.getLeaf("Br11").revealCreatures(['Unicorn'])
        aps.getLeaf("Br11").addCreature("Minotaur")
        aps.getLeaf("Bk05").revealCreatures(['Warbear'])
        aps.getLeaf("Bk05").addCreature("Warbear")
        aps.getLeaf("Bk06").revealCreatures(['Hydra'])
        aps.getLeaf("Bk06").addCreature("Hydra")
        aps.check(); aps.printLeaves()
        turn = 46
        print "\nTurn", turn
        aps.getLeaf("Gd11").split(2, "Gd02", turn)
        aps.getLeaf("Br01").revealCreatures(['Titan'])
        aps.getLeaf("Br01").addCreature("Warlock")
        aps.getLeaf("Br12").revealCreatures(['Unicorn'])
        aps.getLeaf("Br12").addCreature("Warbear")
        aps.getLeaf("Gd06").revealCreatures(['Hydra'])
        aps.getLeaf("Gd06").addCreature("Hydra")
        aps.check(); aps.printLeaves()
        turn = 47
        print "\nTurn", turn
        aps.getLeaf("Br01").split(2, "Br06", turn)
        aps.getLeaf("Br01").revealCreatures(['Serpent'])
        aps.getLeaf("Br01").addCreature("Serpent")
        aps.getLeaf("Gd07").removeCreature("Guardian")
        aps.getLeaf("Gd07").removeCreature("Guardian")
        aps.getLeaf("Gd11").removeCreature("Guardian")
        aps.getLeaf("Gd11").removeCreature("Guardian")
        aps.getLeaf("Gd11").removeCreature("Ranger")
        aps.getLeaf("Gd11").removeCreature("Troll")
        aps.getLeaf("Gd11").removeCreature("Troll")
        aps.getLeaf("Bk06").addCreature("Angel")
        aps.getLeaf("Gd03").revealCreatures(['Serpent'])
        aps.getLeaf("Gd03").addCreature("Serpent")
        aps.getLeaf("Gd06").revealCreatures(['Unicorn'])
        aps.getLeaf("Gd06").addCreature("Warbear")
        aps.getLeaf("Bk02").revealCreatures(['Troll', 'Troll', 'Troll'])
        aps.getLeaf("Bk02").addCreature("Guardian")
        aps.check(); aps.printLeaves()
        turn = 49
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd07", turn)
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd07"), turn)
        aps.getLeaf("Gd06").split(2, "Gd07", turn)
        aps.getLeaf("Gd06").merge(aps.getLeaf("Gd07"), turn)
        aps.getLeaf("Gd01").revealCreatures(['Unicorn'])
        aps.getLeaf("Gd01").addCreature("Warbear")
        aps.getLeaf("Gd09").revealCreatures(['Lion', 'Lion'])
        aps.getLeaf("Gd09").addCreature("Minotaur")
        aps.getLeaf("Br12").revealCreatures(['Unicorn'])
        aps.getLeaf("Br12").addCreature("Minotaur")
        aps.getLeaf("Bk05").revealCreatures(['Warbear', 'Warbear'])
        aps.getLeaf("Bk05").addCreature("Giant")
        aps.check(); aps.printLeaves()
        turn = 50
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd10", turn)
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd10"), turn)
        aps.getLeaf("Gd06").split(2, "Gd11", turn)
        aps.getLeaf("Gd06").merge(aps.getLeaf("Gd11"), turn)
        aps.getLeaf("Gd01").revealCreatures(['Minotaur'])
        aps.getLeaf("Gd01").addCreature("Minotaur")
        aps.getLeaf("Br12").split(2, "Br07", turn)
        aps.getLeaf("Bk03").revealCreatures(['Guardian'])
        aps.getLeaf("Bk03").addCreature("Guardian")
        aps.check(); aps.printLeaves()
        turn = 51
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd07", turn)
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd07"), turn)
        aps.getLeaf("Gd06").split(2, "Gd11", turn)
        aps.getLeaf("Br01").revealCreatures(['Serpent'])
        aps.getLeaf("Br01").addCreature("Behemoth")
        aps.getLeaf("Bk05").split(2, "Bk07", turn)
        aps.getLeaf("Gd09").removeCreature("Minotaur")
        aps.getLeaf("Gd09").removeCreature("Lion")
        aps.getLeaf("Gd09").removeCreature("Lion")
        aps.getLeaf("Gd11").removeCreature("Unicorn")
        aps.getLeaf("Gd11").removeCreature("Warbear")
        aps.check(); aps.printLeaves()
        turn = 52
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd04", turn)
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd04"), turn)
        aps.getLeaf("Gd06").revealCreatures(['Hydra'])
        aps.getLeaf("Gd06").addCreature("Griffon")
        aps.getLeaf("Br01").split(2, "Br03", turn)
        aps.getLeaf("Br11").revealCreatures(['Unicorn'])
        aps.getLeaf("Br11").addCreature("Warbear")
        aps.getLeaf("Bk10").revealCreatures(['Titan'])
        aps.getLeaf("Br11").removeCreature("Unicorn")
        aps.getLeaf("Br11").removeCreature("Unicorn")
        aps.getLeaf("Br11").removeCreature("Warbear")
        aps.getLeaf("Br11").removeCreature("Minotaur")
        aps.getLeaf("Bk10").addCreature("Angel")
        aps.getLeaf("Bk08").revealCreatures(['Warbear', 'Warbear'])
        aps.getLeaf("Bk08").addCreature("Giant")
        aps.check(); aps.printLeaves()
        turn = 53
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd09", turn)
        aps.getLeaf("Gd05").revealCreatures(['Ranger', 'Ranger', 'Ranger'])
        aps.getLeaf("Gd05").addCreature("Guardian")
        aps.getLeaf("Gd08").revealCreatures(['Ranger', 'Ranger', 'Ranger'])
        aps.getLeaf("Gd08").addCreature("Guardian")
        aps.getLeaf("Gd01").removeCreature("Unicorn")
        aps.getLeaf("Gd01").removeCreature("Warbear")
        aps.getLeaf("Gd01").removeCreature("Minotaur")
        aps.getLeaf("Gd01").removeCreature("Minotaur")
        aps.getLeaf("Gd01").removeCreature("Minotaur")
        aps.getLeaf("Gd02").removeCreature("Ranger")
        aps.getLeaf("Gd02").removeCreature("Ranger")
        aps.getLeaf("Bk05").revealCreatures(['Giant', 'Warbear', 'Warbear', 
          'Ranger', 'Troll'])
        aps.getLeaf("Gd09").revealCreatures(['Serpent', 'Angel'])
        aps.getLeaf("Gd09").removeCreature("Serpent")
        aps.getLeaf("Bk05").removeCreature("Giant")
        aps.getLeaf("Bk05").removeCreature("Warbear")
        aps.getLeaf("Bk02").removeCreature("Archangel")
        aps.getLeaf("Bk05").addCreature("Archangel")
        aps.getLeaf("Gd09").removeCreature("Angel")
        aps.getLeaf("Bk05").revealCreatures(['Archangel', 'Warbear', 'Ranger', 
          'Troll'])
        aps.getLeaf("Bk05").addCreature("Angel")
        aps.getLeaf("Bk02").revealCreatures(['Troll', 'Troll', 'Troll'])
        aps.getLeaf("Bk02").addCreature("Wyvern")
        aps.check(); aps.printLeaves()
        turn = 54
        print "\nTurn", turn
        aps.getLeaf("Gd05").split(2, "Gd07", turn)
        aps.getLeaf("Br03").revealCreatures(['Behemoth'])
        aps.getLeaf("Br03").addCreature("Behemoth")
        aps.getLeaf("Br01").revealCreatures(['Serpent'])
        aps.getLeaf("Br01").addCreature("Behemoth")
        aps.getLeaf("Gd06").revealCreatures(['Griffon'])
        aps.getLeaf("Gd06").addCreature("Griffon")
        aps.getLeaf("Bk08").revealCreatures(['Warbear'])
        aps.getLeaf("Bk08").addCreature("Warbear")
        aps.check(); aps.printLeaves()
        turn = 58
        print "\nTurn", turn
        aps.getLeaf("Gd06").split(2, "Gd11", turn)
        aps.getLeaf("Br06").revealCreatures(['Warlock'])
        aps.getLeaf("Br06").addCreature("Warlock")
        aps.getLeaf("Br12").revealCreatures(['Unicorn'])
        aps.getLeaf("Br12").addCreature("Minotaur")
        aps.getLeaf("Br12").revealCreatures(['Minotaur'])
        aps.getLeaf("Br12").addCreature("Minotaur")
        aps.getLeaf("Bk10").revealCreatures(['Warlock'])
        aps.getLeaf("Bk10").addCreature("Warlock")
        aps.getLeaf("Gd06").revealCreatures(['Hydra'])
        aps.getLeaf("Gd06").addCreature("Griffon")
        aps.check(); aps.printLeaves()
        turn = 60
        print "\nTurn", turn
        aps.getLeaf("Br12").split(2, "Br02", turn)
        aps.getLeaf("Bk10").revealCreatures(['Titan'])
        aps.getLeaf("Gd12").removeCreature("Guardian")
        aps.getLeaf("Gd12").removeCreature("Gorgon")
        aps.getLeaf("Gd12").removeCreature("Gorgon")
        aps.getLeaf("Gd12").removeCreature("Gorgon")
        aps.getLeaf("Gd12").removeCreature("Gorgon")
        aps.getLeaf("Gd12").removeCreature("Cyclops")
        aps.getLeaf("Gd05").removeCreature("Guardian")
        aps.getLeaf("Gd05").removeCreature("Ranger")
        aps.getLeaf("Gd05").removeCreature("Ranger")
        aps.getLeaf("Gd05").removeCreature("Ranger")
        aps.getLeaf("Gd05").removeCreature("Troll")
        aps.getLeaf("Bk10").addCreature("Angel")
        aps.getLeaf("Gd11").removeCreature("Griffon")
        aps.getLeaf("Gd11").removeCreature("Griffon")
        aps.getLeaf("Bk07").revealCreatures(['Troll', 'Troll'])
        aps.getLeaf("Bk07").addCreature("Warbear")
        aps.getLeaf("Bk10").revealCreatures(['Warlock'])
        aps.getLeaf("Bk10").addCreature("Warlock")
        aps.getLeaf("Br01").revealCreatures(['Serpent'])
        aps.getLeaf("Br01").addCreature("Behemoth")
        aps.getLeaf("Br03").revealCreatures(['Behemoth'])
        aps.getLeaf("Br03").addCreature("Behemoth")
        aps.check(); aps.printLeaves()
        turn = 61
        print "\nTurn", turn
        aps.getLeaf("Bk10").split(2, "Bk09", turn)
        aps.getLeaf("Gd07").removeCreature("Ranger")
        aps.getLeaf("Gd07").removeCreature("Ranger")
        aps.getLeaf("Bk07").revealCreatures(['Warbear'])
        aps.getLeaf("Bk07").addCreature("Warbear")
        aps.check(); aps.printLeaves()
        turn = 62
        print "\nTurn", turn
        aps.getLeaf("Br01").split(2, "Br05", turn)
        aps.getLeaf("Bk10").revealCreatures(['Titan'])
        aps.getLeaf("Bk10").revealCreatures(['Titan', 'Angel', 'Angel', 
          'Angel', 'Warlock'])
        aps.getLeaf("Br12").revealCreatures(['Unicorn', 'Unicorn', 'Unicorn', 
          'Unicorn', 'Unicorn'])
        aps.getLeaf("Br12").removeCreature("Unicorn")
        aps.getLeaf("Br12").removeCreature("Unicorn")
        aps.getLeaf("Br12").removeCreature("Unicorn")
        aps.getLeaf("Bk10").removeCreature("Angel")
        aps.getLeaf("Bk10").removeCreature("Angel")
        aps.getLeaf("Bk05").removeCreature("Archangel")
        aps.getLeaf("Bk10").addCreature("Archangel")
        aps.getLeaf("Br12").removeCreature("Unicorn")
        aps.getLeaf("Br12").removeCreature("Unicorn")
        aps.getLeaf("Bk10").removeCreature("Archangel")
        aps.getLeaf("Bk10").revealCreatures(['Titan', 'Angel', 'Warlock'])
        aps.getLeaf("Bk10").addCreature("Archangel")
        aps.getLeaf("Gd08").removeCreature("Guardian")
        aps.getLeaf("Gd08").removeCreature("Ranger")
        aps.getLeaf("Gd08").removeCreature("Ranger")
        aps.getLeaf("Gd08").removeCreature("Ranger")
        aps.getLeaf("Bk02").addCreature("Angel")
        aps.getLeaf("Bk03").revealCreatures(['Guardian', 'Guardian', 'Ranger', 
          'Ranger', 'Ranger'])
        aps.getLeaf("Br06").revealCreatures(['Warlock', 'Warlock', 'Gorgon'])
        aps.getLeaf("Br06").removeCreature("Warlock")
        aps.getLeaf("Bk03").removeCreature("Ranger")
        aps.getLeaf("Bk03").removeCreature("Ranger")
        aps.getLeaf("Br06").removeCreature("Warlock")
        aps.getLeaf("Br06").removeCreature("Gorgon")
        aps.getLeaf("Bk03").revealCreatures(['Guardian', 'Guardian', 'Ranger'])
        aps.getLeaf("Bk07").revealCreatures(['Warbear', 'Warbear', 'Troll', 
          'Troll'])
        aps.getLeaf("Br07").revealCreatures(['Warbear', 'Minotaur'])
        aps.getLeaf("Br07").removeCreature("Warbear")
        aps.getLeaf("Bk07").removeCreature("Warbear")
        aps.getLeaf("Br07").removeCreature("Minotaur")
        aps.getLeaf("Bk07").revealCreatures(['Warbear', 'Troll', 'Troll'])
        aps.getLeaf("Bk07").addCreature("Angel")
        aps.getLeaf("Bk08").revealCreatures(['Warbear'])
        aps.getLeaf("Bk08").addCreature("Warbear")
        aps.getLeaf("Gd06").revealCreatures(['Hydra'])
        aps.getLeaf("Gd06").addCreature("Wyvern")
        aps.check(); aps.printLeaves()
        turn = 63
        print "\nTurn", turn
        aps.getLeaf("Bk02").split(2, "Bk11", turn)
        aps.getLeaf("Bk06").split(2, "Bk04", turn)
        aps.getLeaf("Bk02").revealCreatures(['Wyvern'])
        aps.getLeaf("Bk02").addCreature("Wyvern")
        aps.getLeaf("Bk06").revealCreatures(['Hydra'])
        aps.getLeaf("Bk06").addCreature("Wyvern")
        aps.getLeaf("Bk07").revealCreatures(['Warbear'])
        aps.getLeaf("Bk07").addCreature("Warbear")
        aps.getLeaf("Bk09").revealCreatures(['Warlock'])
        aps.getLeaf("Bk09").addCreature("Warlock")
        aps.getLeaf("Bk10").revealCreatures(['Warlock'])
        aps.getLeaf("Bk10").addCreature("Warlock")
        aps.check(); aps.printLeaves()
        turn = 64
        print "\nTurn", turn
        aps.getLeaf("Gd06").split(2, "Gd07", turn)
        aps.getLeaf("Gd06").merge(aps.getLeaf("Gd07"), turn)
        aps.getLeaf("Gd03").revealCreatures(['Titan'])
        aps.getLeaf("Gd03").addCreature("Warlock")
        aps.getLeaf("Br02").removeCreature("Minotaur")
        aps.getLeaf("Br02").removeCreature("Minotaur")
        aps.check(); aps.printLeaves()
        turn = 65
        print "\nTurn", turn
        aps.getLeaf("Gd06").split(2, "Gd08", turn)
        aps.getLeaf("Gd06").merge(aps.getLeaf("Gd08"), turn)
        aps.getLeaf("Bk10").revealCreatures(['Titan'])
        aps.getLeaf("Bk10").revealCreatures(['Titan', 'Archangel', 'Angel', 
          'Warlock', 'Warlock'])
        aps.getLeaf("Br03").revealCreatures(['Angel', 'Behemoth', 'Behemoth', 
          'Behemoth'])
        aps.getLeaf("Br03").removeCreature("Angel")
        aps.getLeaf("Br03").removeCreature("Behemoth")
        aps.getLeaf("Bk10").removeCreature("Angel")
        aps.getLeaf("Bk05").removeCreature("Angel")
        aps.getLeaf("Bk10").addCreature("Angel")
        aps.getLeaf("Br03").removeCreature("Behemoth")
        aps.getLeaf("Bk10").removeCreature("Warlock")
        aps.getLeaf("Bk10").removeCreature("Warlock")
        aps.getLeaf("Br03").removeCreature("Behemoth")
        aps.getLeaf("Bk10").revealCreatures(['Titan', 'Archangel', 'Angel'])
        aps.getLeaf("Bk10").addCreature("Angel")
        aps.getLeaf("Bk02").revealCreatures(['Wyvern'])
        aps.getLeaf("Bk02").addCreature("Wyvern")
        aps.getLeaf("Bk05").revealCreatures(['Warbear'])
        aps.getLeaf("Bk05").addCreature("Warbear")
        aps.check(); aps.printLeaves()
        turn = 66
        print "\nTurn", turn
        aps.getLeaf("Gd06").split(2, "Gd05", turn)
        aps.getLeaf("Gd03").revealCreatures(['Warlock'])
        aps.getLeaf("Gd03").addCreature("Warlock")
        aps.getLeaf("Bk06").revealCreatures(['Hydra'])
        aps.getLeaf("Bk06").addCreature("Griffon")
        aps.getLeaf("Bk07").revealCreatures(['Warbear'])
        aps.getLeaf("Bk07").addCreature("Warbear")
        aps.getLeaf("Bk08").revealCreatures(['Warbear'])
        aps.getLeaf("Bk08").addCreature("Warbear")
        aps.check(); aps.printLeaves()
        turn = 67
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd02", turn)
        aps.getLeaf("Gd03").revealCreatures(['Titan'])
        aps.getLeaf("Gd03").revealCreatures(['Titan'])
        aps.getLeaf("Gd03").addCreature("Warlock")
        aps.getLeaf("Bk02").split(2, "Bk01", turn)
        aps.getLeaf("Gd05").removeCreature("Wyvern")
        aps.getLeaf("Gd05").removeCreature("Griffon")
        aps.getLeaf("Br05").removeCreature("Behemoth")
        aps.getLeaf("Br05").removeCreature("Behemoth")
        aps.getLeaf("Bk05").revealCreatures(['Warbear'])
        aps.getLeaf("Bk05").addCreature("Warbear")
        aps.getLeaf("Gd03").revealCreatures(['Titan'])
        aps.getLeaf("Gd03").revealCreatures(['Serpent', 'Serpent', 'Serpent'])
        aps.getLeaf("Gd03").addCreature("Guardian")
        aps.getLeaf("Gd06").revealCreatures(['Hydra'])
        aps.getLeaf("Gd06").addCreature("Wyvern")
        aps.check(); aps.printLeaves()
        turn = 68
        print "\nTurn", turn
        aps.getLeaf("Bk06").split(2, "Gr01", turn)
        aps.getLeaf("Bk06").merge(aps.getLeaf("Gr01"), turn)
        aps.check(); aps.printLeaves()
        turn = 69
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd12", turn)
        aps.getLeaf("Gd03").revealCreatures(['Titan'])
        aps.getLeaf("Gd03").revealCreatures(['Serpent', 'Serpent', 'Serpent'])
        aps.getLeaf("Gd03").addCreature("Guardian")
        aps.getLeaf("Gd06").revealCreatures(['Wyvern'])
        aps.getLeaf("Gd06").addCreature("Wyvern")
        aps.getLeaf("Bk06").split(2, "Bu09", turn)
        aps.getLeaf("Bk11").revealCreatures(['Troll', 'Troll'])
        aps.getLeaf("Bk11").addCreature("Warbear")
        aps.check(); aps.printLeaves()
        turn = 70
        print "\nTurn", turn
        aps.getLeaf("Gd06").split(2, "Gd01", turn)
        aps.getLeaf("Gd03").revealCreatures(['Titan'])
        aps.getLeaf("Gd01").revealCreatures(['Wyvern', 'Wyvern'])
        aps.getLeaf("Bk10").revealCreatures(['Titan', 'Archangel', 'Angel', 
          'Angel'])
        aps.getLeaf("Gd01").removeCreature("Wyvern")
        aps.getLeaf("Gd01").removeCreature("Wyvern")
        aps.getLeaf("Bk10").revealCreatures(['Titan', 'Archangel', 'Angel', 
          'Angel'])
        aps.getLeaf("Bk10").addCreature("Angel")
        aps.getLeaf("Gd03").revealCreatures(['Serpent', 'Serpent', 'Serpent'])
        aps.getLeaf("Gd03").addCreature("Guardian")
        aps.getLeaf("Gd06").revealCreatures(['Hydra'])
        aps.getLeaf("Gd06").addCreature("Wyvern")
        aps.getLeaf("Bk10").revealCreatures(['Titan'])
        aps.getLeaf("Gd12").removeCreature("Guardian")
        aps.getLeaf("Gd12").removeCreature("Warlock")
        aps.getLeaf("Bk01").revealCreatures(['Wyvern'])
        aps.getLeaf("Bk01").addCreature("Wyvern")
        aps.getLeaf("Bk04").revealCreatures(['Wyvern'])
        aps.getLeaf("Bk04").addCreature("Wyvern")
        aps.getLeaf("Bk05").revealCreatures(['Warbear', 'Warbear'])
        aps.getLeaf("Bk05").addCreature("Giant")
        aps.getLeaf("Bk10").revealCreatures(['Titan'])
        aps.getLeaf("Bk10").addCreature("Warlock")
        aps.check(); aps.printLeaves()
        turn = 71
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd04", turn)
        aps.getLeaf("Gd03").revealCreatures(['Serpent'])
        aps.getLeaf("Gd03").addCreature("Behemoth")
        aps.getLeaf("Bk03").removeCreature("Guardian")
        aps.getLeaf("Bk03").removeCreature("Guardian")
        aps.getLeaf("Bk03").removeCreature("Ranger")
        aps.getLeaf("Bk06").revealCreatures(['Hydra'])
        aps.getLeaf("Bk06").addCreature("Griffon")
        aps.getLeaf("Gd06").revealCreatures(['Wyvern'])
        aps.getLeaf("Gd06").addCreature("Wyvern")
        aps.getLeaf("Br01").revealCreatures(['Serpent', 'Serpent', 'Serpent'])
        aps.getLeaf("Br01").addCreature("Guardian")
        aps.getLeaf("Bu09").revealCreatures(['Hydra'])
        aps.getLeaf("Bu09").addCreature("Wyvern")
        aps.check(); aps.printLeaves()
        turn = 74
        print "\nTurn", turn
        aps.getLeaf("Gd06").split(2, "Gd11", turn)
        aps.getLeaf("Br01").revealCreatures(['Titan'])
        aps.getLeaf("Br01").revealCreatures(['Serpent', 'Serpent', 'Serpent'])
        aps.getLeaf("Br01").addCreature("Guardian")
        aps.getLeaf("Bk02").revealCreatures(['Wyvern'])
        aps.getLeaf("Bk02").addCreature("Wyvern")
        aps.getLeaf("Gd06").revealCreatures(['Hydra'])
        aps.getLeaf("Gd06").addCreature("Griffon")
        aps.check(); aps.printLeaves()
        turn = 75
        print "\nTurn", turn
        aps.getLeaf("Br01").split(2, "Br05", turn)
        aps.getLeaf("Bu09").revealCreatures(['Griffon'])
        aps.getLeaf("Bu09").addCreature("Griffon")
        aps.getLeaf("Gd06").revealCreatures(['Griffon'])
        aps.getLeaf("Gd06").addCreature("Griffon")
        aps.getLeaf("Gd11").revealCreatures(['Wyvern'])
        aps.getLeaf("Gd11").addCreature("Wyvern")
        aps.getLeaf("Gd11").removeCreature("Wyvern")
        aps.getLeaf("Gd11").removeCreature("Wyvern")
        aps.getLeaf("Gd11").removeCreature("Wyvern")
        aps.getLeaf("Bk02").revealCreatures(['Wyvern'])
        aps.getLeaf("Bk02").addCreature("Wyvern")
        aps.getLeaf("Bk06").revealCreatures(['Griffon'])
        aps.getLeaf("Bk06").addCreature("Griffon")
        aps.check(); aps.printLeaves()
        turn = 77
        print "\nTurn", turn
        aps.getLeaf("Gd06").split(2, "Gd08", turn)
        aps.getLeaf("Gd03").revealCreatures(['Serpent', 'Serpent', 'Serpent'])
        aps.getLeaf("Gd03").addCreature("Guardian")
        aps.check(); aps.printLeaves()
        turn = 78
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd01", turn)
        aps.getLeaf("Bk10").revealCreatures(['Titan', 'Archangel', 'Angel', 
          'Angel', 'Angel', 'Warlock'])
        aps.getLeaf("Br01").revealCreatures(['Titan', 'Serpent', 'Serpent', 
          'Serpent', 'Serpent'])
        aps.getLeaf("Br01").removeCreature("Serpent")
        aps.getLeaf("Bk07").removeCreature("Angel")
        aps.getLeaf("Bk10").addCreature("Angel")
        aps.getLeaf("Br01").removeCreature("Serpent")
        aps.getLeaf("Br01").removeCreature("Serpent")
        aps.getLeaf("Bk10").removeCreature("Angel")
        aps.getLeaf("Br01").removeCreature("Titan")
        aps.getLeaf("Bk10").removeCreature("Archangel")
        aps.getLeaf("Br01").removeCreature("Serpent")
        aps.getLeaf("Br05").removeCreature("Guardian")
        aps.getLeaf("Br05").removeCreature("Guardian")
        aps.getLeaf("Bk10").revealCreatures(['Titan', 'Angel', 'Angel', 
          'Angel', 'Warlock'])
        aps.getLeaf("Bk10").addCreature("Archangel")
        aps.getLeaf("Bk10").addCreature("Angel")
        aps.getLeaf("Gd04").removeCreature("Guardian")
        aps.getLeaf("Gd04").removeCreature("Guardian")
        aps.check(); aps.printLeaves()
        turn = 79
        print "\nTurn", turn
        aps.getLeaf("Bk10").split(2, "Bk03", turn)
        aps.getLeaf("Gd01").removeCreature("Guardian")
        aps.getLeaf("Gd01").removeCreature("Behemoth")
        aps.getLeaf("Gd03").revealCreatures(['Serpent'])
        aps.getLeaf("Gd03").addCreature("Behemoth")
        aps.getLeaf("Gd08").revealCreatures(['Griffon'])
        aps.getLeaf("Gd08").addCreature("Griffon")
        aps.check(); aps.printLeaves()
        turn = 80
        print "\nTurn", turn
        aps.getLeaf("Bk02").split(2, "Gr11", turn)
        aps.getLeaf("Bk02").revealCreatures(['Guardian'])
        aps.getLeaf("Bk02").addCreature("Guardian")
        aps.getLeaf("Bu09").revealCreatures(['Griffon'])
        aps.getLeaf("Bu09").addCreature("Griffon")
        aps.getLeaf("Bk05").revealCreatures(['Giant'])
        aps.getLeaf("Bk05").addCreature("Giant")
        aps.getLeaf("Bk04").revealCreatures(['Wyvern', 'Wyvern', 'Wyvern'])
        aps.getLeaf("Bk04").addCreature("Guardian")
        aps.getLeaf("Bu09").revealCreatures(['Griffon'])
        aps.getLeaf("Bu09").addCreature("Griffon")
        aps.check(); aps.printLeaves()
        turn = 84
        print "\nTurn", turn
        aps.getLeaf("Bk05").split(2, "Gr06", turn)
        aps.getLeaf("Gd08").removeCreature("Griffon")
        aps.getLeaf("Gd08").removeCreature("Griffon")
        aps.getLeaf("Gd08").removeCreature("Griffon")
        aps.getLeaf("Bk04").addCreature("Angel")
        aps.getLeaf("Bu09").revealCreatures(['Griffon'])
        aps.getLeaf("Bu09").addCreature("Griffon")
        aps.check(); aps.printLeaves()
        turn = 87
        print "\nTurn", turn
        aps.getLeaf("Bu09").split(2, "Br07", turn)
        aps.getLeaf("Bk04").revealCreatures(['Guardian'])
        aps.getLeaf("Bk04").addCreature("Guardian")
        aps.getLeaf("Bk05").revealCreatures(['Giant', 'Giant'])
        aps.getLeaf("Bk05").addCreature("Colossus")
        aps.getLeaf("Bk08").revealCreatures(['Warbear', 'Warbear', 'Warbear'])
        aps.getLeaf("Bk08").addCreature("Guardian")
        aps.getLeaf("Bu09").revealCreatures(['Griffon', 'Griffon', 'Griffon'])
        aps.getLeaf("Bu09").addCreature("Guardian")
        aps.check(); aps.printLeaves()
        turn = 89
        print "\nTurn", turn
        aps.getLeaf("Bk08").split(2, "Gr09", turn)
        aps.getLeaf("Gd03").revealCreatures(['Serpent'])
        aps.getLeaf("Gd03").addCreature("Behemoth")
        aps.getLeaf("Br07").revealCreatures(['Griffon'])
        aps.getLeaf("Br07").addCreature("Griffon")
        aps.check(); aps.printLeaves()
        turn = 91
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd07", turn)
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd07"), turn)
        aps.getLeaf("Bk07").removeCreature("Warbear")
        aps.getLeaf("Bk07").removeCreature("Warbear")
        aps.getLeaf("Bk07").removeCreature("Warbear")
        aps.getLeaf("Bk07").removeCreature("Troll")
        aps.getLeaf("Bk07").removeCreature("Troll")
        aps.getLeaf("Bk08").revealCreatures(['Giant'])
        aps.getLeaf("Bk08").addCreature("Giant")
        aps.check(); aps.printLeaves()
        turn = 92
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd07", turn)
        aps.getLeaf("Gd03").merge(aps.getLeaf("Gd07"), turn)
        aps.check(); aps.printLeaves()
        turn = 93
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd10", turn)
        aps.getLeaf("Gd03").revealCreatures(['Serpent'])
        aps.getLeaf("Gd03").addCreature("Behemoth")
        aps.getLeaf("Gd02").removeCreature("Warlock")
        aps.getLeaf("Gd02").removeCreature("Warlock")
        aps.getLeaf("Gd06").revealCreatures(['Hydra'])
        aps.getLeaf("Gd06").addCreature("Griffon")
        aps.getLeaf("Gd10").removeCreature("Behemoth")
        aps.getLeaf("Gd10").removeCreature("Behemoth")
        aps.getLeaf("Gd06").revealCreatures(['Hydra', 'Hydra', 'Hydra', 
          'Hydra', 'Hydra', 'Griffon'])
        aps.getLeaf("Bk03").revealCreatures(['Angel', 'Warlock'])
        aps.getLeaf("Bk03").removeCreature("Angel")
        aps.getLeaf("Bk03").removeCreature("Warlock")
        aps.getLeaf("Gd06").revealCreatures(['Hydra', 'Hydra', 'Hydra', 
          'Hydra', 'Hydra', 'Griffon'])
        aps.getLeaf("Gd06").addCreature("Angel")
        aps.getLeaf("Bk05").revealCreatures(['Colossus'])
        aps.getLeaf("Bk05").addCreature("Colossus")
        aps.check(); aps.printLeaves()
        turn = 97
        print "\nTurn", turn
        aps.getLeaf("Gd06").split(2, "Gd09", turn)
        aps.getLeaf("Gd06").merge(aps.getLeaf("Gd09"), turn)
        aps.getLeaf("Bk01").removeCreature("Wyvern")
        aps.getLeaf("Bk01").removeCreature("Wyvern")
        aps.getLeaf("Bk01").removeCreature("Troll")
        aps.check(); aps.printLeaves()
        turn = 98
        print "\nTurn", turn
        aps.getLeaf("Gd06").split(2, "Gd02", turn)
        aps.getLeaf("Gd02").revealCreatures(['Griffon'])
        aps.getLeaf("Gd02").addCreature("Griffon")
        aps.check(); aps.printLeaves()
        turn = 99
        print "\nTurn", turn
        aps.getLeaf("Bk06").split(2, "Bk07", turn)
        aps.getLeaf("Bk06").revealCreatures(['Hydra', 'Hydra', 'Hydra', 
          'Angel', 'Wyvern'])
        aps.getLeaf("Gd02").revealCreatures(['Angel', 'Griffon', 'Griffon'])
        aps.getLeaf("Gd02").removeCreature("Griffon")
        aps.getLeaf("Gd02").removeCreature("Griffon")
        aps.getLeaf("Bk06").removeCreature("Angel")
        aps.getLeaf("Bk10").removeCreature("Archangel")
        aps.getLeaf("Bk06").addCreature("Archangel")
        aps.getLeaf("Gd02").removeCreature("Angel")
        aps.getLeaf("Bk06").revealCreatures(['Archangel', 'Hydra', 'Hydra', 
          'Hydra', 'Wyvern'])
        aps.getLeaf("Bk06").addCreature("Angel")
        aps.getLeaf("Bk02").revealCreatures(['Angel'])
        aps.getLeaf("Bk07").removeCreature("Griffon")
        aps.getLeaf("Bk07").removeCreature("Griffon")
        aps.getLeaf("Gd06").removeCreature("Hydra")
        aps.getLeaf("Gd06").removeCreature("Hydra")
        aps.getLeaf("Gd06").removeCreature("Hydra")
        aps.getLeaf("Gd06").removeCreature("Hydra")
        aps.getLeaf("Gd06").removeCreature("Hydra")
        aps.check(); aps.printLeaves()
        turn = 105
        print "\nTurn", turn
        aps.getLeaf("Bk05").split(2, "Bk03", turn)
        aps.getLeaf("Bk05").revealCreatures(['Colossus'])
        aps.getLeaf("Bk05").addCreature("Colossus")
        aps.getLeaf("Bk09").revealCreatures(['Warlock'])
        aps.getLeaf("Bk09").addCreature("Warlock")
        aps.getLeaf("Bk10").revealCreatures(['Titan'])
        aps.getLeaf("Bk10").addCreature("Warlock")
        aps.getLeaf("Gd03").revealCreatures(['Titan'])
        aps.getLeaf("Gd03").addCreature("Warlock")
        aps.getLeaf("Gr09").revealCreatures(['Warbear', 'Warbear'])
        aps.getLeaf("Gr09").addCreature("Giant")
        aps.check(); aps.printLeaves()
        turn = 107
        print "\nTurn", turn
        aps.getLeaf("Gd03").split(2, "Gd12", turn)
        aps.getLeaf("Bk10").revealCreatures(['Titan'])
        aps.getLeaf("Gd12").removeCreature("Behemoth")
        aps.getLeaf("Gd12").removeCreature("Warlock")
        aps.check(); aps.printLeaves()
        print "\ntest 9 ends"


    def testPredictSplits12(self):
        print '\ntest 12 begins'

        aps = AllPredictSplits()
        aps.printLeaves()

        turn = 1
        print '\nTurn', turn
        ps = PredictSplits('Gr', 'Gr07', ['Titan', 'Angel', 'Gargoyle', \
          'Gargoyle', 'Centaur', 'Centaur', 'Ogre', 'Ogre'])
        aps.append(ps)
        aps.getLeaf('Gr07').revealCreatures(['Titan', 'Angel', 'Gargoyle', \
          'Gargoyle', 'Centaur', 'Centaur', 'Ogre', 'Ogre'])
        ps = PredictSplits('Bu', 'Bu08', ['Titan', 'Angel', 'Gargoyle', \
          'Gargoyle', 'Centaur', 'Centaur', 'Ogre', 'Ogre'])
        aps.append(ps)
        aps.getLeaf('Bu08').revealCreatures(['Titan', 'Angel', 'Gargoyle', \
          'Gargoyle', 'Centaur', 'Centaur', 'Ogre', 'Ogre'])
        ps = PredictSplits('Gd', 'Gd01', ['Titan', 'Angel', 'Gargoyle', \
          'Gargoyle', 'Centaur', 'Centaur', 'Ogre', 'Ogre'])
        aps.append(ps)
        aps.getLeaf('Gd01').revealCreatures(['Titan', 'Angel', 'Gargoyle', \
          'Gargoyle', 'Centaur', 'Centaur', 'Ogre', 'Ogre'])
        ps = PredictSplits('Bk', 'Bk10', ['Titan', 'Angel', 'Gargoyle', \
          'Gargoyle', 'Centaur', 'Centaur', 'Ogre', 'Ogre'])
        aps.append(ps)
        aps.getLeaf('Bk10').revealCreatures(['Titan', 'Angel', 'Gargoyle', \
          'Gargoyle', 'Centaur', 'Centaur', 'Ogre', 'Ogre'])
        ps = PredictSplits('Br', 'Br12', ['Titan', 'Angel', 'Gargoyle', \
          'Gargoyle', 'Centaur', 'Centaur', 'Ogre', 'Ogre'])
        aps.append(ps)
        aps.getLeaf('Br12').revealCreatures(['Titan', 'Angel', 'Gargoyle', \
          'Gargoyle', 'Centaur', 'Centaur', 'Ogre', 'Ogre'])
        ps = PredictSplits('Rd', 'Rd12', ['Titan', 'Angel', 'Gargoyle', \
          'Gargoyle', 'Centaur', 'Centaur', 'Ogre', 'Ogre'])
        aps.append(ps)
        aps.getLeaf('Rd12').revealCreatures(['Titan', 'Angel', 'Gargoyle', \
          'Gargoyle', 'Centaur', 'Centaur', 'Ogre', 'Ogre'])
        aps.getLeaf('Gr07').split(4, 'Gr12', turn)
        aps.getLeaf('Gr07').revealCreatures(['Ogre', 'Ogre'])
        aps.getLeaf('Gr07').addCreature('Troll')
        aps.getLeaf('Gr12').revealCreatures(['Gargoyle', 'Gargoyle'])
        aps.getLeaf('Gr12').addCreature('Cyclops')
        aps.getLeaf('Bu08').split(4, 'Bu12', turn)
        aps.getLeaf('Bu08').revealCreatures(['Centaur'])
        aps.getLeaf('Bu08').addCreature('Centaur')
        aps.getLeaf('Bu12').revealCreatures(['Gargoyle', 'Gargoyle'])
        aps.getLeaf('Bu12').addCreature('Cyclops')
        aps.getLeaf('Gd01').split(4, 'Gd12', turn)
        aps.getLeaf('Gd01').revealCreatures(['Ogre', 'Ogre'])
        aps.getLeaf('Gd01').addCreature('Troll')
        aps.getLeaf('Gd12').revealCreatures(['Centaur'])
        aps.getLeaf('Gd12').addCreature('Centaur')
        aps.getLeaf('Bk10').split(4, 'Bk03', turn)
        aps.getLeaf('Bk03').revealCreatures(['Titan'])
        aps.getLeaf('Bk03').revealCreatures(['Gargoyle', 'Gargoyle'])
        aps.getLeaf('Bk03').addCreature('Cyclops')
        aps.getLeaf('Bk10').revealCreatures(['Centaur'])
        aps.getLeaf('Bk10').addCreature('Centaur')
        aps.getLeaf('Br12').split(4, 'Br07', turn)
        aps.getLeaf('Br07').revealCreatures(['Titan'])
        aps.getLeaf('Br07').revealCreatures(['Titan'])
        aps.getLeaf('Br07').addCreature('Warlock')
        aps.getLeaf('Br12').revealCreatures(['Ogre'])
        aps.getLeaf('Br12').addCreature('Ogre')
        aps.getLeaf('Rd12').split(4, 'Rd03', turn)
        aps.getLeaf('Rd12').revealCreatures(['Gargoyle'])
        aps.getLeaf('Rd12').addCreature('Gargoyle')
        aps.printLeaves()
        self.assertEqual(aps.getLeaf('Bk03').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Bk10').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Br07').numUncertainCreatures(), 3)
        self.assertEqual(aps.getLeaf('Br12').numUncertainCreatures(), 2)
        self.assertEqual(aps.getLeaf('Bu08').numUncertainCreatures(), 2)
        self.assertEqual(aps.getLeaf('Bu12').numUncertainCreatures(), 2)
        self.assertEqual(aps.getLeaf('Gd01').numUncertainCreatures(), 2)
        self.assertEqual(aps.getLeaf('Gd12').numUncertainCreatures(), 2)
        self.assertEqual(aps.getLeaf('Gr07').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Gr12').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Rd03').numUncertainCreatures(), 4)
        self.assertEqual(aps.getLeaf('Rd12').numUncertainCreatures(), 3)

        turn = 2
        print '\nTurn', turn
        aps.getLeaf('Gr07').revealCreatures(['Troll'])
        aps.getLeaf('Gr07').addCreature('Troll')
        aps.getLeaf('Gr12').revealCreatures(['Centaur'])
        aps.getLeaf('Gr12').addCreature('Centaur')
        aps.getLeaf('Gd01').revealCreatures(['Centaur'])
        aps.getLeaf('Gd01').addCreature('Centaur')
        aps.getLeaf('Gd12').revealCreatures(['Gargoyle', 'Gargoyle'])
        aps.getLeaf('Gd12').addCreature('Cyclops')
        aps.getLeaf('Br12').revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf('Br12').addCreature('Lion')
        aps.getLeaf('Rd12').revealCreatures(['Titan'])
        aps.getLeaf('Rd12').addCreature('Warlock')
        aps.getLeaf('Rd03').revealCreatures(['Ogre', 'Ogre'])
        aps.getLeaf('Rd03').addCreature('Troll')
        aps.printLeaves()
        self.assertEqual(aps.getLeaf('Bk03').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Bk10').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Br07').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Br12').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Bu08').numUncertainCreatures(), 2)
        self.assertEqual(aps.getLeaf('Bu12').numUncertainCreatures(), 2)
        self.assertEqual(aps.getLeaf('Gd01').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Gd12').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Gr07').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Gr12').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Rd03').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Rd12').numUncertainCreatures(), 1)

        turn = 3
        print '\nTurn', turn
        aps.getLeaf('Bu08').revealCreatures(['Ogre'])
        aps.getLeaf('Bu08').addCreature('Ogre')
        aps.getLeaf('Bu12').revealCreatures(['Centaur'])
        aps.getLeaf('Bu12').addCreature('Centaur')
        aps.getLeaf('Gd01').revealCreatures(['Ogre'])
        aps.getLeaf('Gd01').addCreature('Ogre')
        aps.getLeaf('Bk03').revealCreatures(['Cyclops'])
        aps.getLeaf('Bk03').addCreature('Cyclops')
        aps.getLeaf('Bk10').revealCreatures(['Ogre'])
        aps.getLeaf('Bk10').addCreature('Ogre')
        aps.getLeaf('Rd03').revealCreatures(['Gargoyle'])
        aps.getLeaf('Rd03').addCreature('Gargoyle')
        aps.getLeaf('Rd12').revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf('Rd12').addCreature('Lion')
        aps.printLeaves()
        self.assertEqual(aps.getLeaf('Bk03').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Bk10').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Br07').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Br12').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Bu08').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Bu12').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Gd01').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Gd12').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Gr07').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Gr12').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Rd03').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Rd12').numUncertainCreatures(), 0)

        turn = 4
        print '\nTurn', turn
        aps.getLeaf('Gr07').revealCreatures(['Troll'])
        aps.getLeaf('Gr07').addCreature('Troll')
        aps.getLeaf('Gr12').revealCreatures(['Cyclops'])
        aps.getLeaf('Gr12').addCreature('Cyclops')
        aps.getLeaf('Bu08').revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf('Bu08').addCreature('Lion')
        aps.getLeaf('Gd01').split(2, 'Gd07', turn)
        aps.getLeaf('Gd01').revealCreatures(['Troll'])
        aps.getLeaf('Gd01').addCreature('Troll')
        aps.getLeaf('Gd12').revealCreatures(['Cyclops'])
        aps.getLeaf('Gd12').addCreature('Cyclops')
        aps.getLeaf('Bk03').revealCreatures(['Cyclops'])
        aps.getLeaf('Bk03').addCreature('Cyclops')
        aps.getLeaf('Bk10').revealCreatures(['Ogre'])
        aps.getLeaf('Bk10').addCreature('Ogre')
        aps.getLeaf('Br12').revealCreatures(['Ogre', 'Ogre'])
        aps.getLeaf('Br12').addCreature('Troll')
        aps.getLeaf('Rd03').revealCreatures(['Troll'])
        aps.getLeaf('Rd03').addCreature('Troll')
        aps.printLeaves()
        self.assertEqual(aps.getLeaf('Bk03').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Bk10').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Br07').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Br12').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Bu08').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Bu12').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Gd01').numUncertainCreatures(), 3)
        self.assertEqual(aps.getLeaf('Gd07').numUncertainCreatures(), 2)
        self.assertEqual(aps.getLeaf('Gd12').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Gr07').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Gr12').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Rd03').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Rd12').numUncertainCreatures(), 0)

        turn = 5
        print '\nTurn', turn
        aps.getLeaf('Gr07').split(2, 'Gr05', turn)
        aps.getLeaf('Gr12').split(2, 'Gr10', turn)
        aps.getLeaf('Gr05').revealCreatures(['Ogre'])
        aps.getLeaf('Gr05').addCreature('Ogre')
        aps.getLeaf('Gr07').revealCreatures(['Troll', 'Troll'])
        aps.getLeaf('Gr07').addCreature('Ranger')
        aps.getLeaf('Bu08').split(2, 'Bu02', turn)
        aps.getLeaf('Bu08').revealCreatures(['Ogre', 'Ogre', 'Ogre'])
        aps.getLeaf('Bu08').addCreature('Minotaur')
        aps.getLeaf('Bu12').revealCreatures(['Centaur'])
        aps.getLeaf('Bu12').addCreature('Centaur')
        aps.getLeaf('Gd12').split(2, 'Gd11', turn)
        aps.getLeaf('Gd12').merge(aps.getLeaf('Gd11'), turn)
        aps.getLeaf('Gd07').revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf('Gd07').addCreature('Lion')
        aps.getLeaf('Bk03').split(2, 'Bk04', turn)
        aps.getLeaf('Bk10').split(2, 'Bk07', turn)
        aps.getLeaf('Bk10').merge(aps.getLeaf('Bk07'), turn)
        aps.getLeaf('Bk03').revealCreatures(['Ogre'])
        aps.getLeaf('Bk03').addCreature('Ogre')
        aps.getLeaf('Br12').split(2, 'Br10', turn)
        aps.getLeaf('Gr10').removeCreature('Gargoyle')
        aps.getLeaf('Gr10').removeCreature('Gargoyle')
        aps.getLeaf('Br07').revealCreatures(['Ogre'])
        aps.getLeaf('Br07').addCreature('Ogre')
        aps.getLeaf('Br12').revealCreatures(['Troll'])
        aps.getLeaf('Br12').addCreature('Troll')
        aps.getLeaf('Rd03').split(2, 'Rd04', turn)
        aps.getLeaf('Rd12').split(2, 'Rd10', turn)
        aps.getLeaf('Rd12').revealCreatures(['Gargoyle', 'Gargoyle'])
        aps.getLeaf('Rd12').addCreature('Cyclops')
        aps.printLeaves()
        self.assertEqual(aps.getLeaf('Bk03').numUncertainCreatures(), 3)
        self.assertEqual(aps.getLeaf('Bk04').numUncertainCreatures(), 2)
        self.assertEqual(aps.getLeaf('Bk10').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Br07').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Br10').numUncertainCreatures(), 2)
        self.assertEqual(aps.getLeaf('Br12').numUncertainCreatures(), 4)
        self.assertEqual(aps.getLeaf('Bu02').numUncertainCreatures(), 2)
        self.assertEqual(aps.getLeaf('Bu08').numUncertainCreatures(), 2)
        self.assertEqual(aps.getLeaf('Bu12').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Gd01').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Gd07').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Gd12').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Gr05').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Gr07').numUncertainCreatures(), 3)
        self.assertEqual(aps.getLeaf('Gr12').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Rd03').numUncertainCreatures(), 5)
        self.assertEqual(aps.getLeaf('Rd04').numUncertainCreatures(), 2)
        self.assertEqual(aps.getLeaf('Rd10').numUncertainCreatures(), 2)
        self.assertEqual(aps.getLeaf('Rd12').numUncertainCreatures(), 3)

        turn = 6
        print '\nTurn', turn
        aps.getLeaf('Bk04').removeCreature('Gargoyle')
        aps.getLeaf('Bk04').removeCreature('Gargoyle')
        aps.getLeaf('Gr05').revealCreatures(['Ogre', 'Ogre', 'Ogre'])
        aps.getLeaf('Rd10').revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf('Rd10').removeCreature('Centaur')
        aps.getLeaf('Gr07').removeCreature('Angel')
        aps.getLeaf('Gr05').addCreature('Angel')
        aps.getLeaf('Rd10').removeCreature('Centaur')
        aps.getLeaf('Gr05').removeCreature('Ogre')
        aps.getLeaf('Gr05').revealCreatures(['Angel', 'Ogre', 'Ogre'])
        aps.getLeaf('Gr07').revealCreatures(['Ranger'])
        aps.getLeaf('Gr07').addCreature('Ranger')
        aps.getLeaf('Gr12').revealCreatures(['Centaur', 'Centaur'])
        aps.getLeaf('Gr12').addCreature('Lion')
        aps.getLeaf('Bu12').split(2, 'Bu11', turn)
        aps.getLeaf('Bu12').revealCreatures(['Titan', 'Cyclops', 'Centaur', \
          'Centaur', 'Centaur'])
        aps.getLeaf('Gd07').revealCreatures(['Lion', 'Centaur', 'Centaur'])
        aps.getLeaf('Gd07').removeCreature('Centaur')
        aps.getLeaf('Bu12').removeCreature('Centaur')
        aps.getLeaf('Bu08').removeCreature('Angel')
        aps.getLeaf('Bu12').addCreature('Angel')
        aps.getLeaf('Bu12').removeCreature('Centaur')
        aps.getLeaf('Gd07').removeCreature('Lion')
        aps.getLeaf('Gd07').removeCreature('Centaur')
        aps.getLeaf('Bu12').revealCreatures(['Titan', 'Angel', 'Cyclops', \
          'Centaur'])
        aps.getLeaf('Bu12').revealCreatures(['Centaur'])
        aps.getLeaf('Bu12').addCreature('Centaur')
        aps.getLeaf('Gd12').split(2, 'Gd11', turn)
        aps.getLeaf('Gd12').merge(aps.getLeaf('Gd11'), turn)
        aps.getLeaf('Gd01').revealCreatures(['Angel', 'Troll', 'Troll', \
          'Ogre', 'Ogre', 'Ogre'])
        aps.getLeaf('Rd03').revealCreatures(['Angel', 'Troll', 'Troll', \
          'Gargoyle', 'Gargoyle'])
        aps.getLeaf('Rd03').removeCreature('Troll')
        aps.getLeaf('Gd01').removeCreature('Angel')
        aps.getLeaf('Rd03').removeCreature('Gargoyle')
        aps.getLeaf('Gd01').removeCreature('Ogre')
        aps.getLeaf('Rd03').removeCreature('Gargoyle')
        aps.getLeaf('Gd01').removeCreature('Troll')
        aps.getLeaf('Rd03').revealCreatures(['Troll'])
        aps.getLeaf('Rd03').addCreature('Troll')
        aps.getLeaf('Gd01').removeCreature('Troll')
        aps.getLeaf('Gd01').removeCreature('Ogre')
        aps.getLeaf('Rd03').removeCreature('Angel')
        aps.getLeaf('Gd01').removeCreature('Ogre')
        aps.getLeaf('Rd03').revealCreatures(['Troll', 'Troll'])
        aps.getLeaf('Bk10').split(2, 'Bk01', turn)
        aps.getLeaf('Br07').revealCreatures(['Ogre', 'Ogre'])
        aps.getLeaf('Br07').addCreature('Troll')
        aps.printLeaves()
        self.assertEqual(aps.getLeaf('Bk01').numUncertainCreatures(), 2)
        self.assertEqual(aps.getLeaf('Bk03').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Bk10').numUncertainCreatures(), 3)
        self.assertEqual(aps.getLeaf('Br07').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Br10').numUncertainCreatures(), 2)
        self.assertEqual(aps.getLeaf('Br12').numUncertainCreatures(), 4)
        self.assertEqual(aps.getLeaf('Bu02').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Bu08').numUncertainCreatures(), 1)
        self.assertEqual(aps.getLeaf('Bu11').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Bu12').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Gd12').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Gr05').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Gr07').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Gr12').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Rd03').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Rd04').numUncertainCreatures(), 0)
        self.assertEqual(aps.getLeaf('Rd12').numUncertainCreatures(), 0)

        print '\ntest 12 ends'

if __name__ == "__main__":
    unittest.main()
