/***************************************************/
/* REXX Procedure to perform incremental backups   */
/***************************************************/
'@ECHO OFF'
av = 'YES'                /* AutoVerify = YES | NO */

/***************************************************/
/* Extract the date in mm/dd/yy format             */
/***************************************************/
rundate = Date('U')

/***************************************************/
/* Initialize REXXUtil environment (if not present)*/
/***************************************************/
rxload = RxFuncQuery('SysLoadFuncs')
If rxload Then
   Do
      Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
      Call sysloadfuncs
   End

/***************************************************/
/* Extract the drives available on the system      */
/***************************************************/
drives = SysDriveMap('C:', 'LOCAL')

/***************************************************/
/* Load number of drives into table root           */
/***************************************************/
drive.0 = Words(drives)

/***************************************************/
/* Load the table with the available drive letters */
/***************************************************/
Do x=1 To drive.0 By 1
   drive.x = Word(drives, x)
End

/***************************************************/
/* Build the list of FAT and HPFS drives to be     */
/* backed up.  Add each drive to the list only if  */
/* there are files on the drive with their archive */
/* bit set.                                        */
/***************************************************/
drive_string = ''
Do x=1 To drive.0 By 1
   filesys = FileType(drive.x)
   If filesys = 'HPFS' | filesys = 'FAT' Then
      Do
         rc = SysFileTree(drive.x || '*.*', 'files', 'SO', '+****')
         If files.0 > 0 Then
            Do
               Call Verify
               If result Then
                  drive_string = drive_string || ,
                                 Strip(drive.x, 'T', ':') || ,
                                 ','
            End
      End
End

/***************************************************/
/* Strip the trailing comma off of the drive list. */
/* Run the incremental backup only if there are    */
/* partitions that require backing up.             */
/***************************************************/
drive_string = Strip(drive_string, 'T', ',')
If drive_string \= '' Then
   'START /MIN BACKMAST /D:' || ,
                        drive_string '/BI:"INCR:' ,
                        rundate || ,
                        '" /AV:' || av

/***************************************************/
/* All done, end processing.                       */
/***************************************************/
If rxload Then
   Call SysDropFuncs
Exit

/***************************************************/
/* Verify whether or not an incremental is required*/
/***************************************************/
Verify:
   bkup = 0
   Do y=1 to files.0 By 1
      fn = Filespec('N', files.y)
      Select
         When Translate(fn) = 'EA DATA. SF' Then
            Nop
         When Translate(fn) = 'WP ROOT. SF' Then
            Nop
         When Translate(fn) = 'SWAPPER.DAT' Then
            Nop
         Otherwise
            bkup = 1
      End
      If bkup Then Leave y
   End
Return bkup
