; tkt.asm -- trivial keyboard tamer for DOS programs running under OS/2 2.0+
; version 0.1   17-jul-2001
; author: Pieter Bras
;	  Cambridge, MA (USA)
;	  pieter@world.std.com

COMMENT	@	COPYRIGHT NOTICE AND USER LICENSE

Copyright (C) 2001, Pieter Bras

This program is copyrighted freeware.  It may be freely used and distributed,
provided: that this Copyright Notice and User License remains unaltered, and
provided: that no charge be made for distributing this software.

This software comes without warranty.  The author disavows responsibility for
any problems that may arise from its installation/use.

This DOS program installs itself as a TSR and will prevent other DOS programs
that poll the keyboard from hogging the CPU, when running under OS/2 versions
2.0 and later.  It may be run from within a batch file such as AUTOEXEC.BAT,
or from the command line.  It will attempt to determine if it has already
been installed, and if so, will avoid installing itself multiple times.
Once installed, the program can be commanded to uninstall itself.

The program operates by intercepting INT 16h calls (BIOS keyboard service)
that request keyboard status (functions AH = 01h and 11h) and yielding the
rest of the time slice to OS/2.  This is sufficient to prevent many (but not
all!) DOS programs from hogging the CPU.

WARNING: some programs, for instance poorly-written DOS comm programs, may
suffer degraded performance if this TSR is installed.

Usage:
	TKT				installs the TSR
	TKT U				uninstalls the TSR (if installed)

The option character is case-insensitive: either U or u will work.
NOTE: there should be exactly one space preceding the option character.

ENDCOMMENT @
;
	IDEAL				; requires Borland Turbo Assembler
	P386				; allow 80386 instructions
	MODEL	TINY
	SEGMENT	PROG
;
	ORG	80h
LABEL	cmdbuf	BYTE
;
	ASSUME	CS:PROG, DS:NOTHING, SS:NOTHING, ES:NOTHING
	ORG     100h
start:
	jmp	init
;
; new int 16h handler (resident)
;
	EVEN
author	db	'pgwb'			; author's signature
LABEL	pyield	WORD			; offset of timeslice yield routine
	dw	0
LABEL	old16v	DWORD			; saved int 16h vector
LABEL	old16o	WORD			; old vector: offset
	dw	0
LABEL	old16s	WORD			; old vector: segment
	dw	0
;
new16:
	pushf				; save everything on caller's stack
	pusha
	cmp	ah, 01h			; 01h: report whether character ready
	je	yield
	cmp	ah, 11h			; 11h: get extended keystroke status
	jne	chain
yield:
	call	[cs:pyield]		; yield current timeslice
;
; chain to old handler
chain:
	popa				; restore caller's state
	popf
	jmp	[cs:old16v]

; timeslice yield routine for OS/2 2.1 and later versions
warpyield:
	mov     ax, 1			; dx:ax = milliseconds to yield
	cwd				; NOTE: 0:0 doesn't work properly
	sti                             ; enable interrupts
	hlt				; OS/2 will trap this
	db      35h, 0CAh		; DosSleep signature for OS/2 (2.1+)
	ret

; timeslice yield routine for Win 3.x and OS/2 2.0
winyield:
	mov	ax, 1680h
	int	2Fh
	ret
;
; initialization code (transient)
;
	ASSUME	CS:PROG, DS:PROG, SS:PROG, ES:NOTHING
init:
	mov	sp, OFFSET mystack
; look for option character
	mov	al, [cmdbuf]		; length of command tail
	cmp	al, 2
	jb	saveold
	mov	al, [cmdbuf+2]		; get possible option character
	or	al, 20h			; convert to lowercase
	mov	[option], al
; save old interrupt 16h vector
saveold:
	mov	ax,3516h		; get interrupt vector 16h
	int	21h
	mov	ax, es
	mov	[old16s], ax
	mov	[old16o], bx
; see if we're already installed
	cmp	bx, OFFSET new16	; look for same offset
	jne	notyet
	mov	eax, [DWORD es:author]	; look for same signature
	cmp	eax, [DWORD author]
	jne	notyet
;
; already installed
	mov	dx, OFFSET msg4		; msg: "already resident"
	mov	al, [option]
	cmp	al, 'u'
	jne	quit
; uninstall interrupt 16h vector
	push	ds
	lds	dx,[es:old16v]		; ds:dx = old vector
	mov	ax, 2516h		; set interrupt vector 16h
	int	21h
	pop	ds
	mov	dx, OFFSET msg2		; msg: "successfully uninstalled"
quit:
	mov	ah, 09h			; display ASCII message at [dx]
	int	21h
	mov	ax, 4C00h		; terminate, return code = 0
	int	21h
;
; not already installed
notyet:
	mov	dx, OFFSET msg5		; msg: "not resident"
	mov	al, [option]
	cmp	al, 'u'
	je	quit
; identify multitasking environment
	mov	ah, 30h			; get DOS version
	int	21h
	mov	dx, OFFSET msg3		; msg: "not OS/2"
	cmp     al, 20
	jb	quit			; not OS/2 2.0+ if major version < 20
	mov	bx, OFFSET winyield
	cmp	ah, 10
	jb	setup			; OS/2 2.0 if minor version < 10
	mov	bx, OFFSET warpyield
setup:
	mov	[pyield], bx
; install new interrupt 16h vector
	mov	dx, OFFSET new16	; ds:dx = new vector
	mov	ax, 2516h		; set interrupt vector 16h
	int	21h
	mov	dx, OFFSET msg1		; msg: "successfully installed"
	mov	ah, 09h
	int	21h
; terminate & stay resident
	mov	dx, OFFSET init+10h
        shr	dx, 4			; dx = paragraphs to keep
	mov	ax, 3100h		; TSR, return code = 0
	int	21h
;
CR	=	0Ah
LF	=	0Dh
msg1	db	'TKT installed successfully.', CR, LF, '$'
msg2	db	'TKT uninstalled successfully.', CR, LF, '$'
msg3	db	'TKT requires OS/2 2.0 or higher: not installed.', CR, LF, '$'
msg4	db	'TKT already resident: not installed again.', CR, LF, '$'
msg5	db	'TKT not resident: can''t uninstall.', CR, LF, '$'
;
LABEL	option	BYTE
	db	0
	EVEN
	dw	100h dup (?)
mystack	dw	?
;
	ENDS	PROG
        END	start
; <eof>
