package net.sf.colossus.client;


/**
 *  Basic information about one creature, for split prediction.
 *  @version $Id: CreatureInfo.java,v 1.6 2004/02/29 04:47:19 dripton Exp $
 *  @author David Ripton
 */
class CreatureInfo implements Cloneable
{
    private final String name;

    // Are we sure this creature is in this legion?
    private boolean certain;

    // Was the creature here when this legion was split off?
    private boolean atSplit;

    CreatureInfo(String name, boolean certain, boolean atSplit)
    {
        if (name.startsWith("Titan"))
        {
            name = "Titan";
        }
        else if (name.length() == 0)
        {
            throw new RuntimeException("CreatureInfo with empty name!");
        }
        this.name = name;
        this.certain = certain;
        this.atSplit = atSplit;
    }

    final String getName()
    {
        return name;
    }

    void setCertain(boolean certain)
    {
        this.certain = certain;
    }

    boolean isCertain()
    {
        return certain;
    }

    void setAtSplit(boolean atSplit)
    {
        this.atSplit = atSplit;
    }

    boolean isAtSplit()
    {
        return atSplit;
    }

    public Object clone()
    {
        return new CreatureInfo(name, certain, atSplit);
    }

    /** Two CreatureInfo objects match if the names match. */
    public boolean equals(Object other)
    {
        if (!(other instanceof CreatureInfo))
        {
            throw new ClassCastException();
        }
        return name.equals(((CreatureInfo)other).name);
    }

    /** Two CreatureInfo objects match if the names match. */
    public int hashCode()
    {
        return name.hashCode();
    }

    public String toString()
    {
        StringBuffer sb = new StringBuffer(name);
        if (!certain)
        {
            sb.append('?');
        }
        if (!atSplit)
        {
            sb.append('*');
        }
        return sb.toString();
    }
}
