@ECHO OFF

IF %1. == . goto USAGE

SET TAPEDIR="%TEMP%\TAR.DIR"
SET LOGFILE="%TEMP%\TAR.LOG"
SET GTAKLOG="%GTAKDIR%\Log\Log Set #%1"

echo Initializing Tape
del %LOGFILE% >NUL 2>NUL
del %TAPEDIR% >NUL 2>NUL

echo ######################### >> %LOGFILE% 
echo Backup Komplett - Set #%1 >> %LOGFILE%
echo Begin: >> %LOGFILE%
dates echo `6###, `5##.`3##.`1####, `A##:`B##:`C## >> %LOGFILE% 2>NUL
echo ######################### >> %LOGFILE% 

tape stat >NUL 2>NUL
tape blocksize 0 stat eraseq tell >> %LOGFILE% 2>&1

REM *** Backup ***
echo Backup in progress
echo Backup Log >> %LOGFILE%
tar %2 %3 -cppP @c:\gtak\gbackup.inc -V "HEINRICH SET #%1" --totals --exclude-from c:\gtak\gbackup.exc -D %TAPEDIR% >> %LOGFILE% 2>&1
tape stat >> %LOGFILE% 2>&1

REM *** Compare ***
echo Compare in progress
echo Compare Log >> %LOGFILE%
tape rew >NUL 2>NUL
tar %2 %3 -dppP --acl >> %LOGFILE% 2>&1
tape stat >> %LOGFILE% 2>&1

REM *** Append Index ***
echo Writing table of contents
echo Writing table of contents >> %LOGFILE%
tar -cvppP %TAPEDIR% >> %LOGFILE% 2>&1
tape stat >> %LOGFILE% 2>&1

echo ######################### >> %LOGFILE% 
echo Backup Komplett - Set #%1 >> %LOGFILE%
echo Completed: >> %LOGFILE%
dates echo `6###, `5##.`3##.`1####, `A##:`B##:`C## >> %LOGFILE% 2>NUL
echo ######################### >> %LOGFILE% 
echo Writing Log to tape
tar -cvppP %LOGFILE% >NUL 2>&1

copy %LOGFILE% %GTAKLOG% >NUL 2>NUL
del %TAPEDIR% >NUL 2>NUL
del %LOGFILE% 

echo Unloading tape
tape unload >NUL 2>&1
echo Completed

goto OUT:
:USAGE
echo Usage gbackup [Set]; eg: SAVELIVA 2
:OUT