// LList object
// Class to implement linked lists where each node points to a data
// object.  The programmer is responsible for knowing what kind of
// data will reside at the end of the LL_Data pointer.

#include "stdio.h"
#include "stdlib.h"
#include "conio.h"
#include "string.h"

#define DEBUG 1

#ifndef LLIST_DEF
#define LLIST_DEF

class LLNode;

class LLNode{
  public:
//  LLNode *Next;   // Next node in list.
//  LLNode *Prev;   // Previous node in list.
  LLNode* Next;   // Next node in list.
  LLNode* Prev;   // Previous node in list.
  void* Data;   // Pointer to the data object.
};

// These defines are used to determine if the added node will be before
//   or after the current node.  Default is After.
#define LL_ADD_AFTER  0
#define LL_ADD_BEFORE 1
#define LL_DATA 0
#define LL_NEXT 1   // Used by both Remove and Retrieve
#define LL_PREV 2
#define LL_HEAD 3
#define LL_NUM_NODES 4


#ifndef NULL
#define NULL 0
#endif

#define TRUE  1
#define FALSE 0

class LList{
  public:
  LList();        // Creates itself, at sets it LL_Head ptr to NULL.
  ~LList();       // Runs backwards through the list deleting the
                  //   nodes.  This will be long unless the programmer
                  //   deletes it's own nodes.
  private:
  LLNode *LL_Head;   // Points to the head of the list.
  LLNode *LL_Cur;    // Points to the current member of the list
  LLNode *LL_temp;   // For holding temp values.

  public:
  int  NumNodes;
  int  AtEnd;
  void Add(void *Data,
         int BorF);  //Instructs the List to create a new node at the
                     //   LL_Cur position and assign it the data at
                     //   the pointer supplied.  (Which may be NULL)
  void Remove(int GoWhere);   // The List will give the node pointed to by
                     //   LL_Prev its value Next and be deallocated.
  void Assign(void *Data);  // Make Cur->Data = the new Data value.
  void *Retrieve(int GetWhat);     // Returns Cur->Data pointer for LL_CUR.
                                   // Returns Cur->Next pointer for LL_NEXT.
                                   // Returns Cur->Prev pointer for LL_PREV.
                                   // Returns &NumNodes for LL_NUM_NODES.
                                   //  (Just NumNodes would have been nicer, but didn't fit)
  void Next(void);     // Cur = the Nodes value for Next
  void Prev(void);     // Cur = the Nodes value for Prev
  void Restart(void);  // Cur = Head
};

#endif





