// CObjectInfo
// This is the method definition file for the Object Information class.

#include "oi.h"

#define ON  1
#define OFF 0

#define TRUE  1
#define FALSE 0


CObjectInfo::CObjectInfo(void)
{
  OLOC=0;
  ONUMC=0;
  OMTHD=0;
  strcpy(ObjectName,"");
}

void CObjectInfo::AddFile(char *filename)
{
  FN *temp;

  Add(new FN,LL_ADD_AFTER);
  Next();
  temp=(FN*)Retrieve(LL_DATA);
  strcpy(temp->FileName,filename);
}

int  CObjectInfo::Count_OLOC(void)
{
  FILE *input;                    // Source file, stream pointer
  char file[35];
  char opnfile[60];
  FN   *temp;

  char line[120];                 // A single line from the program.
  char *chr;                      // Points to a particular character
  int  LOC=0;                     // Lines of code found so far
  int  NUMC=0;                    // Number of comment lines.
  char PrevChr;                   // Holds last non-white space character
  int  PDepth=0;                  // Current paranthesis depth
  int  Error=0;                   // If 1 then an error was encountered.
  int  CMode=0;                   // If 1 then the code is in a multi-line comment.
  char FirstChr;                  // First non-Whitespace char on line.
  int  GotFirst;                  // Flag for wether or not you've got the first chr.
  int  quote=OFF;                 // Flag for string constants.
  int  brkt=0;                    // Bracket depth.
  char qtype=' ';                 // is it a " or a ' ?

				  // Attempt to open source file.

  Restart();

  do{

    temp=(FN*)Retrieve(LL_DATA);
    strcpy(opnfile,temp->FileName);

    if (NULL==(input=fopen(opnfile,"rt"))){
      printf("Unable to open input file: %s\n", temp->FileName);
      printf("File was accessable and now is not.  Program aborts.\n");
      exit(1);                      // Abort program
    }

    LOC=0;
    NUMC=0;
    brkt=0;
    PDepth=0;
    while (!feof(input)){           // While more lines of code to process.
      fgets(line,120,input);        // Get a line of code into 'line'
      chr=line;                     // Point at the start of line.
      FirstChr=NULL;
      GotFirst=0;

      while (*chr!='\n'){           // While !EOLN
	if(!CMode){                 // If not in a comment.
	  switch (*chr){            // Decide what token to process.
	    case ';':               // Process ;s
		 if (PrevChr!='}' && PrevChr!=';'){
		   ++LOC;           // Counts as a valid line of code.
		 }
		 break;
	    case '{':               // Process {s
		 if (quote==OFF){
		   ++LOC;             // Counts as a valid line of code.
		   ++brkt;
		 }
		 break;
	    case '}':
		 if (quote==OFF){
		   --brkt;
		 }
		 break;
	    case '(':               // Process (
		 if (quote==OFF){
		   if (PDepth>0){     // Determines if it's valid.
		     ++LOC;           // Counts as a valid line of code.
		   }
		   ++PDepth;
		 }
		 break;             // Keep track of depth.
	    case ')':
		 if (quote==OFF){
		   --PDepth;          // Decriment the ( depth.
		   if(PDepth<0){
		     PDepth=0;
//                     Error=1;         // Should never happen with valid code.
		   }
		 }
		 break;
	    case '"':
		 if (qtype=='"' || qtype==' '){
		   if (quote==ON){    // If in a " string this must be the end of it.
		     quote=OFF;       //   so turn off the " flag.
		     qtype=' ';
		   }
		   else{
		     quote=ON;        // else, this is the begining of the quote.
		     qtype='"';
		   }
		 }
		 break;
	    case '\'':
		 if (qtype=='\'' || qtype==' '){
		   if (quote==ON){    // If in a ' string this must be the end of it.
		     quote=OFF;       //   so turn off the ' flag.
		     qtype=' ';
		   }
		   else{
		     quote=ON;        // else, this is the begining of the quote.
		     qtype='\'';
		   }
		 }
		 break;
	    case '#':               // Handle the #
		 if (FirstChr==NULL){
		   ++LOC;           // if # is first thing on line ++LOC
		 }
	    case '/':               // Handle the coming comment.
		 if (quote==OFF){   // If not in a quote.
		   if (*(chr+1)=='/'){// Single line comment.
		     ++NUMC;          // Count as a comment line.
		     *(chr+1)='\n';   // Force end of line.
		   }
		   else if (*(chr+1)=='*'){
		     CMode=1;         // Change to multiline comment mode.
		   }
		 }
		 break;
	    case ':':
		 if (quote==OFF && brkt==0){     // If not in quotes
		   if (PrevChr==':'){ // And a :: then it's a method define.
		     ++OMTHD;         // Incr # methods in object.
		   }
		 }
		 break;
	  }
	}
	if (CMode){                 // If in a multi-line comment.
	  ++NUMC;                   // Count this as a comment line.
	  if (NULL!=strstr(chr,"*/")){
	    chr=strstr(chr,"*/");   // Find possible end of comment.
	    CMode=0;                // End multi-line comment processing.
	  }
	  else {                    // Goto end of line.
	    *(chr+1)='\n';          // Force end of line.
	  }
	}
	if (0==strchr("\n\r\t ",*chr)){
	  PrevChr=*chr;             // PrevChr = last non-whitespace character
	  if (!GotFirst){
	    FirstChr=PrevChr;
	    GotFirst=1;
	  }
	}
	++chr;                      // increment character pointer.
      }
    }

				  // Add to the sum of object lines of code.
    OLOC+=LOC;
    ONUMC+=NUMC;

    if (Error || PDepth>0 || brkt>0 ){
      printf("An error was detected in your source code.\n");
      printf("  You may want to ensure that it compiles properly.\n");
    }

    fclose(input);
    Next();

  } while(AtEnd == FALSE);
  return(OLOC);
}


void CObjectInfo::Print_OLOC(FILE *out)
{

  fprintf(out,"%-15s Methods= %3d LOC= %6d Comments= %6d CMNTS/LOC= %f\n",
          ObjectName,
          OMTHD,
	  OLOC,
          ONUMC,
          (float)ONUMC/(float)OLOC);
}

char *CObjectInfo::WhatIsYourName(void)
{
  return ObjectName;
}

void CObjectInfo::YourNameIs(char *name)
{
  strcpy(ObjectName,name);
}

