// RangeFinder
//  RangeFinder method definitions

#include "rfind.h"


RangeFinder::RangeFinder(void)
{
  NumValues=0;
  StdDev=0;
  Average=0;
  Range=0;
  UPI=0;
  LPI=0;

}

void RangeFinder::CalcStdDev(void)
{
  double sum=0;
  double ave_sum=0;
  double holding=0;
  DataPoint *temp;



  Restart();
  NumValues=*(int *)(Retrieve(LL_NUM_NODES));

  do{
    temp=(DataPoint*)Retrieve(LL_DATA);

    holding=temp->y - B0 - (B1*temp->x);
    sum+=(holding * holding);
    ave_sum+=temp->x;

    Next();
  } while (AtEnd == FALSE);       // Count objects until out of objects

  Average=ave_sum/NumValues;      // Save the average for later use.

  sum*=(1/(NumValues-2));         // Make the variance.

  StdDev=sqrt(sum);               // Make the StdDev.
}

void RangeFinder::CalcRange(double percent, char *filename, double cur_estimate)
{
  double desired_area=0;          // Desired answer from simpsons.
  double found_area=0;            // Area found in last integration.
  double cur_guess_r=3.2;         // 3.2 > than table value for .95 with n=3
  double cur_guess_l=0;           // cur_guess'es are the bounds for the search.
  double guess=0;                 // current guess for integration
  double sum=0;                   // For the summation.
  double thingy=0;                // Thing to the left of the other two things.  (Yeah, OK.)
  double holding;                 // temporary value.

  DataPoint *temp;

  AddFile(filename);              // Then add the file requested.

  CalcLR();                       // Then figure out the LR parameters.

  CalcStdDev();                   // Then figure out the StdDev

  SetN(NumValues - 2);            // Set the nuber for T distribution.

                                  // Finds the value we want returned from T dist.
  desired_area+=(100-percent)/2;  //Hmmmm  Seems odd.
  desired_area=(1-(desired_area * .01));

                                  // Now calculate the right hand thingy.
                                  // First to the summation.
  do{
    temp=(DataPoint*)Retrieve(LL_DATA);

    holding=(temp->x - Average);
    sum+=(holding * holding);

    Next();
  } while (AtEnd == FALSE);       // Count objects until out of objects

  thingy=1 + (1/NumValues) + ((cur_estimate-Average)*(cur_estimate-Average))/sum;
  thingy=sqrt(thingy);            // Thingy calculated.

  while(.00005 < fabs(found_area - desired_area)){
    guess=cur_guess_l + ((cur_guess_r - cur_guess_l)/2);
                                  // Integrate from -INF to guess on CTD curve.
    found_area=DoMath(INFINITY,guess,1);
    if(found_area>desired_area) cur_guess_r=guess;
    if(found_area<desired_area) cur_guess_l=guess;
  }

                                  // My favorite line of code:

  Range = guess * StdDev * thingy;// Yes, I'm a programmer.

  PLOC=B0 + (B1 * cur_estimate);

  UPI = PLOC + Range;             // Upper calculation.
  LPI = PLOC - Range;             // Lower calculation.
  if (LPI<1) LPI=1;               // Range checking.
}


