// RangeFinder
//  Rangefinder header file which will find the ranges around a guess


#include "CTD.h"                  // Needed for t distribution.
#include "LRSet.h"                // Needed for linear regression

class RangeFinder : public LRSet, public CTD
{
  public:
  RangeFinder(void);              // std. const.

                                  // Main workhorse method.
  void   CalcRange(double percent, char *filename, double cur_estimate);
                                  // Finds the std. deviation from the list.
  void   CalcStdDev(void);

  double NumValues;               // Number of data values.
  double StdDev;                  // StdDev found in above method.
  double Average;                 // Average value.
  double Range;                   // Range found in CalcRange.
  double UPI;                     // Upper Program Interval
  double LPI;                     // Lower Program Interval
  double PLOC;                    // Projected Lines Of Code
};
