/********************************************************************************
**                      SOFTWARE INSTALLER
** 5621-434 (C) COPYRIGHT IBM CORP. 1991, 1993. ALL RIGHTS RESERVED.
**             LICENSED MATERIALS - PROPERTY OF IBM
*********************************************************************************
**
** WWREINST.CMD  Delete history information saved by Software Installer for OS/2.
**
********************************************************************************/

trace 'o'
parse arg INIDir',' Name',' Number',' Feature
If RxFuncQuery('REXXUTIL') <> 0 Then Do
If RxFuncAdd('SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs') = 0 Then Call sysloadfuncs
call rxfuncadd sysini, rexxutil, sysini

/* Remove leading/trailing spaces */
INIDir  = strip(INIDir)
Name    = strip(Name)
Number  = strip(Number)
Feature = strip(Feature)

if Name  = ''
  then
  Name    = 'Open Shutter version 1.14 DEMO'

if Number = ''
  then
  Number  = '56507-51663'

if Feature = ''
  then
  Feature = 'DEMO'

if INIDir  = ''
  then
   INI = GetININame()
  else do
  /* Build the fully-qualified INI name */
   if right(INIDir, 1) = '\'
   then INI = INIDir||'epfis.ini'
   else INI = INIDir||'\epfis.ini'
  end


/* Create the application key */
App = 'EPFINST_'Name'_'Number'_'Feature

/* Delete all application keys            */
/* The return code is purposely ignored   */
/* as SysINI() doesn't return it properly */
rc = SysIni(INI, App, 'DELETE:')

if rc = ''
  then do
   say
   say 'All records have been deleted:'
   say '   From:   ' INI
   say '   Name:   ' Name
   say '   Number: ' Number
   say '   Feature:' Feature
   say
   end
 else
   say 'WWREINST failed ' rc

/* Drop the SysIni function */
call rxfuncdrop sysini

exit
GetININame:
/* This function determines where the EPFIS.INI file is located */
drive_map = SysDriveMap('C','LOCAL')
Do i = 1 to words(drive_map)
   garbage. = ''
   rc = SysFileTree(word(drive_map,i),'garbage','DSO')
   If rc = 0 Then Do
      new_junk. = ''
      Do j = 1 to garbage.0
         rc = SysFileTree(garbage.j'\EPFIS.INI','new_junk','FO')
         If new_junk.1 <> '' Then Do
            coder = new_junk.1
            Leave i
         End
      End
   End
End

Return coder


