/****************************************************************/
/*             Creation of Accounts desktop folder              */
/****************************************************************/

/* Register with REXX API extensions. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
CreateCollision = 'Update'
Call CreateObjects
Exit

CreateObject: procedure
    Parse Arg Class, Title, Location, Setup, Collision
    Say 'Creating ['Title']'
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        Say ' > failed to create ['Title' | 'Class'] at location ['Location']'
    return rc

CreateShadow: procedure
    Parse Arg Original, Location
    Say 'Creating Shadow of 'Original
    rc = SysCreateShadow( Original, Location )
    If rc <> 1 Then
        Say ' > failed to create shadow of 'Original' at location ['Location']'
    return rc

CreateObjects:

current_dir = directory()

/***************/
/* MAIN FOLDER */

rc = CreateObject( 'WPFolder',,
    'Accounts',,
    '<WP_DESKTOP>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,NORMAL;'||,
        'ALWAYSSORT=YES;'||,
        'ICONFILE='||current_dir||'\folder.ico;'||,
        'OBJECTID=<Accounts_folder>',,
    CreateCollision )

/*******************/
/* PROGRAM OBJECT  */

  rc = CreateObject( 'WPProgram',,
      'Accounts',,
      '<Accounts_folder>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||current_dir||'\ACCOUNTS.EXE;'||,
          'STARTUPDIR='||current_dir||';'||,
          'MINIMIZED=NO;'||,
          'PROGTYPE=FULLSCREEN;'||,
          'OBJECTID=<Accounts_program>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Accounts Manual',,
      '<Accounts_folder>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||'VIEW.EXE;'||,
          'PARAMETERS='||current_dir||'\ACCOUNTS.INF;'||,
          'STARTUPDIR='||current_dir||';'||,
          'MINIMIZED=NO;'||,
          'OBJECTID=<Accounts_Manual>',,
      CreateCollision )

  rc = CreateObject( 'WPURL',,
      "Author's web page",,
      '<Accounts_folder>',,
      'NOPRINT=YES;'||,
          'URL=http://eepjm.newcastle.edu.au/',,
      CreateCollision )

return

