/* 
Rexx script fr ZOC MausTausch.

Autor: Carsten Hrle
Version: 1.0
Datum: 28.12.94

Beim Aufruf ist das aktuelle Verzeichnis das Emis/PM-Verzeichnis.
Als Parameter wird das Verzeichnis der Mitteilungsbank bergeben.
Dort befindet sich ein INFILE.ZIP und wird ein OUTFILE.ZIP hinterlassen.
*/
arg msgBaseDir

/* Variablen setzen */
mmDir = directory()
Call directory msgBaseDir 
zocdir = linein('zocmt.cfg')
zocdownload = linein('zocmt.cfg')

/* Variablen prfen */
if zocdir = "" || zocdownload = "" Then
	Error("Die Datei 'zocmt.cfg' nicht vorhanden", 10100)

/* Erstelle Hilfsskript fr ZOC */
'del zocmt1.scr'
if stream('zocmt1.scr', 'c', 'open write') \= 'READY:' Then 
	Error("Die Hilfsdatei 'zocmt1.scr' konnte nicht erstellt werden.", 10103)
if lineout('zocmt1.scr', 'extern "' || mmdir || '\zocmt.scr" "' || msgBaseDir || '"') \= 0 Then
	Error("Die Hilfsdatei 'zocmt1.scr' konnte nicht erstellt werden.", 10103)
if stream('zocmt1.scr', 'c', 'close') \= 'READY:' Then
	Error("Die Hilfsdatei 'zocmt1.scr' konnte nicht erstellt werden.", 10103)


/* Starte ZOC */
'del' zocdownload || '\outfile.*'
call directory zocdir 
'zoc /u /s:' || msgBaseDir || '\zocmt1.scr'
'copy' zocdownload || '\outfile.zip' msgBaseDir 
'del' zocdownload || '\outfile.zip'
Exit 0

/* Fehlerbehandlung */
Error:
Say "FEHLER ("arg(2)"): " arg(1)
Exit arg(2)
