/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                OS/2 2.0 SLIP Driver for IBM TCP/IP version 2.0           */
/*                                                                          */
/*                              Provider.cmd                                */
/*                                                                          */
/*            ..................................................            */
/*                                                                          */
/* Sample attachment script for dialing into Uni Mannheim     terminal      */
/* server in order to establish a SLIP connection.  This script should be   */
/* specified using the "attachcmd" and "attachparm" elements in the SLIP    */
/* configuration file SLIP.CFG.  For example:                               */
/*                                                                          */
/*              interface sl0 {                                             */
/*                 attachcmd  = slipup                                      */
/*                 attachparm = "dialcmd username password"                 */
/*              }                                                           */
/*                                                                          */
/* The script parameters specify the command to send to the modem to dial   */
/* the remote site and the username/password combination to use to log into */
/* the terminal server.  If any of the parameters are omitted, or are       */
/* specified as an asterix (*), the script will prompt for them.  This is   */
/* most useful with the password parameter to avoid storing the password    */
/* in a text file on the disk.                                              */
/*                                                                          */
/* For example, the following might be how I would set it up:               */
/*                                                                          */
/*              interface sl0 {                                             */
/*                 attachcmd  = slipup                                      */
/*                 attachparm = "atdt###-#### db3l *"                       */
/*              }                                                           */
/*                                                                          */
/* which would cause slipup to initially prompt me for the password.  It    */
/* would then feed the "atdt###-####" command to the modem, and when the    */
/* Annex answered, it would use "db3l" as a username and the password I     */
/* initially entered as the password.                                       */
/*                                                                          */
/*            - - - - - - - - - - - - - - - - - - - - - - - - -             */
/*                                                                          */
/* When the script runs, it is automatically passed the interface name for  */
/* the interface it is running on as the first argument, and the user       */
/* arguments (from SLIP.CFG) as the second argument.                        */
/*                                                                          */
/* The script sends the dial string to the modem and then logs into the     */
/* terminal server using the username/password.  It then issues the SLIP    */
/* command to start SLIP, and parses the resulting output to determine the  */
/* appropriate addresses to use.  Lastly, it issues ifconfig and route      */
/* commands to configure the OS/2 system appropriately.  Note that the      */
/* configuration assumes a class C netmask for the SLIP interface.          */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* If you want to play a .wav after connection */
/* no .wav -> wavfile="" */
/* wavfile="C:\MMOS2\SOUNDS\DRUMROLL.WAV"*/
wavfile=""

parse arg interface , dialcmd username password
 
call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'
  
/*--------------------------------------------------------------------------*/
/*                   Initialization and Main Script Code                    */
/*--------------------------------------------------------------------------*/

/* Set some definitions for easier COM strings */
cr='0d'x
crlf='0d0a'x
lfcr='0a0d'x

say ''
say 'Provider - SLIP example script, please configure provider.cmd ',
    '(interface' interface')'

/* Prompt for missing information */
if dialcmd = '' then do
   call charout , 'Dial Command: '
   parse pull dialcmd
end
if username = '' | username = '*' then do
   call charout , 'User Name: '
   parse pull username
end
else do
   say 'User:' username
end
if password = '' | password = '*' then do
   call charout , 'Password: '
   password = readpass()
end

/* cFos, V110*/
call send "AT&FS10.3=1S10.0=1S19=4X7&L0&E0B1S17=0" || cr 
/* ISDNCOM */
/* call send "AT&Fv2x7&d2b1s15=x0700" || cr */
call SysSleep 1

/* Flush any stuff left over from previous COM activity */
call flush_receive


/* Wait for connection */

/* Dial until CONNECT message */

do until zeile = "CONNECT"
  call charout , 'Now Dialing...'
  call send dialcmd || cr
  call waitfor cr
  call waitfor crlf
  do until zeile\="RINGING"
    call waitfor crlf
    zeile=word(translate(waitfor_buffer," ",cr),1)
    if zeile="RINGING" then do
      call waitfor crlf
      zeile="RINGING"
    end
  end
  if zeile \="CONNECT" then do
    say "Waiting 30s"
    call SysSleep 30
  end
end

/* Handle login.  We wait for standard strings, and then flush anything */
/* else to take care of trailing spaces, etc..                          */

call send cr
call waitfor 'login:' ; call flush_receive 'echo'
call SysSleep 1
call send cr
call waitfor 'login:' ; call flush_receive 'echo'
call send 'modem' || cr

call waitfor 'sorum>' ; call flush_receive 'echo'
call send '1' || cr

call waitfor 'login:' ; call flush_receive 'echo'
call send username || cr
call waitfor 'Password:' ; call flush_receive 'echo'
call send password || cr

/* Wait for the main prompt and then send the "slirp" command */
call waitfor 'rummel:[' ; call flush_receive 'echo'
call send 'slirp' || cr


unima_address = '134.155.50.46'
os2_address = '10.0.2.15'


/* Parse the results of the SLIP command to determine our address. */
/* We use the "waitfor_buffer" variable from the waitfor routine   */
/* to parse the stuff we get from the Annex after waiting for an   */
/* appropriate point in the data stream.                           */

/*
call waitfor 'IP address of Slirp host:'
call waitfor 'Your address'
unima_address=waitfor_buffer
unima_address=translate(unima_address,' ',cr)
unima_address=word(unima_address,2)

call waitfor 'SLiRP Ready'
os2_address=waitfor_buffer
os2_address=translate(os2_address,' ',cr)
os2_address=word(os2_address,2)
*/

/* Flush anything else */
call flush_receive 'echo'

/* Now configure this host for the appropriate address, */
/* and for a default route through the slip connection. */
say 'SLIP Connection Established'
say 'Configuring local address =' os2_address ', Uni Mannheim =' unima_address

'ifconfig sl0' os2_address unima_address 'netmask 255.255.255.0'
'route -f add default' unima_address '1'

/* All done */
if wavfile\="" then
  address CMD "playv VOLUME=80 FILE="||wavfile
else do
  call beep 444, 200
  call beep 590, 40
  call beep 790, 400
  call beep 750, 150
  call beep 590, 150
  call beep 500, 200
  call beep 670, 200
  call beep 900, 400
end

exit 0


/*--------------------------------------------------------------------------*/
/*                            send ( sendstring)                            */
/*..........................................................................*/
/*                                                                          */
/* Routine to send a character string off to the modem.                     */
/*                                                                          */
/*--------------------------------------------------------------------------*/

send:

   parse arg sendstring
   call slip_com_output interface , sendstring

   return


/*--------------------------------------------------------------------------*/
/*                    waitfor ( waitstring , [timeout] )                    */
/*..........................................................................*/
/*                                                                          */
/* Waits for the supplied string to show up in the COM input.  All input    */
/* from the time this function is called until the string shows up in the   */
/* input is accumulated in the "waitfor_buffer" variable.                   */
/*                                                                          */
/* If timeout is specified, it says how long to wait if data stops showing  */
/* up on the COM port (in seconds).                                                         */
/*                                                                          */
/*--------------------------------------------------------------------------*/

waitfor:

   parse arg waitstring , timeout

   if timeout = '' then
     timeout = 5000    /* L O N G   delay if not specified */
   waitfor_buffer = '' ; done = -1; curpos = 1
   ORI_TIME=TIME('E')

   if (remain_buffer = 'REMAIN_BUFFER') then do
      remain_buffer = ''
   end

   do while (done = -1)
      if (remain_buffer \= '') then do
         line = remain_buffer
         remain_buffer = ''
       end
       else do
         line = slip_com_input(interface,,10)
      end
      waitfor_buffer = waitfor_buffer || line
      index = pos(waitstring,waitfor_buffer)
      if (index > 0) then do
         remain_buffer = substr(waitfor_buffer,index+length(waitstring))
         waitfor_buffer = delstr(waitfor_buffer,index+length(waitstring))
         done = 0
      end
      call charout , substr(waitfor_buffer,curpos)
      curpos = length(waitfor_buffer)+1
      if ((done \= 0) & (TIME('E')>timeout)) then do
        call lineout , ' WAITFOR: timed out '
        done = 1
       end
   end
   timeout=0
   RC=done
 return RC



/*--------------------------------------------------------------------------*/
/*                               readpass ()                                */
/*..........................................................................*/
/*                                                                          */
/* Routine used to read a password from the user without echoing the        */
/* password to the screen.                                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

readpass:

  answer = ''
  do until key = cr
    key = slip_getch()
    if key \= cr then do
      answer = answer || key
    end
  end
  say ''
  return answer


/*--------------------------------------------------------------------------*/
/*                             flush_receive ()                             */
/*..........................................................................*/
/*                                                                          */
/* Routine to flush any pending characters to be read from the COM port.    */
/* Reads everything it can until nothing new shows up for 100ms, at which   */
/* point it returns.                                                        */
/*                                                                          */
/* The optional echo argument, if 1, says to echo flushed information.      */
/*                                                                          */
/*--------------------------------------------------------------------------*/

flush_receive:

   parse arg echo

   /* If echoing the flush - take care of waitfor remaining buffer */
   if (echo \= '') & (length(remain_buffer) > 0) then do
      call charout , remain_buffer
      remain_buffer = ''
   end

   /* Eat anything left in the modem or COM buffers */
   /* Stop when nothing new appears for 100ms.      */

   do until line = ''
     line = slip_com_input(interface,,100)
     if echo \= '' then
        call charout , line
   end

   return
