/* ********************************************************************* */
/* FILE: Mandel.c */
/* By: Arnd Kobus */
/* Begin: march, 16 '94 under DOS on Borland C */
/* Code Speedup factor 3.5 on june, 2/3 '94 */
/* ported to OS/2 on february, 25 '97 */
/* last change: february, 27 '97 */
/* function: show the mandelbrot set */
/* ********************************************************************* */
#define INCL_WIN
#define INCL_GPI
#define INCL_WINWINDOWMGR
#define INCL_DOSPROCESS
#define INCL_DOSSEMAPHORES

#include <os2.h>
#include <stddef.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "mandel.h"
#include "gif.h"

HAB hAB;
HMQ hMsgQ;
HDC hdc, hdcMemory;
HPS hps, hpsMemory;
HPAL hpal;
HWND hwndMandel;
HWND hwndMandelFrame;
HMODULE hmod;
HMTX hmtxLock;
TID ThreadID = 0;		/* Thread identification */

/* Write-once global variables */
char szMandelName[10];
char szKidName[10];
ULONG style = FCF_STANDARD;


BYTE *Bitmap = NULL;
HBITMAP hbm = 0;
BITMAPINFOHEADER2 bmih, bmp2data;
PBITMAPINFO2 pbmi = NULL;

POINTL aptl[3] =
{0, 0, 640, 480, 0, 0};
/* Defines range for GpiBitBlt(): lower left corner target, upper right
   corner target, lower left corner source. If there's no stretching or
   squeezing, third parameter = 3, otherwise 4. If so, you must provide a
   fourth parameter (upper right corner source) */

static float pmin = -2.25, pmax = 0.75, qmin = -1.5, qmax = 1.5;
static int maxx, maxy;
/* maxx is the X-resolution, maxy the Y-resolution, pmin and pmax just like
   qmin and qmax are the according boundaries of X and Y in the mandelbrot
   set.	 */

int M = 4, K = 50;
/* M is maximum distance from Origin (0,0). K is the color depth (==
   iterations calculated) */

/* Color Palette for gif */
static int Red[256], Green[256], Blue[256];
static ULONG cclr = 256;

/************************************************************************/
int main ()
{
  int i;
  QMSG qMsg;
  /************************************************************************/

  for (i = 0; i < 256; i++)
    Red[i] = Green[i] = Blue[i] = i;

  hAB = WinInitialize (0);
  hMsgQ = WinCreateMsgQueue (hAB, 0);

  WinLoadString (hAB, hmod, IDSNAME, sizeof (szMandelName), szMandelName);

  /* Register class MandelWndProc to process user input. */
  /* The name is chosen as szMandelName, which has to be used with
     WinRegisterClass() */

  if (!WinRegisterClass (hAB, (PSZ) szMandelName, (PFNWP) MandelWndProc,
			 CS_CLIPCHILDREN | CS_SIZEREDRAW, 0))
    return (FALSE);

  /* Create main window of class szMandelName */
  hwndMandelFrame = WinCreateStdWindow (
					 HWND_DESKTOP,	/* Desktop is parent
							   window  */
					 FS_ICON | FS_ACCELTABLE,	/* Frame style */
					 &style,
					 (PSZ) szMandelName,	/* Name of window class
								   like in
								   WinRegisterClass   */
					 (PSZ) "Mandelbrot",	/* Program name in title
								   bar */
					 0,	/* Client window Style */
					 0,	/* Ressources come from .EXE
						   file     */
					 ID_MANDEL,	/* ID for menu,
							   accelerator and icon */
					 (HWND FAR *) & hwndMandel);	/* Client window handle  */

  WinSetWindowPos (hwndMandelFrame, HWND_TOP, 100, 200, 400,
		   340, SWP_ZORDER | SWP_SIZE | SWP_MOVE |
		   SWP_SHOW | SWP_ACTIVATE);


  while (WinGetMsg (hAB, (PQMSG) & qMsg, (HWND) NULL, 0, 0))
    {
      WinDispatchMsg (hAB, (PQMSG) & qMsg);	/* calls window procedure */
    }

  WinDestroyWindow (hwndMandelFrame);
  WinDestroyMsgQueue (hMsgQ);
  WinTerminate (hAB);
}				/* main */


/************************************************************************/
MRESULT
MandelWndProc (HWND hWnd, USHORT message, MPARAM mp1, MPARAM mp2)
{
  SIZEL sizlPSPage;
  POINTL ptl;
  static POINTL ptlMouPos;
  static POINTL draw_begin, draw_end;
  static LONG palette[33];
  static BOOL Btn1Dwn = FALSE, First = TRUE;

  int x, y;
  static FILEDLG pfdFileDialog;
  /************************************************************************/

  switch (message)
    {
    case WM_CLOSE:
      if (Bitmap != NULL)
	DosFreeMem (Bitmap);
      if (hbm != 0)
	GpiDeleteBitmap (hbm);
      if (pbmi != NULL)
	DosFreeMem (&pbmi);
      if (ThreadID != 0)
	DosKillThread (ThreadID);
      GpiSelectPalette (hps, NULLHANDLE);
      WinRealizePalette (hwndMandel, hps, &cclr);
      GpiAssociate (hps, NULLHANDLE);
      GpiDestroyPS (hps);
      WinPostMsg (hWnd, WM_QUIT, 0L, 0L);
      break;

    case WM_COMMAND:
      switch (LOUSHORT (mp1))
	{
	case IDSAVE:
	  memset (&pfdFileDialog, 0, sizeof (FILEDLG));
	  pfdFileDialog.cbSize = sizeof (FILEDLG);
	  pfdFileDialog.fl = FDS_CENTER | FDS_SAVEAS_DIALOG |
	    FDS_ENABLEFILELB;
	  pfdFileDialog.pszTitle = "Mandel - save GIF";
	  pfdFileDialog.pszOKButton = "save";
	  strcpy (pfdFileDialog.szFullFile, "*.gif");
	  WinFileDlg (HWND_DESKTOP, HWND_DESKTOP, &pfdFileDialog);
	  if (pfdFileDialog.lReturn == DID_OK)
	    _beginthread (SaveThread, 0, 8192, &pfdFileDialog.szFullFile);
	  break;

	case IDPALETTE:
	  memset (&pfdFileDialog, 0, sizeof (FILEDLG));
	  pfdFileDialog.cbSize = sizeof (FILEDLG);
	  pfdFileDialog.fl = FDS_CENTER | FDS_OPEN_DIALOG |
	    FDS_ENABLEFILELB;
	  pfdFileDialog.pszTitle = "Mandel - open Palette";
	  pfdFileDialog.pszOKButton = "open";
	  strcpy (pfdFileDialog.szFullFile, "*.map");
	  DosSetCurrentDir ("map");
	  WinFileDlg (HWND_DESKTOP, HWND_DESKTOP, &pfdFileDialog);
	  if (pfdFileDialog.lReturn == DID_OK)
	    readmap (pfdFileDialog.szFullFile);
	  DosSetCurrentDir ("..");
	  break;

	case IDRESET:
	  if (!(pmin == -2.25 && pmax == 0.75 && qmin == -1.5 && qmax == 1.5))
	    {
	      pmin = -2.25;
	      pmax = 0.75;
	      qmin = -1.5;
	      qmax = 1.5;
	      WinSendMsg (hWnd, WM_SIZE, 0L, 0L);
	    }
	  break;

	case IDPARAM:
	  WinDlgBox (HWND_DESKTOP, hWnd, (PFNWP) ParamDlgProc, 0, IDD_PARAM,
		     NULL);

	  break;

	case IDABOUT:
	  WinDlgBox (HWND_DESKTOP, hWnd, (PFNWP) AboutDlgProc, 0, IDD_ABOUT,
		     NULL);
	  break;

	default:
	  break;
	}
      break;

    case WM_BUTTON1DOWN:
      Btn1Dwn = TRUE;
      draw_begin.x = SHORT1FROMMP (mp1);
      draw_begin.y = SHORT2FROMMP (mp1);
      break;

    case WM_BUTTON1UP:
      Btn1Dwn = FALSE;
      WinSetWindowPos (hwndMandelFrame, HWND_TOP, 0, 0, 0, 0, SWP_ZORDER |
		       SWP_SHOW | SWP_ACTIVATE);

      draw_end.x = SHORT1FROMMP (mp1);
      draw_end.y = SHORT2FROMMP (mp1);
      if ((draw_end.x - draw_begin.x > 10) && (draw_begin.y - draw_end.y > 10))
	{
	  float pdiff, qdiff, oldpmin, oldqmin;
	  pdiff = pmax - pmin;
	  qdiff = qmax - qmin;
	  oldpmin = pmin;
	  oldqmin = qmin;
	  pmin = oldpmin + pdiff * (draw_begin.x / (float) maxx);
	  pmax = oldpmin + pdiff * (draw_end.x / (float) maxx);
	  qmax = oldqmin + qdiff * (draw_begin.y / (float) maxy);
	  qmin = oldqmin + qdiff * (draw_end.y / (float) maxy);
	  WinSendMsg (hWnd, WM_SIZE, 0L, 0L);
	}
      break;

    case WM_MOUSEMOVE:
      if (Btn1Dwn)
	{
	  GpiOpenSegment (hps, 1);
	  GpiSetDrawingMode (hps, DM_RETAIN);
	  GpiSetMix (hps, FM_XOR);
	  GpiSetTag (hps, 1);
	  GpiSetLineType (hps, LINETYPE_DOT);
	  GpiSetColor (hps, CLR_RED);
	  GpiSetCurrentPosition (hps, &draw_begin);

	  if (!First)
	    GpiBox (hps, DRO_OUTLINE, &ptlMouPos, 0L, 0L);
	  ptlMouPos.x = SHORT1FROMMP (mp1);
	  ptlMouPos.y = SHORT2FROMMP (mp1);
	  if (ptlMouPos.x < draw_begin.x)
	    ptlMouPos.x = draw_begin.x;
	  if (ptlMouPos.y > draw_begin.y)
	    ptlMouPos.y = draw_begin.y;
	  GpiSetCurrentPosition (hps, &draw_begin);
	  GpiBox (hps, DRO_OUTLINE, &ptlMouPos, 0L, 0L);
	  GpiCloseSegment (hps);
	  GpiDrawSegment (hps, 1);
	  GpiDeleteSegment (hps, 1);
	  First = FALSE;
	}
      break;

    case WM_CREATE:
      /* Create presentation space for screen. */
      hdc = WinOpenWindowDC (hWnd);
      sizlPSPage.cx = 0L;
      sizlPSPage.cy = 0L;
      hps = GpiCreatePS (hAB, hdc, &sizlPSPage,
			 PU_PELS | GPIT_NORMAL | GPIA_ASSOC | GPIF_DEFAULT);

      sizlPSPage.cx = 0L;
      sizlPSPage.cy = 0L;
      /* Create presentation space for memory image of screen. */
      hdcMemory = DevOpenDC (hAB, OD_MEMORY, (PSZ) "*", 0L, 0L, 0L);
      hpsMemory = GpiCreatePS (hAB, hdcMemory, &sizlPSPage,
			  PU_PELS | GPIT_MICRO | GPIA_ASSOC | GPIF_DEFAULT);
      readmap ("map/default.map");
      break;

    case WM_SIZE:
      if (mp2 != 0)
	{
	  aptl[1].x = maxx = SHORT1FROMMP (mp2);
	  aptl[1].y = maxy = SHORT2FROMMP (mp2);
	}

      if (Bitmap != NULL)
	DosFreeMem (Bitmap);
      DosAllocMem ((PPVOID) & Bitmap, (maxx + 3) * (maxy + 11),
		   PAG_COMMIT | PAG_READ | PAG_WRITE);	/* Allocate some space
							   for Bitmap. We go up
							   to (maxx + 3) and
							   (maxy + 11) in the
							   loop. */
      /* Create bitmap for memory image of screen. */
      memset (&bmih, 0, sizeof (BITMAPINFOHEADER2));	/* Set memory to 0 */
      bmih.cbFix = sizeof (BITMAPINFOHEADER2);
      bmih.cx = maxx;
      bmih.cy = maxy;
      bmih.cPlanes = 1;
      bmih.cBitCount = 8;
      if (hbm != 0)
	GpiDeleteBitmap (hbm);
      hbm = GpiCreateBitmap (hpsMemory, &bmih, 0L, NULL, NULL);
      GpiSetBitmap (hpsMemory, hbm);	/* Set the Bitmap as the current
					   Bitmap */

      bmp2data.cbFix = 16L;
      GpiQueryBitmapInfoHeader (hbm, &bmp2data);	/* Get Information about
							   bitmap identified by
							   handle hbm */

      if (pbmi != NULL)
	DosFreeMem (&pbmi);
      DosAllocMem ((PPVOID) & pbmi, sizeof (BITMAPINFO2) +
		   (sizeof (RGB2) * (1 << bmp2data.cPlanes) *
		    (1 << bmp2data.cBitCount)),
		   PAG_COMMIT | PAG_READ | PAG_WRITE);	/* Allocate some space
							   for pbmi */
      pbmi->cbFix = bmp2data.cbFix;
      pbmi->cx = bmp2data.cx;
      pbmi->cy = bmp2data.cy;
      pbmi->cPlanes = bmp2data.cPlanes;
      pbmi->cBitCount = bmp2data.cBitCount;
      pbmi->ulCompression = bmp2data.ulCompression;
      pbmi->cbImage = bmp2data.cbImage;
      pbmi->cxResolution = bmp2data.cxResolution;
      pbmi->cyResolution = bmp2data.cyResolution;
      pbmi->cclrUsed = bmp2data.cclrUsed;
      pbmi->cclrImportant = bmp2data.cclrImportant;
      pbmi->usUnits = bmp2data.usUnits;
      pbmi->usReserved = bmp2data.usReserved;
      pbmi->usRecording = bmp2data.usRecording;
      pbmi->usRendering = bmp2data.usRendering;
      pbmi->cSize1 = bmp2data.cSize1;
      pbmi->cSize2 = bmp2data.cSize2;
      pbmi->ulColorEncoding = bmp2data.ulColorEncoding;
      pbmi->ulIdentifier = bmp2data.ulIdentifier;
      GpiQueryBitmapBits (hpsMemory, 0L, maxy, &Bitmap[0], pbmi);	/* important */

      DosCreateMutexSem ("\\sem32\\Lock", &hmtxLock, 0, FALSE);
      if (ThreadID != 0)
	DosKillThread (ThreadID);
      ThreadID = _beginthread (CalcThread, 0, 8192, MAKEULONG (maxx, maxy));
      break;

    case WM_PAINT:
      DosRequestMutexSem (hmtxLock, SEM_INDEFINITE_WAIT);
      WinBeginPaint (hwndMandel, hps, NULL);
      /* Select new palette into presentation space */
      GpiSelectPalette (hps, hpal);
      /* Request current palette be applied to physical device palette */
      WinRealizePalette (hwndMandel, hps, &cclr);
      GpiBitBlt (hps, hpsMemory, 3L, aptl, ROP_SRCCOPY, BBO_AND);	/* simple copying
									   without squeezing */
      WinEndPaint (hps);
      DosReleaseMutexSem (hmtxLock);
      First = TRUE;
      break;

    default:			/* let all other events be handled by Default
				   Window Procedure */
      return WinDefWindowProc (hWnd, message, mp1, mp2);
      break;

    }
  return 0;
}				/* MandelWndProc */


/************************************************************************/
MRESULT EXPENTRY
ParamDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
     /* Set Parameters */
{
  char stringbuf[20];
  /************************************************************************/

  switch (msg)
    {
    case WM_INITDLG:
      sprintf (stringbuf, "%f", pmin);
      WinSetWindowText (WinWindowFromID (hwnd, ID_xmin),
			stringbuf);
      sprintf (stringbuf, "%f", pmax);
      WinSetWindowText (WinWindowFromID (hwnd, ID_xmax),
			stringbuf);
      sprintf (stringbuf, "%f", qmin);
      WinSetWindowText (WinWindowFromID (hwnd, ID_ymin),
			stringbuf);
      sprintf (stringbuf, "%f", qmax);
      WinSetWindowText (WinWindowFromID (hwnd, ID_ymax),
			stringbuf);
      sprintf (stringbuf, "%d", K);
      WinSetWindowText (WinWindowFromID (hwnd, ID_K),
			stringbuf);
      sprintf (stringbuf, "%d", M);
      WinSetWindowText (WinWindowFromID (hwnd, ID_M),
			stringbuf);
      break;

    case WM_COMMAND:
      switch (SHORT1FROMMP (mp1))
	{
	case DID_OK:
	  WinQueryWindowText (WinWindowFromID (hwnd, ID_xmin),
			      sizeof (stringbuf), stringbuf);
	  if (stringbuf[0] == 0)
	    sprintf (stringbuf, "0");
	  sscanf (stringbuf, "%f", &pmin);

	  WinQueryWindowText (WinWindowFromID (hwnd, ID_xmax),
			      sizeof (stringbuf), stringbuf);
	  if (stringbuf[0] == 0)
	    sprintf (stringbuf, "0");
	  sscanf (stringbuf, "%f", &pmax);

	  WinQueryWindowText (WinWindowFromID (hwnd, ID_ymin),
			      sizeof (stringbuf), stringbuf);
	  if (stringbuf[0] == 0)
	    sprintf (stringbuf, "0");
	  sscanf (stringbuf, "%f", &qmin);

	  WinQueryWindowText (WinWindowFromID (hwnd, ID_ymax),
			      sizeof (stringbuf), stringbuf);
	  if (stringbuf[0] == 0)
	    sprintf (stringbuf, "0");
	  sscanf (stringbuf, "%f", &qmax);

	  WinQueryWindowText (WinWindowFromID (hwnd, ID_K),
			      sizeof (stringbuf), stringbuf);
	  if (stringbuf[0] == 0)
	    sprintf (stringbuf, "0");
	  sscanf (stringbuf, "%d", &K);

	  WinQueryWindowText (WinWindowFromID (hwnd, ID_M),
			      sizeof (stringbuf), stringbuf);
	  if (stringbuf[0] == 0)
	    sprintf (stringbuf, "0");
	  sscanf (stringbuf, "%d", &M);
	  WinDismissDlg (hwnd, TRUE);
	  WinSendMsg (hwndMandel, WM_SIZE, 0L, 0L);
	  break;
	case DID_CANCEL:
	  WinDismissDlg (hwnd, TRUE);
	  break;
	}
      break;
    default:
      return WinDefDlgProc (hwnd, msg, mp1, mp2);
    }
  return (MRESULT) FALSE;
}				/* ParamDlgProc */


/************************************************************************/
MRESULT
AboutDlgProc (HWND hWndDlg, USHORT message, MPARAM mp1, MPARAM mp2)
{
  /************************************************************************/
  switch (message)
    {
    case WM_COMMAND:
      switch (LOUSHORT (mp1))
	{
	case DID_OK:
	  WinDismissDlg (hWndDlg, TRUE);
	  break;

	default:
	  break;
	}
      break;

    default:
      return WinDefDlgProc (hWndDlg, message, mp1, mp2);
    }
  return FALSE;
}				/* AboutDlgProc */


/************************************************************************/
int
GetPixel (int x, int y)
{
  /************************************************************************/
  return (Bitmap[x + maxx * (maxy - y)]);
}


/************************************************************************/
int
readmap (char *path)
{
  FILE *file;
  char ch;

  int i;
  ULONG red = 0;
  ULONG green = 0;
  ULONG blue = 0;
  /* Color table */
  ULONG lColorsRGB[256];

  static HPAL hpalOld;
  /************************************************************************/

  cclr = 256;			/* Number of changed colors */
  file = fopen (path, "r");
  if (file == NULL)
    {
      char stringbuf[256];
      sprintf (stringbuf, "The file %s was not found", path);
      WinMessageBox (HWND_DESKTOP, hwndMandel, stringbuf,
		     "Mandel - load map - ERROR", 0,
		     MB_OK | MB_ERROR | MB_APPLMODAL | MB_MOVEABLE);
      return (-1);
    }

  do
    ch = fgetc (file);
  while (ch != '\n');

  for (i = 0; i < 256; i++)
    fscanf (file, "%d %d %d", &Red[i], &Green[i], &Blue[i]);
  fclose (file);

  for (i = 0; i < cclr; i++)
    {
      red = Red[i];
      green = Green[i];
      blue = Blue[i];
      lColorsRGB[i] = (PC_RESERVED * 16777216) + (red * 65536) + (green * 256) + blue;
    }

  if (hpalOld != NULLHANDLE)
    GpiDeletePalette (hpalOld);

  /* Create palette (must use RGB type color table for this) */
  hpal = GpiCreatePalette (hAB, /* LCOL_PURECOLOR */ 0, LCOLF_CONSECRGB,
			   cclr, (PULONG) lColorsRGB);

  /* Select new palette into both (!) presentation spaces */
  GpiSelectPalette (hps, hpal);
  GpiSelectPalette (hpsMemory, hpal);
  /* Request current palette be applied to physical device palette */
  WinRealizePalette (hwndMandel, hps, &cclr);
  WinRealizePalette (hwndMandel, hpsMemory, &cclr);
  WinInvalidateRect (hwndMandel, NULL, TRUE);
  return (0);
}				/* readmap */


/************************************************************************/
void APIENTRY
SaveThread (char *path)
{

  /************************************************************************/

  GIFEncode (path,		/* The filename to write */
	     maxx,		/* The width of the bitmap - an int */
	     maxy,		/* The height of the bitmap - an int */
	     FALSE,		/* TRUE if you want the image to be
				   interlaced, FALSE otherwise */
	     0,			/* The colour index of the background */
	     8,			/* The number of bits of color per pixel in
				   the palette you specified. If your palette
				   has 256 colours, it should be '8', 32
				   should be '5', etc */
	     Red, Green, Blue,	/* Pointers to arrays of unsigned int's,
				   containing the R, G and B values of the
				   colour palette */

	     GetPixel);		/* a pointer to a function that returns the
				   index of the colour at the co-ordinates
				   passed */
  DosExit (EXIT_THREAD, 0);	/* This is how you end a Thread */
}				/* SaveThread */


/************************************************************************/
void APIENTRY
CalcThread (ULONG mp)
{
  static float dp, _2dp, dq, p, q;

  ULONG maxx, maxy, x, y, maxx_y, local_maxx;
  /* maxx is the X-resolution, maxy the Y-resolution, pmin and pmax just like
     qmin and qmax are the according boundaries of X and Y in the mandelbrot
     set. x and y are the variables used for counting through the screen.	 */

  USHORT i;
  static int c_up;		/* Count up */
  /************************************************************************/

  maxx = SHORT1FROMMP (mp);
  maxy = SHORT2FROMMP (mp);


  dp = (pmax - pmin) / maxx;	/* step width in the mandelbrot set */
  _2dp = 2 * dp;
  dq = (qmax - qmin) / maxy;
  c_up = 0;

  do
    {
      /* I'm exploiting the fact that in the mandelbrot set, there are
         regions, where the color is constant over a certain distance. I will
         only calculate every second Pixel, and if they're equal, I will
         assume the Pixel between as equal, too. You could go further and
         skip two pixels instead of one, but that is in my opinion too risky,
         because we deal with caotic systems. */
      for (y = c_up, q = qmin + c_up * dq; y <= maxy; y += 10, q += 10 * dq)
	{
	  maxx_y = maxx * y;
	  local_maxx = maxx_y + maxx;
	  for (x = maxx_y, p = pmin; x <= local_maxx; x += 2, p += _2dp)
	    {
	      Bitmap[x] = Mandelbrot (p, q);
	      if (x == maxx_y)
		continue;	/* First Pixel in a row */

	      if ((Bitmap[x] == Bitmap[x - 2]) && (x < local_maxx - 1))	/* maxx-1 because we can
									   have odd maxx */
		{		/* If both Pixels have identical color, the
				   Pixel in between is most likely of the
				   same color. We only copy the color instead
				   of calculating it. */
		  Bitmap[x - 1] = Bitmap[x];
		  continue;
		}
	      else
		{		/* Otherwise calculate the color */
		  Bitmap[x - 1] = Mandelbrot (p - dp, q);
		}
	    }
	  DosRequestMutexSem (hmtxLock, SEM_INDEFINITE_WAIT);
	  GpiSetBitmapBits (hpsMemory, y, (LONG) 1, &Bitmap[y * maxx], pbmi);
	  DosReleaseMutexSem (hmtxLock);
	}
      c_up++;
      WinInvalidateRect (hwndMandel, NULL, TRUE);
    }
  while (c_up != 10);
  ThreadID = 0;
  DosExit (EXIT_THREAD, 0);	/* This is how you end a Thread */
}				/* CalcThread */


/************************************************************************/
int
Mandelbrot (p, q)
     float p, q;
{
  register int k;
  float x, y, xquadr, yquadr;
  /************************************************************************/

  x = p;
  y = q;
  xquadr = x * x;
  yquadr = y * y;

  for (k = 0; ((k < K) && (xquadr + yquadr) <= M); k++)
    {
      y = 2 * x * y + q;	/* The *OLD* x is used ! */
      x = xquadr - yquadr + p;
      xquadr = x * x;
      yquadr = y * y;
    }

  if (k == K)
    k = 0;			/* color within the mandelbrot set  */
  return (k);
}				/* Mandelbrot */


/* ************************************************************** */
/* END OF FILE */
/* ************************************************************** */
